/************************************************************************************************/
/* Stata User File for H105 Data                                                                 */
/*                                                                                              */
/* This file contains information and a sample Stata program to create a permanent              */
/* Stata dataset for users who want to use Stata in processing the MEPS data provided           */
/* in this PUF release.  Stata (StataCorp) has the capability to produce                        */
/* appropriate standard errors for estimates from a survey with a complex sample                */
/* design such as the Medical Expenditure Panel Survey (MEPS).                                  */
/* The input file for creating a permanent Stata dataset is the ASCII data file                 */
/* (H105.DAT) supplied in this PUF release, which in turn can be extracted from the              */
/* .EXE file. After entering the Stata interactive environment access the Stata DO-File         */
/* editor by clicking on the appropriate icon in the command line at the top of the             */
/* screen.  Copy and paste the following Stata commands into the editor and save as a           */
/* DO file.  A DO file is a Stata program which may then be executed using the DO command.      */
/* For example, if the DO file is named H105.DO and is located in the directory                  */
/* C:\MEPS\PROG, then the file may be executed by typing the following command into             */
/* the Stata command line:                                                                      */
/*                         do C:\MEPS\PROG\H105.DO                                               */
/* The program below will output the Stata dataset H105.DTA                                      */
/************************************************************************************************/


#delimit ;
cd $datadir/MEPS/dat/fullyearconsolidated;
clear;

* INPUT ALL VARIABLES;
infix
  long   DUID 1-5
  int    PID 6-8
  str    DUPERSID 9-16
  byte   PANEL 17-18
  str    FAMID31 19-20
  str    FAMID42 21-22
  str    FAMID53 23-24
  str    FAMID06 25-26
  str    FAMIDYR 27-28
  str    CPSFAMID 29-30
  str    HIEUIDX 31-37
  byte   FCSZ1231 38-39
  byte   FCRP1231 40-41
  str    RULETR31 42-43
  str    RULETR42 44-45
  str    RULETR53 46-47
  str    RULETR06 48-49
  byte   RUSIZE31 50-51
  byte   RUSIZE42 52-53
  byte   RUSIZE53 54-55
  byte   RUSIZE06 56-57
  byte   RUCLAS31 58-59
  byte   RUCLAS42 60-61
  byte   RUCLAS53 62-63
  byte   RUCLAS06 64-64
  byte   FAMSZE31 65-66
  byte   FAMSZE42 67-68
  byte   FAMSZE53 69-70
  byte   FAMSZE06 71-72
  byte   FMRS1231 73-74
  byte   FAMS1231 75-76
  byte   FAMSZEYR 77-78
  byte   FAMRFPYR 79-80
  byte   REGION31 81-82
  byte   REGION42 83-84
  byte   REGION53 85-86
  byte   REGION06 87-88
  byte   MSA31 89-90
  byte   MSA42 91-92
  byte   MSA53 93-94
  byte   MSA06 95-96
  int    REFPRS31 97-99
  int    REFPRS42 100-102
  int    REFPRS53 103-105
  int    REFPRS06 106-108
  byte   RESP31 109-109
  byte   RESP42 110-110
  byte   RESP53 111-111
  byte   RESP06 112-112
  byte   PROXY31 113-114
  byte   PROXY42 115-116
  byte   PROXY53 117-118
  byte   PROXY06 119-119
  byte   INTVLANG 120-121
  byte   BEGRFD31 122-123
  byte   BEGRFM31 124-125
  int    BEGRFY31 126-129
  byte   ENDRFD31 130-131
  byte   ENDRFM31 132-133
  int    ENDRFY31 134-137
  byte   BEGRFD42 138-139
  byte   BEGRFM42 140-141
  int    BEGRFY42 142-145
  byte   ENDRFD42 146-147
  byte   ENDRFM42 148-149
  int    ENDRFY42 150-153
  byte   BEGRFD53 154-155
  byte   BEGRFM53 156-157
  int    BEGRFY53 158-161
  byte   ENDRFD53 162-163
  byte   ENDRFM53 164-165
  int    ENDRFY53 166-169
  byte   ENDRFD06 170-171
  byte   ENDRFM06 172-173
  int    ENDRFY06 174-177
  byte   KEYNESS 178-178
  byte   INSCOP31 179-179
  byte   INSCOP42 180-180
  byte   INSCOP53 181-181
  byte   INSCOP06 182-182
  byte   INSC1231 183-183
  byte   INSCOPE 184-184
  byte   ELGRND31 185-185
  byte   ELGRND42 186-186
  byte   ELGRND53 187-187
  byte   ELGRND06 188-188
  byte   PSTATS31 189-190
  byte   PSTATS42 191-192
  byte   PSTATS53 193-194
  str    RURSLT31 195-196
  str    RURSLT42 197-198
  str    RURSLT53 199-200
  byte   AGE31X 201-202
  byte   AGE42X 203-204
  byte   AGE53X 205-206
  byte   AGE06X 207-208
  byte   DOBMM 209-210
  int    DOBYY 211-214
  byte   SEX 215-215
  byte   RACEX 216-216
  byte   RACEAX 217-217
  byte   RACEBX 218-218
  byte   RACEWX 219-219
  byte   RACETHNX 220-220
  byte   HISPANX 221-221
  byte   HISPCAT 222-223
  byte   MARRY31X 224-225
  byte   MARRY42X 226-227
  byte   MARRY53X 228-229
  byte   MARRY06X 230-231
  int    SPOUID31 232-234
  int    SPOUID42 235-237
  int    SPOUID53 238-240
  int    SPOUID06 241-243
  byte   SPOUIN31 244-245
  byte   SPOUIN42 246-247
  byte   SPOUIN53 248-249
  byte   SPOUIN06 250-251
  byte   EDUCYR 252-253
  byte   HIDEG 254-255
  byte   FTSTU31X 256-257
  byte   FTSTU42X 258-259
  byte   FTSTU53X 260-261
  byte   FTSTU06X 262-263
  byte   ACTDTY31 264-265
  byte   ACTDTY42 266-267
  byte   ACTDTY53 268-269
  byte   HONRDC31 270-271
  byte   HONRDC42 272-273
  byte   HONRDC53 274-275
  byte   RFREL31X 276-277
  byte   RFREL42X 278-279
  byte   RFREL53X 280-281
  byte   RFREL06X 282-283
  int    MOPID31X 284-286
  int    MOPID42X 287-289
  int    MOPID53X 290-292
  int    DAPID31X 293-295
  int    DAPID42X 296-298
  int    DAPID53X 299-301
  byte   SSIDIS06 302-303
  byte   AFDC06 304-305
  byte   FILEDR06 306-307
  byte   WILFIL06 308-309
  byte   FLSTAT06 310-311
  byte   FILER06 312-313
  byte   JTINRU06 314-315
  int    JNTPID06 316-318
  byte   CLMDEP06 319-320
  byte   DEPDNT06 321-322
  byte   DPINRU06 323-324
  byte   DPOTSD06 325-326
  byte   TAXFRM06 327-328
  byte   DEDUCT06 329-330
  double TOTDED06 331-339
  byte   CLMHIP06 340-341
  byte   EICRDT06 342-343
  byte   FOODST06 344-345
  byte   FOODMN06 346-347
  double FOODVL06 348-354
  long   TTLP06X 355-360
  byte   POVCAT06 361-361
  long   WAGEP06X 362-367
  byte   WAGIMP06 368-368
  long   BUSNP06X 369-375
  byte   BUSIMP06 376-376
  long   UNEMP06X 377-381
  byte   UNEIMP06 382-382
  long   WCMPP06X 383-387
  byte   WCPIMP06 388-388
  long   INTRP06X 389-393
  byte   INTIMP06 394-394
  long   DIVDP06X 395-399
  byte   DIVIMP06 400-400
  long   SALEP06X 401-406
  byte   SALIMP06 407-407
  long   PENSP06X 408-412
  byte   PENIMP06 413-413
  long   SSECP06X 414-418
  byte   SSCIMP06 419-419
  long   TRSTP06X 420-425
  byte   TRTIMP06 426-426
  long   VETSP06X 427-431
  byte   VETIMP06 432-432
  long   IRASP06X 433-437
  byte   IRAIMP06 438-438
  long   REFDP06X 439-443
  byte   REFIMP06 444-444
  long   ALIMP06X 445-449
  byte   ALIIMP06 450-450
  long   CHLDP06X 451-455
  byte   CHLIMP06 456-456
  long   CASHP06X 457-461
  byte   CSHIMP06 462-462
  long   SSIP06X 463-467
  byte   SSIIMP06 468-468
  long   PUBP06X 469-473
  byte   PUBIMP06 474-474
  long   OTHRP06X 475-479
  byte   OTHIMP06 480-480
  byte   RTHLTH31 481-482
  byte   RTHLTH42 483-484
  byte   RTHLTH53 485-486
  byte   MNHLTH31 487-488
  byte   MNHLTH42 489-490
  byte   MNHLTH53 491-492
  byte   IADLHP31 493-494
  byte   IADLHP42 495-496
  byte   IADLHP53 497-498
  byte   IADL3M31 499-500
  byte   IADL3M42 501-502
  byte   IADL3M53 503-504
  byte   ADLHLP31 505-506
  byte   ADLHLP42 507-508
  byte   ADLHLP53 509-510
  byte   ADL3MO31 511-512
  byte   ADL3MO42 513-514
  byte   ADL3MO53 515-516
  byte   AIDHLP31 517-518
  byte   AIDHLP53 519-520
  byte   WLKLIM31 521-522
  byte   WLKLIM53 523-524
  byte   LFTDIF31 525-526
  byte   LFTDIF53 527-528
  byte   STPDIF31 529-530
  byte   STPDIF53 531-532
  byte   WLKDIF31 533-534
  byte   WLKDIF53 535-536
  byte   MILDIF31 537-538
  byte   MILDIF53 539-540
  byte   STNDIF31 541-542
  byte   STNDIF53 543-544
  byte   BENDIF31 545-546
  byte   BENDIF53 547-548
  byte   RCHDIF31 549-550
  byte   RCHDIF53 551-552
  byte   FNGRDF31 553-554
  byte   FNGRDF53 555-556
  byte   WLK3MO31 557-558
  byte   WLK3MO53 559-560
  byte   ACTLIM31 561-562
  byte   ACTLIM53 563-564
  byte   WRKLIM31 565-566
  byte   WRKLIM53 567-568
  byte   HSELIM31 569-570
  byte   HSELIM53 571-572
  byte   SCHLIM31 573-574
  byte   SCHLIM53 575-576
  byte   UNABLE31 577-578
  byte   UNABLE53 579-580
  byte   SOCLIM31 581-582
  byte   SOCLIM53 583-584
  byte   COGLIM31 585-586
  byte   COGLIM53 587-588
  byte   WRGLAS42 589-590
  byte   SEEDIF42 591-592
  byte   BLIND42 593-594
  byte   READNW42 595-596
  byte   RECPEP42 597-598
  byte   VISION42 599-600
  byte   HEARAD42 601-602
  byte   HEARDI42 603-604
  byte   DEAF42 605-606
  byte   HEARMO42 607-608
  byte   HEARSM42 609-610
  byte   HEARNG42 611-612
  byte   ANYLIM06 613-614
  byte   LSHLTH42 615-616
  byte   NEVILL42 617-618
  byte   SICEAS42 619-620
  byte   HLTHLF42 621-622
  byte   WRHLTH42 623-624
  byte   CHPMED42 625-626
  byte   CHPMHB42 627-628
  byte   CHPMCN42 629-630
  byte   CHSERV42 631-632
  byte   CHSRHB42 633-634
  byte   CHSRCN42 635-636
  byte   CHLIMI42 637-638
  byte   CHLIHB42 639-640
  byte   CHLICO42 641-642
  byte   CHTHER42 643-644
  byte   CHTHHB42 645-646
  byte   CHTHCO42 647-648
  byte   CHCOUN42 649-650
  byte   CHEMPB42 651-652
  byte   CSHCN42 653-654
  byte   MOMPRO42 655-656
  byte   DADPRO42 657-658
  byte   UNHAP42 659-660
  byte   SCHLBH42 661-662
  byte   HAVFUN42 663-664
  byte   ADUPRO42 665-666
  byte   NERVAF42 667-668
  byte   SIBPRO42 669-670
  byte   KIDPRO42 671-672
  byte   SPRPRO42 673-674
  byte   SCHPRO42 675-676
  byte   HOMEBH42 677-678
  byte   TRBLE42 679-680
  byte   CHILCR42 681-682
  byte   CHILWW42 683-684
  byte   CHRTCR42 685-686
  byte   CHRTWW42 687-688
  byte   CHAPPT42 689-690
  byte   CHNDCR42 691-692
  byte   CHNECP42 693-694
  byte   CHLIST42 695-696
  byte   CHEXPL42 697-698
  byte   CHRESP42 699-700
  byte   CHPRTM42 701-702
  byte   CHHECR42 703-704
  byte   CHSPEC42 705-706
  byte   CHPRRE42 707-708
  byte   MESHGT42 709-710
  byte   WHNHGT42 711-712
  byte   MESWGT42 713-714
  byte   WHNWGT42 715-716
  double CHBMIX42 717-721
  byte   MESVIS42 722-723
  byte   MESBPR42 724-725
  byte   WHNBPR42 726-727
  byte   DENTAL42 728-729
  byte   WHNDEN42 730-731
  byte   EATHLT42 732-733
  byte   WHNEAT42 734-735
  byte   PHYSCL42 736-737
  byte   WHNPHY42 738-739
  byte   SAFEST42 740-741
  byte   WHNSAF42 742-743
  byte   BOOST42 744-745
  byte   WHNBST42 746-747
  byte   LAPBLT42 748-749
  byte   WHNLAP42 750-751
  byte   HELMET42 752-753
  byte   WHNHEL42 754-755
  byte   NOSMOK42 756-757
  byte   WHNSMK42 758-759
  byte   TIMALN42 760-761
  byte   DENTCK53 762-763
  byte   CHOLCK53 764-765
  byte   CHECK53 766-767
  byte   FLUSHT53 768-769
  byte   LSTETH53 770-771
  byte   PSA53 772-773
  byte   HYSTER53 774-775
  byte   PAPSMR53 776-777
  byte   BRSTEX53 778-779
  byte   MAMOGR53 780-781
  byte   STOOL53 782-783
  byte   WHENST53 784-785
  byte   BOWEL53 786-787
  byte   WHNBWL53 788-789
  byte   PHYACT53 790-791
  double BMINDX53 792-796
  byte   SEATBE53 797-798
  byte   SRTHRT53 799-800
  byte   THSYMP53 801-802
  byte   DRTHRT53 803-804
  byte   THANTB53 805-806
  byte   THSWAB53 807-808
  byte   THSYMF53 809-810
  byte   THSWBF53 811-812
  byte   THANTF53 813-814
  byte   DIABDX53 815-816
  byte   ASTHDX53 817-818
  byte   ASSTIL53 819-820
  byte   ASATAK53 821-822
  byte   ASACUT53 823-824
  byte   ASMRCN53 825-826
  byte   ASPREV53 827-828
  byte   ASDALY53 829-830
  byte   ASPKFL53 831-832
  byte   ASEVFL53 833-834
  byte   ASWNFL53 835-836
  byte   HIBPDX53 837-838
  byte   BPMLDX53 839-840
  byte   BPCHEK53 841-842
  byte   BPMONT53 843-844
  byte   CHOLDX53 845-846
  byte   CHLAGE53 847-848
  byte   CHDDX53 849-850
  byte   ANGIDX53 851-852
  byte   MIDX53 853-854
  byte   OHRTDX53 855-856
  byte   STRKDX53 857-858
  byte   EMPHDX53 859-860
  byte   NOFAT53 861-862
  byte   EXRCIS53 863-864
  byte   ASPRIN53 865-866
  byte   NOASPR53 867-868
  byte   STOMCH53 869-870
  byte   JTPAIN53 871-872
  byte   ARTHDX53 873-874
  byte   ARTHTX53 875-876
  byte   SAQELIG 877-877
  int    ADPRX42 878-880
  byte   ADILCR42 881-882
  byte   ADILWW42 883-884
  byte   ADRTCR42 885-886
  byte   ADRTWW42 887-888
  byte   ADAPPT42 889-890
  byte   ADNDCR42 891-892
  byte   ADNECP42 893-894
  byte   ADLIST42 895-896
  byte   ADEXPL42 897-898
  byte   ADRESP42 899-900
  byte   ADPRTM42 901-902
  byte   ADHECR42 903-904
  byte   ADSMOK42 905-906
  byte   ADNSMK42 907-908
  byte   ADDRBP42 909-910
  byte   ADSPEC42 911-912
  byte   ADPRRE42 913-914
  byte   ADGENH42 915-916
  byte   ADDAYA42 917-918
  byte   ADCLIM42 919-920
  byte   ADPALS42 921-922
  byte   ADPWLM42 923-924
  byte   ADMALS42 925-926
  byte   ADMWLM42 927-928
  byte   ADPAIN42 929-930
  byte   ADCAPE42 931-932
  byte   ADNRGY42 933-934
  byte   ADDOWN42 935-936
  byte   ADSOCA42 937-938
  double PCS42 939-943
  double MCS42 944-948
  byte   SFFLAG42 949-950
  byte   ADNERV42 951-952
  byte   ADHOPE42 953-954
  byte   ADREST42 955-956
  byte   ADSAD42 957-958
  byte   ADEFRT42 959-960
  byte   ADWRTH42 961-962
  byte   K6SUM42 963-964
  byte   ADINTR42 965-966
  byte   ADDPRS42 967-968
  double PHQ242 969-973
  byte   ADINSA42 974-975
  byte   ADINSB42 976-977
  byte   ADRISK42 978-979
  byte   ADOVER42 980-981
  byte   ADCMPM42 982-983
  byte   ADCMPD42 984-985
  int    ADCMPY42 986-989
  byte   ADLANG42 990-991
  byte   DSDIA53 992-993
  byte   DSA1C53 994-995
  byte   DSCKFT53 996-997
  byte   DSEY0753 998-999
  byte   DSEY0653 1000-1001
  byte   DSEY0553 1002-1003
  byte   DSEB0553 1004-1005
  byte   DSEYNV53 1006-1007
  byte   DSKIDN53 1008-1009
  byte   DSEYPR53 1010-1011
  byte   DSDIET53 1012-1013
  byte   DSMED53 1014-1015
  byte   DSINSU53 1016-1017
  byte   PHONE53 1018-1019
  byte   NURSE53 1020-1021
  byte   VISIT53 1022-1023
  byte   REFER53 1024-1025
  byte   CHLCHK53 1026-1027
  byte   FLSHOT53 1028-1029
  byte   DSPRX53 1030-1031
  int    DDNWRK31 1032-1034
  int    DDNWRK42 1035-1037
  int    DDNWRK53 1038-1040
  int    WKINBD31 1041-1043
  int    WKINBD42 1044-1046
  int    WKINBD53 1047-1049
  byte   DDNSCL31 1050-1051
  int    DDNSCL42 1052-1054
  byte   DDNSCL53 1055-1056
  byte   SCLNBD31 1057-1058
  int    SCLNBD42 1059-1061
  byte   SCLNBD53 1062-1063
  int    DDBDYS31 1064-1066
  int    DDBDYS42 1067-1069
  int    DDBDYS53 1070-1072
  byte   OTHDYS31 1073-1074
  byte   OTHDYS42 1075-1076
  byte   OTHDYS53 1077-1078
  byte   OTHNDD31 1079-1080
  byte   OTHNDD42 1081-1082
  int    OTHNDD53 1083-1085
  byte   ACCELI42 1086-1087
  byte   LANGHM42 1088-1089
  byte   ENGHME42 1090-1091
  byte   ENGSPK42 1092-1093
  byte   HAVEUS42 1094-1095
  byte   YNOUSC42 1096-1097
  byte   NOREAS42 1098-1099
  byte   SELDSI42 1100-1101
  byte   NEWARE42 1102-1103
  byte   DKWHRU42 1104-1105
  byte   USCNOT42 1106-1107
  byte   PERSLA42 1108-1109
  byte   DIFFPL42 1110-1111
  byte   INSRPL42 1112-1113
  byte   MYSELF42 1114-1115
  byte   CARECO42 1116-1117
  byte   OTHINS42 1118-1119
  byte   JOBRSN42 1120-1121
  byte   NEWDOC42 1122-1123
  byte   DOCELS42 1124-1125
  byte   NOLIKE42 1126-1127
  byte   KNOWDR42 1128-1129
  byte   ONJOB42 1130-1131
  byte   NOGODR42 1132-1133
  byte   TRANS42 1134-1135
  byte   CLINIC42 1136-1137
  byte   OTHREA42 1138-1139
  byte   PROVTY42 1140-1141
  byte   FACLPR42 1142-1143
  byte   PLCTYP42 1144-1145
  byte   GOTOUS42 1146-1147
  byte   TMTKUS42 1148-1149
  byte   DFTOUS42 1150-1151
  byte   TYPEPE42 1152-1153
  byte   LOCATN42 1154-1155
  byte   HSPLAP42 1156-1157
  byte   WHITPR42 1158-1159
  byte   BLCKPR42 1160-1161
  byte   ASIANP42 1162-1163
  byte   NATAMP42 1164-1165
  byte   PACISP42 1166-1167
  byte   OTHRCP42 1168-1169
  byte   GENDRP42 1170-1171
  byte   MINORP42 1172-1173
  byte   PREVEN42 1174-1175
  byte   REFFRL42 1176-1177
  byte   ONGONG42 1178-1179
  byte   PHNREG42 1180-1181
  byte   OFFHOU42 1182-1183
  byte   AFTHOU42 1184-1185
  byte   TREATM42 1186-1187
  byte   RESPCT42 1188-1189
  byte   DECIDE42 1190-1191
  byte   EXPLOP42 1192-1193
  byte   LANGPR42 1194-1195
  byte   MDUNAB42 1196-1197
  byte   MDUNRS42 1198-1199
  byte   MDUNPR42 1200-1201
  byte   MDDLAY42 1202-1203
  byte   MDDLRS42 1204-1205
  byte   MDDLPR42 1206-1207
  byte   DNUNAB42 1208-1209
  byte   DNUNRS42 1210-1211
  byte   DNUNPR42 1212-1213
  byte   DNDLAY42 1214-1215
  byte   DNDLRS42 1216-1217
  byte   DNDLPR42 1218-1219
  byte   PMUNAB42 1220-1221
  byte   PMUNRS42 1222-1223
  byte   PMUNPR42 1224-1225
  byte   PMDLAY42 1226-1227
  byte   PMDLRS42 1228-1229
  byte   PMDLPR42 1230-1231
  byte   EMPST31 1232-1233
  byte   EMPST42 1234-1235
  byte   EMPST53 1236-1237
  byte   RNDFLG31 1238-1239
  byte   MORJOB31 1240-1241
  byte   MORJOB42 1242-1243
  byte   MORJOB53 1244-1245
  byte   EVRWRK 1246-1247
  double HRWG31X 1248-1253
  double HRWG42X 1254-1259
  double HRWG53X 1260-1265
  byte   HRWGIM31 1266-1266
  byte   HRWGIM42 1267-1267
  byte   HRWGIM53 1268-1268
  byte   HRHOW31 1269-1270
  byte   HRHOW42 1271-1272
  byte   HRHOW53 1273-1274
  byte   DIFFWG31 1275-1276
  byte   DIFFWG42 1277-1278
  byte   DIFFWG53 1279-1280
  double NHRWG31 1281-1286
  double NHRWG42 1287-1292
  double NHRWG53 1293-1298
  int    HOUR31 1299-1301
  int    HOUR42 1302-1304
  int    HOUR53 1305-1307
  byte   TEMPJB31 1308-1309
  byte   TEMPJB42 1310-1311
  byte   TEMPJB53 1312-1313
  byte   SSNLJB31 1314-1315
  byte   SSNLJB42 1316-1317
  byte   SSNLJB53 1318-1319
  byte   SELFCM31 1320-1321
  byte   SELFCM42 1322-1323
  byte   SELFCM53 1324-1325
  byte   DISVW31X 1326-1327
  byte   DISVW42X 1328-1329
  byte   DISVW53X 1330-1331
  byte   CHOIC31 1332-1333
  byte   CHOIC42 1334-1335
  byte   CHOIC53 1336-1337
  byte   INDCAT31 1338-1339
  byte   INDCAT42 1340-1341
  byte   INDCAT53 1342-1343
  int    NUMEMP31 1344-1346
  int    NUMEMP42 1347-1349
  int    NUMEMP53 1350-1352
  byte   MORE31 1353-1354
  byte   MORE42 1355-1356
  byte   MORE53 1357-1358
  byte   UNION31 1359-1360
  byte   UNION42 1361-1362
  byte   UNION53 1363-1364
  byte   NWK31 1365-1366
  byte   NWK42 1367-1368
  byte   NWK53 1369-1370
  byte   CHGJ3142 1371-1372
  byte   CHGJ4253 1373-1374
  byte   YCHJ3142 1375-1376
  byte   YCHJ4253 1377-1378
  byte   STJBMM31 1379-1380
  byte   STJBDD31 1381-1382
  int    STJBYY31 1383-1386
  byte   STJBMM42 1387-1388
  byte   STJBDD42 1389-1390
  int    STJBYY42 1391-1394
  byte   STJBMM53 1395-1396
  byte   STJBDD53 1397-1398
  int    STJBYY53 1399-1402
  byte   EVRETIRE 1403-1404
  byte   OCCCAT31 1405-1406
  byte   OCCCAT42 1407-1408
  byte   OCCCAT53 1409-1410
  byte   PAYVAC31 1411-1412
  byte   PAYVAC42 1413-1414
  byte   PAYVAC53 1415-1416
  byte   SICPAY31 1417-1418
  byte   SICPAY42 1419-1420
  byte   SICPAY53 1421-1422
  byte   PAYDR31 1423-1424
  byte   PAYDR42 1425-1426
  byte   PAYDR53 1427-1428
  byte   RETPLN31 1429-1430
  byte   RETPLN42 1431-1432
  byte   RETPLN53 1433-1434
  byte   BSNTY31 1435-1436
  byte   BSNTY42 1437-1438
  byte   BSNTY53 1439-1440
  byte   JOBORG31 1441-1442
  byte   JOBORG42 1443-1444
  byte   JOBORG53 1445-1446
  byte   HELD31X 1447-1448
  byte   HELD42X 1449-1450
  byte   HELD53X 1451-1452
  byte   OFFER31X 1453-1454
  byte   OFFER42X 1455-1456
  byte   OFFER53X 1457-1458
  byte   OFREMP31 1459-1460
  byte   OFREMP42 1461-1462
  byte   OFREMP53 1463-1464
  byte   YNOINS31 1465-1466
  byte   YNOINS42 1467-1468
  byte   YNOINS53 1469-1470
  byte   TRIJA06X 1471-1472
  byte   TRIFE06X 1473-1474
  byte   TRIMA06X 1475-1476
  byte   TRIAP06X 1477-1478
  byte   TRIMY06X 1479-1480
  byte   TRIJU06X 1481-1482
  byte   TRIJL06X 1483-1484
  byte   TRIAU06X 1485-1486
  byte   TRISE06X 1487-1488
  byte   TRIOC06X 1489-1490
  byte   TRINO06X 1491-1492
  byte   TRIDE06X 1493-1494
  byte   MCRJA06 1495-1496
  byte   MCRFE06 1497-1498
  byte   MCRMA06 1499-1500
  byte   MCRAP06 1501-1502
  byte   MCRMY06 1503-1504
  byte   MCRJU06 1505-1506
  byte   MCRJL06 1507-1508
  byte   MCRAU06 1509-1510
  byte   MCRSE06 1511-1512
  byte   MCROC06 1513-1514
  byte   MCRNO06 1515-1516
  byte   MCRDE06 1517-1518
  byte   MCRJA06X 1519-1520
  byte   MCRFE06X 1521-1522
  byte   MCRMA06X 1523-1524
  byte   MCRAP06X 1525-1526
  byte   MCRMY06X 1527-1528
  byte   MCRJU06X 1529-1530
  byte   MCRJL06X 1531-1532
  byte   MCRAU06X 1533-1534
  byte   MCRSE06X 1535-1536
  byte   MCROC06X 1537-1538
  byte   MCRNO06X 1539-1540
  byte   MCRDE06X 1541-1542
  byte   MCDJA06 1543-1544
  byte   MCDFE06 1545-1546
  byte   MCDMA06 1547-1548
  byte   MCDAP06 1549-1550
  byte   MCDMY06 1551-1552
  byte   MCDJU06 1553-1554
  byte   MCDJL06 1555-1556
  byte   MCDAU06 1557-1558
  byte   MCDSE06 1559-1560
  byte   MCDOC06 1561-1562
  byte   MCDNO06 1563-1564
  byte   MCDDE06 1565-1566
  byte   MCDJA06X 1567-1568
  byte   MCDFE06X 1569-1570
  byte   MCDMA06X 1571-1572
  byte   MCDAP06X 1573-1574
  byte   MCDMY06X 1575-1576
  byte   MCDJU06X 1577-1578
  byte   MCDJL06X 1579-1580
  byte   MCDAU06X 1581-1582
  byte   MCDSE06X 1583-1584
  byte   MCDOC06X 1585-1586
  byte   MCDNO06X 1587-1588
  byte   MCDDE06X 1589-1590
  byte   OPAJA06 1591-1592
  byte   OPAFE06 1593-1594
  byte   OPAMA06 1595-1596
  byte   OPAAP06 1597-1598
  byte   OPAMY06 1599-1600
  byte   OPAJU06 1601-1602
  byte   OPAJL06 1603-1604
  byte   OPAAU06 1605-1606
  byte   OPASE06 1607-1608
  byte   OPAOC06 1609-1610
  byte   OPANO06 1611-1612
  byte   OPADE06 1613-1614
  byte   OPBJA06 1615-1616
  byte   OPBFE06 1617-1618
  byte   OPBMA06 1619-1620
  byte   OPBAP06 1621-1622
  byte   OPBMY06 1623-1624
  byte   OPBJU06 1625-1626
  byte   OPBJL06 1627-1628
  byte   OPBAU06 1629-1630
  byte   OPBSE06 1631-1632
  byte   OPBOC06 1633-1634
  byte   OPBNO06 1635-1636
  byte   OPBDE06 1637-1638
  byte   STAJA06 1639-1640
  byte   STAFE06 1641-1642
  byte   STAMA06 1643-1644
  byte   STAAP06 1645-1646
  byte   STAMY06 1647-1648
  byte   STAJU06 1649-1650
  byte   STAJL06 1651-1652
  byte   STAAU06 1653-1654
  byte   STASE06 1655-1656
  byte   STAOC06 1657-1658
  byte   STANO06 1659-1660
  byte   STADE06 1661-1662
  byte   PUBJA06X 1663-1664
  byte   PUBFE06X 1665-1666
  byte   PUBMA06X 1667-1668
  byte   PUBAP06X 1669-1670
  byte   PUBMY06X 1671-1672
  byte   PUBJU06X 1673-1674
  byte   PUBJL06X 1675-1676
  byte   PUBAU06X 1677-1678
  byte   PUBSE06X 1679-1680
  byte   PUBOC06X 1681-1682
  byte   PUBNO06X 1683-1684
  byte   PUBDE06X 1685-1686
  byte   PEGJA06 1687-1688
  byte   PEGFE06 1689-1690
  byte   PEGMA06 1691-1692
  byte   PEGAP06 1693-1694
  byte   PEGMY06 1695-1696
  byte   PEGJU06 1697-1698
  byte   PEGJL06 1699-1700
  byte   PEGAU06 1701-1702
  byte   PEGSE06 1703-1704
  byte   PEGOC06 1705-1706
  byte   PEGNO06 1707-1708
  byte   PEGDE06 1709-1710
  byte   PDKJA06 1711-1712
  byte   PDKFE06 1713-1714
  byte   PDKMA06 1715-1716
  byte   PDKAP06 1717-1718
  byte   PDKMY06 1719-1720
  byte   PDKJU06 1721-1722
  byte   PDKJL06 1723-1724
  byte   PDKAU06 1725-1726
  byte   PDKSE06 1727-1728
  byte   PDKOC06 1729-1730
  byte   PDKNO06 1731-1732
  byte   PDKDE06 1733-1734
  byte   PNGJA06 1735-1736
  byte   PNGFE06 1737-1738
  byte   PNGMA06 1739-1740
  byte   PNGAP06 1741-1742
  byte   PNGMY06 1743-1744
  byte   PNGJU06 1745-1746
  byte   PNGJL06 1747-1748
  byte   PNGAU06 1749-1750
  byte   PNGSE06 1751-1752
  byte   PNGOC06 1753-1754
  byte   PNGNO06 1755-1756
  byte   PNGDE06 1757-1758
  byte   POGJA06 1759-1760
  byte   POGFE06 1761-1762
  byte   POGMA06 1763-1764
  byte   POGAP06 1765-1766
  byte   POGMY06 1767-1768
  byte   POGJU06 1769-1770
  byte   POGJL06 1771-1772
  byte   POGAU06 1773-1774
  byte   POGSE06 1775-1776
  byte   POGOC06 1777-1778
  byte   POGNO06 1779-1780
  byte   POGDE06 1781-1782
  byte   PRSJA06 1783-1784
  byte   PRSFE06 1785-1786
  byte   PRSMA06 1787-1788
  byte   PRSAP06 1789-1790
  byte   PRSMY06 1791-1792
  byte   PRSJU06 1793-1794
  byte   PRSJL06 1795-1796
  byte   PRSAU06 1797-1798
  byte   PRSSE06 1799-1800
  byte   PRSOC06 1801-1802
  byte   PRSNO06 1803-1804
  byte   PRSDE06 1805-1806
  byte   POUJA06 1807-1808
  byte   POUFE06 1809-1810
  byte   POUMA06 1811-1812
  byte   POUAP06 1813-1814
  byte   POUMY06 1815-1816
  byte   POUJU06 1817-1818
  byte   POUJL06 1819-1820
  byte   POUAU06 1821-1822
  byte   POUSE06 1823-1824
  byte   POUOC06 1825-1826
  byte   POUNO06 1827-1828
  byte   POUDE06 1829-1830
  byte   PRIJA06 1831-1832
  byte   PRIFE06 1833-1834
  byte   PRIMA06 1835-1836
  byte   PRIAP06 1837-1838
  byte   PRIMY06 1839-1840
  byte   PRIJU06 1841-1842
  byte   PRIJL06 1843-1844
  byte   PRIAU06 1845-1846
  byte   PRISE06 1847-1848
  byte   PRIOC06 1849-1850
  byte   PRINO06 1851-1852
  byte   PRIDE06 1853-1854
  byte   HPEJA06 1855-1856
  byte   HPEFE06 1857-1858
  byte   HPEMA06 1859-1860
  byte   HPEAP06 1861-1862
  byte   HPEMY06 1863-1864
  byte   HPEJU06 1865-1866
  byte   HPEJL06 1867-1868
  byte   HPEAU06 1869-1870
  byte   HPESE06 1871-1872
  byte   HPEOC06 1873-1874
  byte   HPENO06 1875-1876
  byte   HPEDE06 1877-1878
  byte   HPDJA06 1879-1880
  byte   HPDFE06 1881-1882
  byte   HPDMA06 1883-1884
  byte   HPDAP06 1885-1886
  byte   HPDMY06 1887-1888
  byte   HPDJU06 1889-1890
  byte   HPDJL06 1891-1892
  byte   HPDAU06 1893-1894
  byte   HPDSE06 1895-1896
  byte   HPDOC06 1897-1898
  byte   HPDNO06 1899-1900
  byte   HPDDE06 1901-1902
  byte   HPNJA06 1903-1904
  byte   HPNFE06 1905-1906
  byte   HPNMA06 1907-1908
  byte   HPNAP06 1909-1910
  byte   HPNMY06 1911-1912
  byte   HPNJU06 1913-1914
  byte   HPNJL06 1915-1916
  byte   HPNAU06 1917-1918
  byte   HPNSE06 1919-1920
  byte   HPNOC06 1921-1922
  byte   HPNNO06 1923-1924
  byte   HPNDE06 1925-1926
  byte   HPOJA06 1927-1928
  byte   HPOFE06 1929-1930
  byte   HPOMA06 1931-1932
  byte   HPOAP06 1933-1934
  byte   HPOMY06 1935-1936
  byte   HPOJU06 1937-1938
  byte   HPOJL06 1939-1940
  byte   HPOAU06 1941-1942
  byte   HPOSE06 1943-1944
  byte   HPOOC06 1945-1946
  byte   HPONO06 1947-1948
  byte   HPODE06 1949-1950
  byte   HPSJA06 1951-1952
  byte   HPSFE06 1953-1954
  byte   HPSMA06 1955-1956
  byte   HPSAP06 1957-1958
  byte   HPSMY06 1959-1960
  byte   HPSJU06 1961-1962
  byte   HPSJL06 1963-1964
  byte   HPSAU06 1965-1966
  byte   HPSSE06 1967-1968
  byte   HPSOC06 1969-1970
  byte   HPSNO06 1971-1972
  byte   HPSDE06 1973-1974
  byte   HPRJA06 1975-1976
  byte   HPRFE06 1977-1978
  byte   HPRMA06 1979-1980
  byte   HPRAP06 1981-1982
  byte   HPRMY06 1983-1984
  byte   HPRJU06 1985-1986
  byte   HPRJL06 1987-1988
  byte   HPRAU06 1989-1990
  byte   HPRSE06 1991-1992
  byte   HPROC06 1993-1994
  byte   HPRNO06 1995-1996
  byte   HPRDE06 1997-1998
  byte   INSJA06X 1999-2000
  byte   INSFE06X 2001-2002
  byte   INSMA06X 2003-2004
  byte   INSAP06X 2005-2006
  byte   INSMY06X 2007-2008
  byte   INSJU06X 2009-2010
  byte   INSJL06X 2011-2012
  byte   INSAU06X 2013-2014
  byte   INSSE06X 2015-2016
  byte   INSOC06X 2017-2018
  byte   INSNO06X 2019-2020
  byte   INSDE06X 2021-2022
  byte   PRVEV06 2023-2023
  byte   TRIEV06 2024-2024
  byte   MCREV06 2025-2025
  byte   MCDEV06 2026-2026
  byte   OPAEV06 2027-2027
  byte   OPBEV06 2028-2028
  byte   UNINS06 2029-2029
  byte   INSCOV06 2030-2030
  byte   TRIST31X 2031-2032
  byte   TRIST42X 2033-2034
  byte   TRIST06X 2035-2036
  byte   TRIPR31X 2037-2038
  byte   TRIPR42X 2039-2040
  byte   TRIPR06X 2041-2042
  byte   TRIEX31X 2043-2044
  byte   TRIEX42X 2045-2046
  byte   TRIEX06X 2047-2048
  byte   TRILI31X 2049-2050
  byte   TRILI42X 2051-2052
  byte   TRILI06X 2053-2054
  byte   TRICH31X 2055-2056
  byte   TRICH42X 2057-2058
  byte   TRICH06X 2059-2060
  byte   MCRPD31 2061-2062
  byte   MCRPD42 2063-2064
  byte   MCRPD06 2065-2066
  byte   MCRPD31X 2067-2068
  byte   MCRPD42X 2069-2070
  byte   MCRPD06X 2071-2072
  byte   MCRPHO31 2073-2074
  byte   MCRPHO42 2075-2076
  byte   MCRPHO06 2077-2078
  byte   MCDHMO31 2079-2080
  byte   MCDHMO42 2081-2082
  byte   MCDHMO06 2083-2084
  byte   MCDMC31 2085-2086
  byte   MCDMC42 2087-2088
  byte   MCDMC06 2089-2090
  byte   PRVHMO31 2091-2092
  byte   PRVHMO42 2093-2094
  byte   PRVHMO06 2095-2096
  byte   PRVMNC31 2097-2098
  byte   PRVMNC42 2099-2100
  byte   PRVMNC06 2101-2102
  byte   PRVDRL31 2103-2104
  byte   PRVDRL42 2105-2106
  byte   PRVDRL06 2107-2108
  byte   PHMONP31 2109-2110
  byte   PHMONP42 2111-2112
  byte   PHMONP06 2113-2114
  byte   PMNCNP31 2115-2116
  byte   PMNCNP42 2117-2118
  byte   PMNCNP06 2119-2120
  byte   PRDRNP31 2121-2122
  byte   PRDRNP42 2123-2124
  byte   PRDRNP06 2125-2126
  byte   PREVCOVR 2127-2128
  byte   COVRMM 2129-2130
  int    COVRYY 2131-2134
  byte   WASESTB 2135-2136
  byte   WASMCARE 2137-2138
  byte   WASMCAID 2139-2140
  byte   WASCHAMP 2141-2142
  byte   WASVA 2143-2144
  byte   WASPRIV 2145-2146
  byte   WASOTGOV 2147-2148
  byte   WASAFDC 2149-2150
  byte   WASSSI 2151-2152
  byte   WASSTAT1 2153-2154
  byte   WASSTAT2 2155-2156
  byte   WASSTAT3 2157-2158
  byte   WASSTAT4 2159-2160
  byte   WASOTHER 2161-2162
  byte   NOINSBEF 2163-2164
  byte   NOINSTM 2165-2166
  byte   NOINUNIT 2167-2168
  byte   MORECOVR 2169-2170
  byte   INSENDMM 2171-2172
  int    INSENDYY 2173-2176
  byte   TRICR31X 2177-2178
  byte   TRICR42X 2179-2180
  byte   TRICR53X 2181-2182
  byte   TRICR06X 2183-2184
  byte   TRIAT31X 2185-2186
  byte   TRIAT42X 2187-2188
  byte   TRIAT53X 2189-2190
  byte   TRIAT06X 2191-2192
  byte   MCAID31 2193-2194
  byte   MCAID42 2195-2196
  byte   MCAID53 2197-2198
  byte   MCAID06 2199-2200
  byte   MCAID31X 2201-2202
  byte   MCAID42X 2203-2204
  byte   MCAID53X 2205-2206
  byte   MCAID06X 2207-2208
  byte   MCARE31 2209-2210
  byte   MCARE42 2211-2212
  byte   MCARE53 2213-2214
  byte   MCARE06 2215-2216
  byte   MCARE31X 2217-2218
  byte   MCARE42X 2219-2220
  byte   MCARE53X 2221-2222
  byte   MCARE06X 2223-2224
  byte   MCDAT31X 2225-2226
  byte   MCDAT42X 2227-2228
  byte   MCDAT53X 2229-2230
  byte   MCDAT06X 2231-2232
  byte   OTPAAT31 2233-2234
  byte   OTPAAT42 2235-2236
  byte   OTPAAT53 2237-2238
  byte   OTPAAT06 2239-2240
  byte   OTPBAT31 2241-2242
  byte   OTPBAT42 2243-2244
  byte   OTPBAT53 2245-2246
  byte   OTPBAT06 2247-2248
  byte   OTPUBA31 2249-2250
  byte   OTPUBA42 2251-2252
  byte   OTPUBA53 2253-2254
  byte   OTPUBA06 2255-2256
  byte   OTPUBB31 2257-2258
  byte   OTPUBB42 2259-2260
  byte   OTPUBB53 2261-2262
  byte   OTPUBB06 2263-2264
  byte   PRIDK31 2265-2266
  byte   PRIDK42 2267-2268
  byte   PRIDK53 2269-2270
  byte   PRIDK06 2271-2272
  byte   PRIEU31 2273-2274
  byte   PRIEU42 2275-2276
  byte   PRIEU53 2277-2278
  byte   PRIEU06 2279-2280
  byte   PRING31 2281-2282
  byte   PRING42 2283-2284
  byte   PRING53 2285-2286
  byte   PRING06 2287-2288
  byte   PRIOG31 2289-2290
  byte   PRIOG42 2291-2292
  byte   PRIOG53 2293-2294
  byte   PRIOG06 2295-2296
  byte   PRIS31 2297-2298
  byte   PRIS42 2299-2300
  byte   PRIS53 2301-2302
  byte   PRIS06 2303-2304
  byte   PRIV31 2305-2306
  byte   PRIV42 2307-2308
  byte   PRIV53 2309-2310
  byte   PRIV06 2311-2312
  byte   PRIVAT31 2313-2314
  byte   PRIVAT42 2315-2316
  byte   PRIVAT53 2317-2318
  byte   PRIVAT06 2319-2320
  byte   PROUT31 2321-2322
  byte   PROUT42 2323-2324
  byte   PROUT53 2325-2326
  byte   PROUT06 2327-2328
  byte   PUB31X 2329-2330
  byte   PUB42X 2331-2332
  byte   PUB53X 2333-2334
  byte   PUB06X 2335-2336
  byte   PUBAT31X 2337-2338
  byte   PUBAT42X 2339-2340
  byte   PUBAT53X 2341-2342
  byte   PUBAT06X 2343-2344
  byte   INS31X 2345-2346
  byte   INS42X 2347-2348
  byte   INS53X 2349-2350
  byte   INS06X 2351-2352
  byte   INSAT31X 2353-2354
  byte   INSAT42X 2355-2356
  byte   INSAT53X 2357-2358
  byte   INSAT06X 2359-2360
  byte   STAPR31 2361-2362
  byte   STAPR42 2363-2364
  byte   STAPR53 2365-2366
  byte   STAPR06 2367-2368
  byte   STPRAT31 2369-2370
  byte   STPRAT42 2371-2372
  byte   STPRAT53 2373-2374
  byte   STPRAT06 2375-2376
  byte   EVRUNINS 2377-2377
  byte   EVRUNAT 2378-2378
  byte   DENTIN31 2379-2380
  byte   DENTIN42 2381-2382
  byte   DENTIN53 2383-2384
  byte   DNTINS31 2385-2386
  byte   DNTINS06 2387-2388
  byte   PMEDIN31 2389-2390
  byte   PMEDIN42 2391-2392
  byte   PMEDIN53 2393-2394
  byte   PMDINS31 2395-2396
  byte   PMDINS06 2397-2398
  byte   PMEDUP31 2399-2400
  byte   PMEDUP42 2401-2402
  byte   PMEDUP53 2403-2404
  byte   PMEDPY31 2405-2406
  byte   PMEDPY42 2407-2408
  byte   PMEDPY53 2409-2410
  int    PMEDOP31 2411-2414
  int    PMEDOP42 2415-2418
  int    PMEDOP53 2419-2422
  byte   GDCPBM42 2423-2424
  byte   APRTRM42 2425-2426
  byte   APRDLM42 2427-2428
  byte   LKINFM42 2429-2430
  byte   PBINFM42 2431-2432
  byte   CSTSVM42 2433-2434
  byte   PBSVCM42 2435-2436
  byte   PPRWKM42 2437-2438
  byte   PBPWKM42 2439-2440
  byte   RTPLNM42 2441-2442
  byte   GDCPBT42 2443-2444
  byte   APRTRT42 2445-2446
  byte   APRDLT42 2447-2448
  byte   LKINFT42 2449-2450
  byte   PBINFT42 2451-2452
  byte   CSTSVT42 2453-2454
  byte   PBSVCT42 2455-2456
  byte   PPRWKT42 2457-2458
  byte   PBPWKT42 2459-2460
  byte   RTPLNT42 2461-2462
  long   TOTTCH06 2463-2469
  long   TOTEXP06 2470-2475
  long   TOTSLF06 2476-2481
  long   TOTMCR06 2482-2487
  long   TOTMCD06 2488-2493
  long   TOTPRV06 2494-2499
  long   TOTVA06 2500-2505
  long   TOTTRI06 2506-2510
  long   TOTOFD06 2511-2515
  long   TOTSTL06 2516-2520
  long   TOTWCP06 2521-2525
  long   TOTOPR06 2526-2530
  long   TOTOPU06 2531-2535
  long   TOTOSR06 2536-2540
  int    OBTOTV06 2541-2543
  long   OBVTCH06 2544-2549
  long   OBVEXP06 2550-2555
  long   OBVSLF06 2556-2560
  long   OBVMCR06 2561-2565
  long   OBVMCD06 2566-2571
  long   OBVPRV06 2572-2577
  long   OBVVA06 2578-2582
  long   OBVTRI06 2583-2587
  int    OBVOFD06 2588-2591
  long   OBVSTL06 2592-2596
  long   OBVWCP06 2597-2601
  long   OBVOPR06 2602-2606
  long   OBVOPU06 2607-2611
  long   OBVOSR06 2612-2616
  int    OBDRV06 2617-2619
  long   OBDTCH06 2620-2625
  long   OBDEXP06 2626-2631
  long   OBDSLF06 2632-2636
  long   OBDMCR06 2637-2641
  long   OBDMCD06 2642-2647
  long   OBDPRV06 2648-2652
  long   OBDVA06 2653-2657
  long   OBDTRI06 2658-2662
  int    OBDOFD06 2663-2666
  long   OBDSTL06 2667-2671
  long   OBDWCP06 2672-2676
  long   OBDOPR06 2677-2681
  long   OBDOPU06 2682-2686
  long   OBDOSR06 2687-2691
  int    OBOTHV06 2692-2694
  long   OBOTCH06 2695-2700
  long   OBOEXP06 2701-2706
  long   OBOSLF06 2707-2711
  long   OBOMCR06 2712-2716
  long   OBOMCD06 2717-2721
  long   OBOPRV06 2722-2727
  long   OBOVA06 2728-2732
  int    OBOTRI06 2733-2736
  int    OBOOFD06 2737-2740
  long   OBOSTL06 2741-2745
  long   OBOWCP06 2746-2750
  long   OBOOPR06 2751-2755
  int    OBOOPU06 2756-2759
  long   OBOOSR06 2760-2764
  int    OBCHIR06 2765-2767
  long   OBCTCH06 2768-2772
  int    OBCEXP06 2773-2776
  int    OBCSLF06 2777-2780
  int    OBCMCR06 2781-2784
  int    OBCMCD06 2785-2788
  int    OBCPRV06 2789-2792
  int    OBCVA06 2793-2795
  int    OBCTRI06 2796-2798
  byte   OBCOFD06 2799-2800
  int    OBCSTL06 2801-2803
  int    OBCWCP06 2804-2807
  int    OBCOPR06 2808-2811
  int    OBCOPU06 2812-2814
  int    OBCOSR06 2815-2818
  int    OBNURS06 2819-2821
  long   OBNTCH06 2822-2827
  long   OBNEXP06 2828-2832
  int    OBNSLF06 2833-2836
  long   OBNMCR06 2837-2841
  long   OBNMCD06 2842-2846
  long   OBNPRV06 2847-2851
  long   OBNVA06 2852-2856
  int    OBNTRI06 2857-2860
  int    OBNOFD06 2861-2864
  int    OBNSTL06 2865-2868
  int    OBNWCP06 2869-2872
  int    OBNOPR06 2873-2876
  int    OBNOPU06 2877-2880
  int    OBNOSR06 2881-2884
  byte   OBOPTO06 2885-2885
  int    OBETCH06 2886-2889
  int    OBEEXP06 2890-2893
  int    OBESLF06 2894-2897
  int    OBEMCR06 2898-2901
  int    OBEMCD06 2902-2904
  int    OBEPRV06 2905-2908
  int    OBEVA06 2909-2911
  int    OBETRI06 2912-2915
  int    OBEOFD06 2916-2918
  int    OBESTL06 2919-2921
  int    OBEWCP06 2922-2924
  int    OBEOPR06 2925-2927
  int    OBEOPU06 2928-2930
  int    OBEOSR06 2931-2933
  byte   OBASST06 2934-2935
  long   OBATCH06 2936-2940
  long   OBAEXP06 2941-2945
  int    OBASLF06 2946-2949
  int    OBAMCR06 2950-2953
  int    OBAMCD06 2954-2957
  long   OBAPRV06 2958-2962
  int    OBAVA06 2963-2966
  int    OBATRI06 2967-2970
  int    OBAOFD06 2971-2973
  int    OBASTL06 2974-2976
  int    OBAWCP06 2977-2979
  int    OBAOPR06 2980-2983
  int    OBAOPU06 2984-2986
  int    OBAOSR06 2987-2989
  int    OBTHER06 2990-2992
  long   OBTTCH06 2993-2997
  long   OBTEXP06 2998-3002
  int    OBTSLF06 3003-3006
  int    OBTMCR06 3007-3010
  int    OBTMCD06 3011-3014
  int    OBTPRV06 3015-3018
  int    OBTVA06 3019-3022
  int    OBTTRI06 3023-3025
  int    OBTOFD06 3026-3028
  long   OBTSTL06 3029-3033
  long   OBTWCP06 3034-3038
  int    OBTOPR06 3039-3042
  int    OBTOPU06 3043-3045
  int    OBTOSR06 3046-3049
  int    OPTOTV06 3050-3052
  long   OPFTCH06 3053-3058
  long   OPFEXP06 3059-3063
  long   OPFSLF06 3064-3068
  long   OPFMCR06 3069-3073
  long   OPFMCD06 3074-3078
  long   OPFPRV06 3079-3083
  long   OPFVA06 3084-3088
  int    OPFTRI06 3089-3092
  int    OPFOFD06 3093-3096
  int    OPFSTL06 3097-3100
  long   OPFWCP06 3101-3105
  int    OPFOPR06 3106-3109
  int    OPFOPU06 3110-3113
  int    OPFOSR06 3114-3117
  long   OPDEXP06 3118-3122
  long   OPDTCH06 3123-3127
  int    OPDSLF06 3128-3131
  long   OPDMCR06 3132-3136
  int    OPDMCD06 3137-3140
  long   OPDPRV06 3141-3145
  int    OPDVA06 3146-3148
  int    OPDTRI06 3149-3152
  byte   OPDOFD06 3153-3154
  int    OPDSTL06 3155-3157
  int    OPDWCP06 3158-3161
  int    OPDOPR06 3162-3165
  int    OPDOPU06 3166-3169
  int    OPDOSR06 3170-3173
  byte   OPDRV06 3174-3175
  long   OPVTCH06 3176-3181
  long   OPVEXP06 3182-3186
  long   OPVSLF06 3187-3191
  long   OPVMCR06 3192-3196
  long   OPVMCD06 3197-3201
  long   OPVPRV06 3202-3206
  long   OPVVA06 3207-3211
  int    OPVTRI06 3212-3215
  int    OPVOFD06 3216-3219
  int    OPVSTL06 3220-3223
  long   OPVWCP06 3224-3228
  int    OPVOPR06 3229-3232
  int    OPVOPU06 3233-3236
  int    OPVOSR06 3237-3240
  long   OPSEXP06 3241-3245
  long   OPSTCH06 3246-3250
  int    OPSSLF06 3251-3254
  long   OPSMCR06 3255-3259
  int    OPSMCD06 3260-3263
  int    OPSPRV06 3264-3267
  int    OPSVA06 3268-3270
  int    OPSTRI06 3271-3274
  byte   OPSOFD06 3275-3275
  int    OPSSTL06 3276-3278
  int    OPSWCP06 3279-3282
  int    OPSOPR06 3283-3286
  int    OPSOPU06 3287-3289
  int    OPSOSR06 3290-3293
  int    OPOTHV06 3294-3296
  long   OPOTCH06 3297-3302
  long   OPOEXP06 3303-3307
  long   OPOSLF06 3308-3312
  long   OPOMCR06 3313-3317
  long   OPOMCD06 3318-3322
  long   OPOPRV06 3323-3327
  long   OPOVA06 3328-3332
  int    OPOTRI06 3333-3336
  int    OPOOFD06 3337-3339
  int    OPOSTL06 3340-3343
  int    OPOWCP06 3344-3347
  int    OPOOPR06 3348-3351
  int    OPOOPU06 3352-3355
  int    OPOOSR06 3356-3359
  long   OPPEXP06 3360-3364
  long   OPPTCH06 3365-3369
  int    OPPSLF06 3370-3373
  int    OPPMCR06 3374-3377
  int    OPPMCD06 3378-3381
  long   OPPPRV06 3382-3386
  int    OPPVA06 3387-3389
  int    OPPTRI06 3390-3392
  byte   OPPOFD06 3393-3394
  int    OPPSTL06 3395-3397
  int    OPPWCP06 3398-3400
  int    OPPOPR06 3401-3404
  int    OPPOPU06 3405-3408
  byte   OPPOSR06 3409-3410
  int    AMCHIR06 3411-3413
  long   AMCTCH06 3414-3418
  int    AMCEXP06 3419-3422
  int    AMCSLF06 3423-3426
  int    AMCMCR06 3427-3430
  int    AMCMCD06 3431-3434
  int    AMCPRV06 3435-3438
  int    AMCVA06 3439-3441
  int    AMCTRI06 3442-3444
  byte   AMCOFD06 3445-3446
  int    AMCSTL06 3447-3449
  int    AMCWCP06 3450-3453
  int    AMCOPR06 3454-3457
  int    AMCOPU06 3458-3460
  int    AMCOSR06 3461-3464
  int    AMNURS06 3465-3467
  long   AMNTCH06 3468-3473
  long   AMNEXP06 3474-3478
  int    AMNSLF06 3479-3482
  long   AMNMCR06 3483-3487
  long   AMNMCD06 3488-3492
  long   AMNPRV06 3493-3497
  long   AMNVA06 3498-3502
  int    AMNTRI06 3503-3506
  int    AMNOFD06 3507-3510
  int    AMNSTL06 3511-3514
  int    AMNWCP06 3515-3518
  int    AMNOPR06 3519-3522
  int    AMNOPU06 3523-3526
  int    AMNOSR06 3527-3530
  byte   AMOPTO06 3531-3532
  long   AMETCH06 3533-3537
  int    AMEEXP06 3538-3541
  int    AMESLF06 3542-3545
  int    AMEMCR06 3546-3549
  int    AMEMCD06 3550-3552
  int    AMEPRV06 3553-3556
  int    AMEVA06 3557-3559
  int    AMETRI06 3560-3563
  int    AMEOFD06 3564-3566
  int    AMESTL06 3567-3569
  int    AMEWCP06 3570-3572
  int    AMEOPR06 3573-3576
  int    AMEOPU06 3577-3579
  int    AMEOSR06 3580-3582
  byte   AMASST06 3583-3584
  long   AMATCH06 3585-3589
  long   AMAEXP06 3590-3594
  int    AMASLF06 3595-3598
  int    AMAMCR06 3599-3602
  int    AMAMCD06 3603-3606
  long   AMAPRV06 3607-3611
  int    AMAVA06 3612-3615
  int    AMATRI06 3616-3619
  int    AMAOFD06 3620-3622
  int    AMASTL06 3623-3625
  int    AMAWCP06 3626-3628
  int    AMAOPR06 3629-3632
  int    AMAOPU06 3633-3635
  int    AMAOSR06 3636-3639
  int    AMTHER06 3640-3642
  long   AMTTCH06 3643-3647
  long   AMTEXP06 3648-3652
  long   AMTSLF06 3653-3657
  int    AMTMCR06 3658-3661
  int    AMTMCD06 3662-3665
  long   AMTPRV06 3666-3670
  int    AMTVA06 3671-3674
  int    AMTTRI06 3675-3678
  int    AMTOFD06 3679-3681
  long   AMTSTL06 3682-3686
  long   AMTWCP06 3687-3691
  int    AMTOPR06 3692-3695
  int    AMTOPU06 3696-3698
  int    AMTOSR06 3699-3702
  byte   AMTOTC06 3703-3704
  byte   AMDRC06 3705-3706
  byte   ERTOT06 3707-3708
  long   ERFTCH06 3709-3713
  long   ERFEXP06 3714-3718
  int    ERFSLF06 3719-3722
  long   ERFMCR06 3723-3727
  long   ERFMCD06 3728-3732
  long   ERFPRV06 3733-3737
  long   ERFVA06 3738-3742
  int    ERFTRI06 3743-3746
  long   ERFOFD06 3747-3751
  int    ERFSTL06 3752-3755
  int    ERFWCP06 3756-3759
  int    ERFOPR06 3760-3763
  int    ERFOPU06 3764-3767
  int    ERFOSR06 3768-3771
  int    ERDEXP06 3772-3775
  long   ERDTCH06 3776-3780
  int    ERDSLF06 3781-3784
  int    ERDMCR06 3785-3788
  int    ERDMCD06 3789-3792
  int    ERDPRV06 3793-3796
  int    ERDVA06 3797-3799
  int    ERDTRI06 3800-3802
  byte   ERDOFD06 3803-3804
  int    ERDSTL06 3805-3807
  int    ERDWCP06 3808-3810
  int    ERDOPR06 3811-3814
  int    ERDOPU06 3815-3818
  int    ERDOSR06 3819-3821
  byte   IPZERO06 3822-3822
  long   ZIFTCH06 3823-3828
  long   ZIFEXP06 3829-3833
  int    ZIFSLF06 3834-3837
  long   ZIFMCR06 3838-3842
  int    ZIFMCD06 3843-3846
  long   ZIFPRV06 3847-3851
  long   ZIFVA06 3852-3856
  long   ZIFTRI06 3857-3861
  long   ZIFOFD06 3862-3866
  byte   ZIFSTL06 3867-3867
  int    ZIFWCP06 3868-3870
  int    ZIFOPR06 3871-3874
  int    ZIFOPU06 3875-3877
  long   ZIFOSR06 3878-3882
  long   ZIDEXP06 3883-3887
  long   ZIDTCH06 3888-3892
  int    ZIDSLF06 3893-3896
  long   ZIDMCR06 3897-3901
  int    ZIDMCD06 3902-3905
  int    ZIDPRV06 3906-3909
  int    ZIDVA06 3910-3913
  int    ZIDTRI06 3914-3916
  byte   ZIDOFD06 3917-3917
  byte   ZIDSTL06 3918-3918
  byte   ZIDWCP06 3919-3920
  long   ZIDOPR06 3921-3925
  int    ZIDOPU06 3926-3928
  int    ZIDOSR06 3929-3931
  byte   IPDIS06 3932-3932
  long   IPFEXP06 3933-3938
  long   IPFTCH06 3939-3945
  long   IPFSLF06 3946-3950
  long   IPFMCR06 3951-3956
  long   IPFMCD06 3957-3962
  long   IPFPRV06 3963-3968
  long   IPFVA06 3969-3974
  long   IPFTRI06 3975-3979
  long   IPFOFD06 3980-3984
  long   IPFSTL06 3985-3989
  long   IPFWCP06 3990-3994
  long   IPFOPR06 3995-3999
  long   IPFOPU06 4000-4004
  long   IPFOSR06 4005-4009
  long   IPDEXP06 4010-4014
  long   IPDTCH06 4015-4020
  int    IPDSLF06 4021-4024
  long   IPDMCR06 4025-4029
  long   IPDMCD06 4030-4034
  long   IPDPRV06 4035-4039
  int    IPDVA06 4040-4043
  int    IPDTRI06 4044-4047
  int    IPDOFD06 4048-4050
  int    IPDSTL06 4051-4054
  long   IPDWCP06 4055-4059
  long   IPDOPR06 4060-4064
  int    IPDOPU06 4065-4068
  int    IPDOSR06 4069-4072
  int    IPNGTD06 4073-4075
  byte   DVTOT06 4076-4077
  long   DVTTCH06 4078-4082
  long   DVTEXP06 4083-4087
  long   DVTSLF06 4088-4092
  int    DVTMCR06 4093-4096
  long   DVTMCD06 4097-4101
  long   DVTPRV06 4102-4106
  int    DVTVA06 4107-4110
  int    DVTTRI06 4111-4114
  int    DVTOFD06 4115-4118
  int    DVTSTL06 4119-4122
  int    DVTWCP06 4123-4126
  int    DVTOPR06 4127-4130
  int    DVTOPU06 4131-4134
  int    DVTOSR06 4135-4138
  byte   DVGEN06 4139-4140
  long   DVGTCH06 4141-4145
  long   DVGEXP06 4146-4150
  long   DVGSLF06 4151-4155
  int    DVGMCR06 4156-4159
  long   DVGMCD06 4160-4164
  long   DVGPRV06 4165-4169
  int    DVGVA06 4170-4173
  int    DVGTRI06 4174-4177
  int    DVGOFD06 4178-4181
  int    DVGSTL06 4182-4185
  int    DVGWCP06 4186-4189
  int    DVGOPR06 4190-4193
  int    DVGOPU06 4194-4197
  int    DVGOSR06 4198-4201
  byte   DVORTH06 4202-4203
  long   DVOTCH06 4204-4208
  long   DVOEXP06 4209-4213
  long   DVOSLF06 4214-4218
  byte   DVOMCR06 4219-4219
  int    DVOMCD06 4220-4223
  long   DVOPRV06 4224-4228
  int    DVOVA06 4229-4231
  int    DVOTRI06 4232-4235
  byte   DVOOFD06 4236-4236
  int    DVOSTL06 4237-4240
  int    DVOWCP06 4241-4243
  int    DVOOPR06 4244-4247
  byte   DVOOPU06 4248-4248
  int    DVOOSR06 4249-4252
  int    HHTOTD06 4253-4256
  int    HHAGD06 4257-4259
  long   HHATCH06 4260-4265
  long   HHAEXP06 4266-4271
  long   HHASLF06 4272-4276
  long   HHAMCR06 4277-4281
  long   HHAMCD06 4282-4286
  long   HHAPRV06 4287-4291
  int    HHAVA06 4292-4295
  int    HHATRI06 4296-4298
  int    HHAOFD06 4299-4302
  long   HHASTL06 4303-4307
  byte   HHAWCP06 4308-4308
  int    HHAOPR06 4309-4312
  int    HHAOPU06 4313-4315
  int    HHAOSR06 4316-4319
  int    HHINDD06 4320-4323
  long   HHNTCH06 4324-4328
  long   HHNEXP06 4329-4333
  long   HHNSLF06 4334-4338
  int    HHNMCR06 4339-4342
  long   HHNMCD06 4343-4347
  long   HHNPRV06 4348-4352
  int    HHNVA06 4353-4355
  byte   HHNTRI06 4356-4356
  int    HHNOFD06 4357-4360
  int    HHNSTL06 4361-4364
  byte   HHNWCP06 4365-4365
  int    HHNOPR06 4366-4368
  byte   HHNOPU06 4369-4369
  int    HHNOSR06 4370-4373
  int    HHINFD06 4374-4376
  int    VISEXP06 4377-4380
  int    VISTCH06 4381-4384
  int    VISSLF06 4385-4388
  int    VISMCR06 4389-4392
  int    VISMCD06 4393-4396
  int    VISPRV06 4397-4400
  int    VISVA06 4401-4404
  int    VISTRI06 4405-4407
  int    VISOFD06 4408-4410
  int    VISSTL06 4411-4413
  byte   VISWCP06 4414-4415
  int    VISOPR06 4416-4418
  int    VISOPU06 4419-4421
  int    VISOSR06 4422-4424
  long   OTHTCH06 4425-4429
  long   OTHEXP06 4430-4434
  long   OTHSLF06 4435-4439
  int    OTHMCR06 4440-4443
  long   OTHMCD06 4444-4448
  int    OTHPRV06 4449-4452
  int    OTHVA06 4453-4456
  int    OTHTRI06 4457-4460
  int    OTHOFD06 4461-4463
  int    OTHSTL06 4464-4466
  int    OTHWCP06 4467-4470
  int    OTHOPR06 4471-4474
  int    OTHOPU06 4475-4478
  int    OTHOSR06 4479-4482
  int    RXTOT06 4483-4485
  long   RXEXP06 4486-4491
  long   RXSLF06 4492-4496
  long   RXMCR06 4497-4502
  long   RXMCD06 4503-4507
  long   RXPRV06 4508-4513
  long   RXVA06 4514-4518
  long   RXTRI06 4519-4523
  int    RXOFD06 4524-4527
  int    RXSTL06 4528-4531
  int    RXWCP06 4532-4535
  int    RXOPR06 4536-4539
  long   RXOPU06 4540-4544
  int    RXOSR06 4545-4548
  double PERWT06F 4549-4560
  double FAMWT06F 4561-4572
  double FAMWT06C 4573-4584
  double SAQWT06F 4585-4596
  double DIABW06F 4597-4608
  int    VARSTR 4609-4611
  byte   VARPSU 4612-4612
using H105.dat;

*DEFINE VARIABLE LABELS;
label variable DUID "DWELLING UNIT ID";
label variable PID "PERSON NUMBER";
label variable DUPERSID "PERSID (DUID + PID)";
label variable PANEL "PANEL NUMBER";
label variable FAMID31 "FAMILY ID (STUDENT MERGED IN) - R3/1";
label variable FAMID42 "FAMILY ID (STUDENT MERGED IN) - R4/2";
label variable FAMID53 "FAMILY ID (STUDENT MERGED IN) - R5/3";
label variable FAMID06 "FAMILY ID (STUDENT MERGED IN) - 12/31/06";
label variable FAMIDYR "ANNUAL FAMILY IDENTIFIER";
label variable CPSFAMID "CPSFAMID";
label variable HIEUIDX "HIEU IDENTIFIER";
label variable FCSZ1231 "FAM SIZE RESPONDING 12/31 CPS FAMILY-06";
label variable FCRP1231 "REF PERSON OF 12/31 CPS FAMILY-06";
label variable RULETR31 "RU LETTER - R3/1";
label variable RULETR42 "RU LETTER - R4/2";
label variable RULETR53 "RU LETTER - R5/3";
label variable RULETR06 "RU LETTER AS OF 12/31/06";
label variable RUSIZE31 "RU SIZE - R3/1";
label variable RUSIZE42 "RU SIZE - R4/2";
label variable RUSIZE53 "RU SIZE - R5/3";
label variable RUSIZE06 "RU SIZE AS OF 12/31/06";
label variable RUCLAS31 "RU FIELDED AS:STANDARD/NEW/STUDENT-R3/1";
label variable RUCLAS42 "RU FIELDED AS:STANDARD/NEW/STUDENT-R4/2";
label variable RUCLAS53 "RU FIELDED AS:STANDARD/NEW/STUDENT-R5/3";
label variable RUCLAS06 "RU FIELDED AS:STANDARD/NEW/STUD-12/31/06";
label variable FAMSZE31 "RU SIZE INCLUDING STUDENTS - R3/1";
label variable FAMSZE42 "RU SIZE INCLUDING STUDENTS - R4/2";
label variable FAMSZE53 "RU SIZE INCLUDING STUDENTS - R5/3";
label variable FAMSZE06 "RU SIZE INCLUDING STUDENT AS OF 12/31/06";
label variable FMRS1231 "MEMBER OF RESPONDING 12/31 FAMILY";
label variable FAMS1231 "FAMILY SIZE OF RESPONDING 12/31 FAMILY";
label variable FAMSZEYR "SIZE OF RESPONDING ANNUALIZED FAMILY";
label variable FAMRFPYR "REFERENCE PERSON OF ANNUALIZED FAMILY";
label variable REGION31 "CENSUS REGION - R3/1";
label variable REGION42 "CENSUS REGION - R4/2";
label variable REGION53 "CENSUS REGION - R5/3";
label variable REGION06 "CENSUS REGION AS OF 12/31/06";
label variable MSA31 "MSA STATUS - R3/1";
label variable MSA42 "MSA STATUS - R4/2";
label variable MSA53 "MSA STATUS - R5/3";
label variable MSA06 "MSA AS OF 12/31/06";
label variable REFPRS31 "REFERENCE PERSON AT - R3/1";
label variable REFPRS42 "REFERENCE PERSON AT - R4/2";
label variable REFPRS53 "REFERENCE PERSON AT - R5/3";
label variable REFPRS06 "REFERENCE PERSON AS OF 12/31/06";
label variable RESP31 "1ST RESPONDENT INDICATOR FOR R3/1";
label variable RESP42 "1ST RESPONDENT INDICATOR FOR R4/2";
label variable RESP53 "1ST RESPONDENT INDICATOR FOR R5/3";
label variable RESP06 "1ST RESPONDENT INDICATOR AS OF 12/31/06";
label variable PROXY31 "WAS RESPONDENT A PROXY IN R3/1";
label variable PROXY42 "WAS RESPONDENT A PROXY IN R4/2";
label variable PROXY53 "WAS RESPONDENT A PROXY IN R5/3";
label variable PROXY06 "WAS RESPONDENT A PROXY AS OF 12/31/06";
label variable INTVLANG "LANGUAGE INTERVIEW WAS COMPLETED";
label variable BEGRFD31 "R3/1 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM31 "R3/1 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY31 "R3/1 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD31 "R3/1 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM31 "R3/1 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY31 "R3/1 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFD42 "R4/2 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM42 "R4/2 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY42 "R4/2 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD42 "R4/2 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM42 "R4/2 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY42 "R4/2 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFD53 "R5/3 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM53 "R5/3 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY53 "R5/3 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD53 "R5/3 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM53 "R5/3 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY53 "R5/3 REFERENCE PERIOD END DATE: YEAR";
label variable ENDRFD06 "2006 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM06 "2006 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY06 "2006 REFERENCE PERIOD END DATE: YEAR";
label variable KEYNESS "PERSON KEY STATUS";
label variable INSCOP31 "INSCOPE - R3/1";
label variable INSCOP42 "INSCOPE - R4/2";
label variable INSCOP53 "INSCOPE - R5/3";
label variable INSCOP06 "INSCOPE - R5/3 START THROUGH 12/31/06";
label variable INSC1231 "INSCOPE STATUS ON 12/31/06";
label variable INSCOPE "WAS PERSON EVER INSCOPE IN 2006";
label variable ELGRND31 "ELIGIBILITY - R3/1";
label variable ELGRND42 "ELIGIBILITY - R4/2";
label variable ELGRND53 "ELIGIBILITY - R5/3";
label variable ELGRND06 "ELIGIBILITY STATUS AS OF 12/31/06";
label variable PSTATS31 "PERSON DISPOSITION STATUS - R3/1";
label variable PSTATS42 "PERSON DISPOSITION STATUS - R4/2";
label variable PSTATS53 "PERSON DISPOSITION STATUS - R5/3";
label variable RURSLT31 "RU RESULT - R3/1";
label variable RURSLT42 "RU RESULT - R4/2";
label variable RURSLT53 "RU RESULT - R5/3";
label variable AGE31X "AGE - R3/1 (EDITED/IMPUTED)";
label variable AGE42X "AGE - R4/2 (EDITED/IMPUTED)";
label variable AGE53X "AGE - R5/3 (EDITED/IMPUTED)";
label variable AGE06X "AGE AS OF 12/31/06 (EDITED/IMPUTED)";
label variable DOBMM "DATE OF BIRTH: MONTH";
label variable DOBYY "DATE OF BIRTH: YEAR";
label variable SEX "SEX";
label variable RACEX "RACE (EDITED/IMPUTED)";
label variable RACEAX "ASIAN AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEBX "BLACK AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEWX "WHITE AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACETHNX "RACE/ETHNICITY (EDITED/IMPUTED)";
label variable HISPANX "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable HISPCAT "SPECIFIC HISPANIC ETHNICITY GROUP";
label variable MARRY31X "MARITAL STATUS - R3/1 (EDITED/IMPUTED)";
label variable MARRY42X "MARITAL STATUS - R4/2 (EDITED/IMPUTED)";
label variable MARRY53X "MARITAL STATUS - R5/3 (EDITED/IMPUTED)";
label variable MARRY06X "MARITAL STATUS-12/31/06 (EDITED/IMPUTED)";
label variable SPOUID31 "SPOUSE ID - R3/1";
label variable SPOUID42 "SPOUSE ID - R4/2";
label variable SPOUID53 "SPOUSE ID - R5/3";
label variable SPOUID06 "SPOUSE ID - 12/31/06";
label variable SPOUIN31 "MARITAL STATUS W/SPOUSE PRESENT-R3/1";
label variable SPOUIN42 "MARITAL STATUS W/SPOUSE PRESENT-R4/2";
label variable SPOUIN53 "MARITAL STATUS W/SPOUSE PRESENT-R5/3";
label variable SPOUIN06 "MARITAL STATUS W/SPOUSE PRESENT-12/31/06";
label variable EDUCYR "YEARS OF EDUC WHEN FIRST ENTERED MEPS";
label variable HIDEG "HIGHEST DEGREE WHEN FIRST ENTERED MEPS";
label variable FTSTU31X "STUDENT STATUS IF AGES 17-23 - R3/1";
label variable FTSTU42X "STUDENT STATUS IF AGES 17-23 - R4/2";
label variable FTSTU53X "STUDENT STATUS IF AGES 17-23 - R5/3";
label variable FTSTU06X "STUDENT STATUS IF AGES 17-23 - 12/31/06";
label variable ACTDTY31 "MILITARY FULL-TIME ACTIVE DUTY - R3/1";
label variable ACTDTY42 "MILITARY FULL-TIME ACTIVE DUTY - R4/2";
label variable ACTDTY53 "MILITARY FULL-TIME ACTIVE DUTY - R5/3";
label variable HONRDC31 "HONORABLY DISCHARGED FROM MILITARY";
label variable HONRDC42 "HONORABLY DISCHARGED FROM MILITARY";
label variable HONRDC53 "HONORABLY DISCHARGED FROM MILITARY";
label variable RFREL31X "RELATION TO REF PERS-R3/1 (EDIT/IMP)";
label variable RFREL42X "RELATION TO REF PERS-R4/2 (EDIT/IMP)";
label variable RFREL53X "RELATION TO REF PERS-R5/3 (EDIT/IMP)";
label variable RFREL06X "RELATION TO REF PERS-12/31/06 (EDIT/IMP)";
label variable MOPID31X "PID OF PERSON S MOM - RD 3/1";
label variable MOPID42X "PID OF PERSON S MOM - RD 4/2";
label variable MOPID53X "PID OF PERSON S MOM - RD 5/3";
label variable DAPID31X "PID OF PERSON S DAD - RD 3/1";
label variable DAPID42X "PID OF PERSON S DAD - RD 4/2";
label variable DAPID53X "PID OF PERSON S DAD - RD 5/3";
label variable SSIDIS06 "SSI RECEIPT DUE TO DISABILITY";
label variable AFDC06 "DID PERSON S CHECK INCLUDE TANF";
label variable FILEDR06 "HAS PERSON FILED A FED INCOME TAX RETURN";
label variable WILFIL06 "WILL PERSON FILE FED INCOME TAX RETURN";
label variable FLSTAT06 "PERSON S FILING STATUS";
label variable FILER06 "PRIMARY OR SECONDARY FILER";
label variable JTINRU06 "JOINT FILER S MEMBERSHIP IN RU";
label variable JNTPID06 "PID OF SECONDARY FILER";
label variable CLMDEP06 "DID/WILL PERS CLAIM DEPENDENTS ON RETURN";
label variable DEPDNT06 "PERSON IS FLAGGED A DEPENDENT";
label variable DPINRU06 "DEPENDENTS IN/OUT OF RU";
label variable DPOTSD06 "HOW MANY DEPENDENTS LIVE OUTSIDE RU";
label variable TAXFRM06 "TAX FORM PERSON WILL FILE";
label variable DEDUCT06 "ITEMIZE OR STANDARD DEDUCTION";
label variable TOTDED06 "TOTAL OF ALL ITEMIZED DEDUCTIONS";
label variable CLMHIP06 "DID/WILL PERS DEDUCT HEALTH INSUR. PREM.";
label variable EICRDT06 "DID/WILL PERS RECEIVE EARNED INC CREDIT";
label variable FOODST06 "DID ANYONE PURCHASE FOOD STAMPS";
label variable FOODMN06 "NUMBER OF MONTHS FOOD STAMPS PURCHASED";
label variable FOODVL06 "MONTHLY VALUE OF FOOD STAMPS";
label variable TTLP06X "PERSON S TOTAL INCOME";
label variable POVCAT06 "FAMILY INCOME AS PERCENT OF POVERTY LINE";
label variable WAGEP06X "PERSON S WAGE INCOME";
label variable WAGIMP06 "WAGE IMPUTATION FLAG";
label variable BUSNP06X "PERSON S BUSINESS INCOME";
label variable BUSIMP06 "BUSINESS INCOME IMPUTATION FLAG";
label variable UNEMP06X "PERSON S UNEMPLOYMENT COMP INCOME";
label variable UNEIMP06 "UNEMPLOYMENT IMPUTATION FLAG";
label variable WCMPP06X "PERSON S WORKERS  COMPENSATION";
label variable WCPIMP06 "WORKER S COMP IMPUTATION FLAG";
label variable INTRP06X "PERSON S INTEREST INCOME";
label variable INTIMP06 "INTEREST INCOME IMPUTATION FLAG";
label variable DIVDP06X "PERSON S DIVIDEND INCOME";
label variable DIVIMP06 "DIVIDEND INCOME IMPUTATION FLAG";
label variable SALEP06X "PERSON S SALES INCOME";
label variable SALIMP06 "SALES INCOME IMPUTATION FLAG";
label variable PENSP06X "PERSON S PENSION INCOME";
label variable PENIMP06 "PENSION INCOME IMPUTATION FLAG";
label variable SSECP06X "PERSON S SOCIAL SECURITY INCOME";
label variable SSCIMP06 "SOCIAL SECURITY INCOME IMPUTATION FLAG";
label variable TRSTP06X "PERSON S TRUST/RENT INCOME";
label variable TRTIMP06 "TRUST INCOME IMPUTATION FLAG";
label variable VETSP06X "PERSON S VETERANS INCOME";
label variable VETIMP06 "VETERAN S INCOME IMPUTATION FLAG";
label variable IRASP06X "PERSON S IRA INCOME";
label variable IRAIMP06 "IRA INCOME IMPUTATION FLAG";
label variable REFDP06X "PERSON S REFUND INCOME";
label variable REFIMP06 "REFUND INCOME IMPUTATION FLAG";
label variable ALIMP06X "PERSON S ALIMONY INCOME";
label variable ALIIMP06 "ALIMONY INCOME IMPUTATION FLAG";
label variable CHLDP06X "PERSON S CHILD SUPPORT";
label variable CHLIMP06 "CHILD SUPPORT IMPUTATION FLAG";
label variable CASHP06X "PERSON S OTHER REGULAR CASH CONTRIBUTION";
label variable CSHIMP06 "CASH CONTRIBUTION IMPUTATION FLAG";
label variable SSIP06X "PERSON S SSI";
label variable SSIIMP06 "SSI IMPUTATION FLAG";
label variable PUBP06X "PERSON S PUBLIC ASSISTANCE";
label variable PUBIMP06 "PUBLIC ASSISTANCE IMPUTATION FLAG";
label variable OTHRP06X "PERSON S OTHER INCOME";
label variable OTHIMP06 "OTHER INCOME IMPUTAION FLAG";
label variable RTHLTH31 "PERCEIVED HEALTH STATUS - RD 3/1";
label variable RTHLTH42 "PERCEIVED HEALTH STATUS - RD 4/2";
label variable RTHLTH53 "PERCEIVED HEALTH STATUS - RD 5/3";
label variable MNHLTH31 "PERCEIVED MENTAL HEALTH STATUS - RD 3/1";
label variable MNHLTH42 "PERCEIVED MENTAL HEALTH STATUS - RD 4/2";
label variable MNHLTH53 "PERCEIVED MENTAL HEALTH STATUS - RD 5/3";
label variable IADLHP31 "IADL SCREENER - RD 3/1";
label variable IADLHP42 "IADL SCREENER - RD 4/2";
label variable IADLHP53 "IADL SCREENER - RD 5/3";
label variable IADL3M31 "IADL HELP 3+ MONTHS - RD 3/1";
label variable IADL3M42 "IADL HELP 3+ MONTHS - RD 4/2";
label variable IADL3M53 "IADL HELP 3+ MONTHS - RD 5/3";
label variable ADLHLP31 "ADL SCREENER - RD 3/1";
label variable ADLHLP42 "ADL SCREENER - RD 4/2";
label variable ADLHLP53 "ADL SCREENER - RD 5/3";
label variable ADL3MO31 "ADL HELP 3+ MONTHS - RD 3/1";
label variable ADL3MO42 "ADL HELP 3+ MONTHS - RD 4/2";
label variable ADL3MO53 "ADL HELP 3+ MONTHS - RD 5/3";
label variable AIDHLP31 "USED ASSISTIVE DEVICES - RD 3/1";
label variable AIDHLP53 "USED ASSISTIVE DEVICES - RD 5/3";
label variable WLKLIM31 "LIMITATION IN PHYSICAL FUNCTIONING-RD3/1";
label variable WLKLIM53 "LIMITATION IN PHYSICAL FUNCTIONING-RD5/3";
label variable LFTDIF31 "DIFFICULTY LIFTING 10 POUNDS - RD 3/1";
label variable LFTDIF53 "DIFFICULTY LIFTING 10 POUNDS - RD 5/3";
label variable STPDIF31 "DIFFICULTY WALKING UP 10 STEPS - RD 3/1";
label variable STPDIF53 "DIFFICULTY WALKING UP 10 STEPS - RD 5/3";
label variable WLKDIF31 "DIFFICULTY WALKING 3 BLOCKS - RD 3/1";
label variable WLKDIF53 "DIFFICULTY WALKING 3 BLOCKS - RD 5/3";
label variable MILDIF31 "DIFFICULTY WALKING A MILE - RD 3/1";
label variable MILDIF53 "DIFFICULTY WALKING A MILE - RD 5/3";
label variable STNDIF31 "DIFFICULTY STANDING 20 MINUTES - RD 3/1";
label variable STNDIF53 "DIFFICULTY STANDING 20 MINUTES - RD 5/3";
label variable BENDIF31 "DIFFICULTY BENDING/STOOPING - RD 3/1";
label variable BENDIF53 "DIFFICULTY BENDING/STOOPING - RD 5/3";
label variable RCHDIF31 "DIFFICULTY REACHING OVERHEAD - RD 3/1";
label variable RCHDIF53 "DIFFICULTY REACHING OVERHEAD - RD 5/3";
label variable FNGRDF31 "DIFFICULTY USING FINGERS TO GRASP-RD 3/1";
label variable FNGRDF53 "DIFFICULTY USING FINGERS TO GRASP-RD 5/3";
label variable WLK3MO31 "PHYS FUNCTIONING HELP 3+ MONTHS - RD 3/1";
label variable WLK3MO53 "PHYS FUNCTIONING HELP 3+ MONTHS - RD 5/3";
label variable ACTLIM31 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 3/1";
label variable ACTLIM53 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 5/3";
label variable WRKLIM31 "WORK LIMITATION - RD 3/1";
label variable WRKLIM53 "WORK LIMITATION - RD 5/3";
label variable HSELIM31 "HOUSEWORK LIMITATION - RD 3/1";
label variable HSELIM53 "HOUSEWORK LIMITATION - RD 5/3";
label variable SCHLIM31 "SCHOOL LIMITATION - RD 3/1";
label variable SCHLIM53 "SCHOOL LIMITATION - RD 5/3";
label variable UNABLE31 "COMPLETELY UNABLE TO DO ACTIVITY-RD 3/1";
label variable UNABLE53 "COMPLETELY UNABLE TO DO ACTIVITY-RD 5/3";
label variable SOCLIM31 "SOCIAL LIMITATIONS - RD 3/1";
label variable SOCLIM53 "SOCIAL LIMITATIONS - RD 5/3";
label variable COGLIM31 "COGNITIVE LIMITATIONS - RD 3/1";
label variable COGLIM53 "COGNITIVE LIMITATIONS - RD 5/3";
label variable WRGLAS42 "WEARS EYEGLASSES OR CONTACTS - RD 4/2";
label variable SEEDIF42 "DIFFCLTY SEEING W/GLASSES/CNTCTS-RD 4/2";
label variable BLIND42 "PERSON IS BLIND - RD 4/2";
label variable READNW42 "CAN READ NEWSPRNT W/GLASSES/CNTCTS-RD4/2";
label variable RECPEP42 "CAN RECGNZE PEOPLE W/GLASSES/CNTCTS-R4/2";
label variable VISION42 "VISION IMPAIRMENT (SUMMARY) - RD 4/2";
label variable HEARAD42 "PERSON WEARS HEARING AID - RD 4/2";
label variable HEARDI42 "ANY DIFFCLTY HEARING W/HEARING AID-RD4/2";
label variable DEAF42 "PERSON IS DEAF - RD 4/2";
label variable HEARMO42 "CAN HEAR MOST CONVERSATION - RD 4/2";
label variable HEARSM42 "CAN HEAR SOME CONVERSATION - RD 4/2";
label variable HEARNG42 "HEARING IMPAIRMENT (SUMMARY) - RD 4/2";
label variable ANYLIM06 "ANY LIMITATION IN P10R3,4,5/P11R1,2,3";
label variable LSHLTH42 "LESS HEALTHY THAN OTHR CHILD (0-17)-R4/2";
label variable NEVILL42 "NEVER BEEN SERIOUSLY ILL (0-17)-R4/2";
label variable SICEAS42 "CHILD GETS SICK EASILY (0-17)-R4/2";
label variable HLTHLF42 "CHILD WILL HAVE HEALTHY LIFE (0-17)-R4/2";
label variable WRHLTH42 "WORRY MORE ABOUT HEALTH (0-17)-R4/2";
label variable CHPMED42 "CSHCN:CHILD NEEDS PRESCRB MED(0-17)-R4/2";
label variable CHPMHB42 "CSHCN:PMED FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHPMCN42 "CSHCN:PMED COND LAST 12+ MOS (0-17)-R4/2";
label variable CHSERV42 "CSHCN:CHLD NEEDS MED&OTH SERV(0-17)-R4/2";
label variable CHSRHB42 "CSHCN:SERV FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHSRCN42 "CSHCN:SERV COND LAST 12+ MOS (0-17)-R4/2";
label variable CHLIMI42 "CSHCN:LIMITED IN ANY WAY (0-17)-R4/2";
label variable CHLIHB42 "CSHCN:LIMT FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHLICO42 "CSHCN:LIMIT COND LAST 12+MOS (0-17)-R4/2";
label variable CHTHER42 "CSHCN:CHLD NEEDS SPEC THERAPY(0-17)-R4/2";
label variable CHTHHB42 "CSHCN:SPEC THER FOR HLTH+COND(0-17)-R4/2";
label variable CHTHCO42 "CSHCN:THER COND LAST 12+ MOS (0-17)-R4/2";
label variable CHCOUN42 "CSHCN:CHILD NEEDS COUNSELING (0-17)-R4/2";
label variable CHEMPB42 "CSHCN:COUNS PROB LAST 12+MOS (0-17)-R4/2";
label variable CSHCN42 "CSHCN:CHILD W/SPEC HC NEEDS (0-17)-R4/2";
label variable MOMPRO42 "PROBLEM GETTING ALONG W/MOM (5-17)-R4/2";
label variable DADPRO42 "PROBLEM GETTING ALONG W/DAD (5-17)-R4/2";
label variable UNHAP42 "PROBLEM FEELING UNHAPPY/SAD (5-17)-R4/2";
label variable SCHLBH42 "PROBLEM BEHAVIOR AT SCHOOL (5-17)-R4/2";
label variable HAVFUN42 "PROBLEM HAVING FUN (5-17) - R4/2";
label variable ADUPRO42 "PRBLM GETTING ALONG W/ADULTS (5-17)-R4/2";
label variable NERVAF42 "PRBLM FEELING NERVOUS/AFRAID (5-17)-R4/2";
label variable SIBPRO42 "PRBLM GETTING ALONG W/SIBS (5-17)-R4/2";
label variable KIDPRO42 "PRBLM GETTING ALONG W/KIDS (5-17)-R4/2";
label variable SPRPRO42 "PROBLEM W/SPORTS/HOBBIES (5-17)-R4/2";
label variable SCHPRO42 "PROBLEM WITH SCHOOLWORK (5-17)-R4/2";
label variable HOMEBH42 "PROBLEM W/BEHAVIOR AT HOME (5-17)-R4/2";
label variable TRBLE42 "PRBLM STAY OUT OF TROUBLE (5-17)-R4/2";
label variable CHILCR42 "CAHPS:12MOS:ILL/INJ NEED CARE(0-17)-R4/2";
label variable CHILWW42 "CAHPS:12MOS:ILL CARE WHN WNTD(0-17)-R4/2";
label variable CHRTCR42 "CAHPS:12MOS:MAKE ROUT CARE APT(0-17)R4/2";
label variable CHRTWW42 "CAHPS:12MOS:ROUT APT WHN WNTD(0-17)-R4/2";
label variable CHAPPT42 "CAHPS:12MOS:# OF OFF/CLIN APTS(0-17)R4/2";
label variable CHNDCR42 "CAHPS:12MOS:NEED ANY CARE/TRT(0-17)-R4/2";
label variable CHNECP42 "CAHPS:12MOS:PROB GET NEC CARE(0-17)R4/2";
label variable CHLIST42 "CAHPS:12MOS:CHLD DR LSN TO YOU(0-17)R4/2";
label variable CHEXPL42 "CAHPS:12MOS:CHLD DR EXPL THNG(0-17)R4/2";
label variable CHRESP42 "CAHPS:12MOS:CHLD S DR SHW RESP(0-17)R4/2";
label variable CHPRTM42 "CAHPS:12MOS:CHILD DR ENGH TIME(0-17)R4/2";
label variable CHHECR42 "CAHPS:12MOS:RATE CHLD HLT CARE(0-17)R4/2";
label variable CHSPEC42 "CAHPS:12MOS:CHLD NEEDED SPEC(0-17)R4/2";
label variable CHPRRE42 "CAHPS:12MOS:PRB W/RFR TO SPEC(0-17)R4/2";
label variable MESHGT42 "DOCTOR EVER MEASURED HEIGHT (0-17)-R4/2";
label variable WHNHGT42 "WHEN DOCTOR MEASURED HEIGHT (0-17)-R4/2";
label variable MESWGT42 "DOCTOR EVER MEASURED WEIGHT (0-17)-R4/2";
label variable WHNWGT42 "WHEN DOCTOR MEASURED WEIGHT (0-17)-R4/2";
label variable CHBMIX42 "CHILD S BODY MASS INDEX (6-17)-R4/2";
label variable MESVIS42 "DOCTOR CHECKED CHILD S VISION (3-6)-R4/2";
label variable MESBPR42 "DR CHECKED BLOOD PRESSURE (2-17)-R4/2";
label variable WHNBPR42 "WHEN DR CHECKED BLOOD PRESS (2-17)-R4/2";
label variable DENTAL42 "DR ADVISE REG DENTAL CHECKUP (2-17)-R4/2";
label variable WHNDEN42 "WHEN DR ADVISE DENT CHECKUP (2-17)-R4/2";
label variable EATHLT42 "DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable WHNEAT42 "WHEN DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable PHYSCL42 "DR ADVISE EXERCISE (2-17)-R4/2";
label variable WHNPHY42 "WHEN DR ADVISE EXERCISE (2-17)-R4/2";
label variable SAFEST42 "DR ADVISE CHLD SAFETY SEAT (WT<=40)-R4/2";
label variable WHNSAF42 "WHEN DR ADVISE SAFETY SEAT (WT<=40)-R4/2";
label variable BOOST42 "DR ADVISE BOOSTER SEAT (40<WT<=80)-R4/2";
label variable WHNBST42 "WHN DR ADVISE BOOST SEAT(40<WT<=80)-R4/2";
label variable LAPBLT42 "DR ADVISE LAP/SHOULDER BELT (80<WT)-R4/2";
label variable WHNLAP42 "WHN DR ADVISE LAP/SHLDR BLT (80<WT)-R4/2";
label variable HELMET42 "DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable WHNHEL42 "WHEN DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable NOSMOK42 "DR ADVISE SMKG IN HOME IS BAD(0-17)-R4/2";
label variable WHNSMK42 "WHN DR ADVIS SMKG IN HOME BAD(0-17)-R4/2";
label variable TIMALN42 "DOCTOR SPEND ANY TIME ALONE (12-17)-R4/2";
label variable DENTCK53 "HOW OFTEN DENTAL CHECK-UP - RD 5/3";
label variable CHOLCK53 "HOW LNG CHOLEST LST CHCK (>17) - RD 5/3";
label variable CHECK53 "HOW LNG LST ROUTNE CHECKUP (>17)-RD 5/3";
label variable FLUSHT53 "HOW LNG LAST FLU SHT (>17) - RD 5/3";
label variable LSTETH53 "LOST ALL UPPR AND LOWR TEETH (>17)-RD5/3";
label variable PSA53 "HOW LONG SINCE LAST PSA (>39) - RD 5/3";
label variable HYSTER53 "HAD A HYSTERECTOMY (>17) - RD 5/3";
label variable PAPSMR53 "HOW LNG LST PAP SMEAR TST (>17) - RD 5/3";
label variable BRSTEX53 "HOW LNG SNCE LST BREAST EXAM (>17)-RD5/3";
label variable MAMOGR53 "HOW LNG SNCE LST MAMMOGRAM (>29) - RD5/3";
label variable STOOL53 "BLD STOOL TST KIT/CRDS HOME (>17)-RD5/3";
label variable WHENST53 "WHN LST BLD STOOL TST HME KIT (>17)-R5/3";
label variable BOWEL53 "SIGMOIDOSCOPY/COLONOSCOPY (>17) - RD 5/3";
label variable WHNBWL53 "LST SIGMOIDOSCOP/COLONOSCOP (>17)-RD 5/3";
label variable PHYACT53 "MOD/VIG PHYS ACTIV 3X WK (>17) - RD 5/3";
label variable BMINDX53 "ADULT BODY MASS INDEX (>17) - RD 5/3";
label variable SEATBE53 "WEARS SEAT BELT (>15) - RD 5/3";
label variable SRTHRT53 "12MO: SERIOUS SORE THROAT(0-17)-RD 5/3";
label variable THSYMP53 "12MO:SORE THRT/OTH SYMPTMS(0-17)-RD 5/3";
label variable DRTHRT53 "12MO: SEE DR FOR SORE THRT(0-17)-RD 5/3";
label variable THANTB53 "12MO: DR PRES ANTBTC SRE THRT(0-17)RD5/3";
label variable THSWAB53 "12MO: DR GAVE THROAT SWAB(0-17)-RD 5/3";
label variable THSYMF53 "12MO:FAM SAME SRE THRT SYMP (0-17)RD5/3";
label variable THSWBF53 "12MO:DR GAVE FAM THRT SWAB(0-17)-RD5/3";
label variable THANTF53 "12MO:DR PRES FAM ATBTC SR THT(0-17)RD5/3";
label variable DIABDX53 "DIABETES DIAGNOSIS - RD 5/3";
label variable ASTHDX53 "ASTHMA DIAGNOSIS - RD 5/3";
label variable ASSTIL53 "DOES PERSON STILL HAVE ASTHMA - RD 5/3";
label variable ASATAK53 "ASTHMA ATTACK LAST 12 MOS - RD 5/3";
label variable ASACUT53 "USED ACUTE PRES INHALER LAST 3 MOS-RD5/3";
label variable ASMRCN53 "USED>3ACUTE CN PRES INH LAST 3 MOS-RD5/3";
label variable ASPREV53 "EVER USED PREV DAILY ASTHMA MEDS -RD 5/3";
label variable ASDALY53 "NOW TAKE PREV DAILY ASTHMA MEDS - RD 5/3";
label variable ASPKFL53 "HAVE PEAK FLOW METER AT HOME - RD 5/3";
label variable ASEVFL53 "EVER USED PEAK FLOW METER - RD 5/3";
label variable ASWNFL53 "WHEN LAST USED PEAK FLOW METER - RD 5/3";
label variable HIBPDX53 "HIGH BLOOD PRESSURE DIAG (>17) - RD 5/3";
label variable BPMLDX53 "MULT DIAG HIGH BLOOD PRESS (>17) - RD5/3";
label variable BPCHEK53 "TIME SNCE LST BLOOD PRES CHK (>17)-RD5/3";
label variable BPMONT53 "# MOS SNCE LST BLOOD PRES CHK (>17)-R5/3";
label variable CHOLDX53 "HIGH CHOLESTEROL DIAGNOSIS (>17) - RD5/3";
label variable CHLAGE53 "HOW OLD WHEN DIAG W/ HGH CHOL - RD5/3";
label variable CHDDX53 "CORONARY HRT DISEASE DIAG (>17) - RD 5/3";
label variable ANGIDX53 "ANGINA DIAGNOSIS (>17) - RD 5/3";
label variable MIDX53 "HEART ATTACK (MI) DIAG (>17) - RD 5/3";
label variable OHRTDX53 "OTHER HEART DISEASE DIAG (>17) - RD 5/3";
label variable STRKDX53 "STROKE DIAGNOSIS (>17) - RD 5/3";
label variable EMPHDX53 "EMPHYSEMA DIAGNOSIS (>17) - RD 5/3";
label variable NOFAT53 "RESTRICT HGH FAT/CHOLES FOOD (>17)-RD5/3";
label variable EXRCIS53 "ADVISED TO EXERCISE MORE (>17) - RD 5/3";
label variable ASPRIN53 "TKE ASPIRN EVERY (OTHR) DAY (>17)-RD 5/3";
label variable NOASPR53 "TAKING ASPIRIN UNSAFE (>17) - RD 5/3";
label variable STOMCH53 "TKE ASPRN UNSAFE B/C STOMCH (>17)-RD 5/3";
label variable JTPAIN53 "JOINT PAIN LAST 12 MONTHS (>17) - RD 5/3";
label variable ARTHDX53 "ARTHRITIS DIAGNOSIS (>17) - RD 5/3";
label variable ARTHTX53 "ARTHRITIS TREATMNT CURRENTLY (>17)RD5/3";
label variable SAQELIG "ELIGIBILITY STATUS FOR SAQ";
label variable ADPRX42 "SAQ: RELATIONSHIP OF PROXY TO ADULT";
label variable ADILCR42 "SAQ 12MOS: ILL/INJURY NEEDING IMMED CARE";
label variable ADILWW42 "SAQ 12 MOS: GOT CARE WHEN NEEDED ILL/INJ";
label variable ADRTCR42 "SAQ 12 MOS: MADE APPT ROUTINE MED CARE";
label variable ADRTWW42 "SAQ 12 MOS: GOT MED APPT WHEN WANTED";
label variable ADAPPT42 "SAQ 12 MOS: # VISITS TO MED OFF FOR CARE";
label variable ADNDCR42 "SAQ 12MOS: NEED ANY CARE, TEST, TREATMNT";
label variable ADNECP42 "SAQ 12MOS: PROBS GETTING NEEDED MED CARE";
label variable ADLIST42 "SAQ 12 MOS: DOCTOR LISTENED TO YOU";
label variable ADEXPL42 "SAQ 12 MOS: DOC EXPLAINED SO UNDERSTOOD";
label variable ADRESP42 "SAQ 12 MOS: DR SHOWED RESPECT";
label variable ADPRTM42 "SAQ 12 MOS: DR SPENT ENUF TIME WITH YOU";
label variable ADHECR42 "SAQ 12 MOS: RATING OF HEALTH CARE";
label variable ADSMOK42 "SAQ: CURRENTLY SMOKE";
label variable ADNSMK42 "SAQ 12MOS: DR ADVISED TO QUIT SMOKING";
label variable ADDRBP42 "SAQ 2 YRS: DR CHECKED BLOOD PRESSURE";
label variable ADSPEC42 "SAQ 12 MOS: NEEDED TO SEE SPECIALIST";
label variable ADPRRE42 "SAQ 12MOS: PROBLEM SEEING SPECIALIST";
label variable ADGENH42 "SAQ: HEALTH IN GENERAL SF-12V2";
label variable ADDAYA42 "SAQ: HLTH LIMITS MOD ACTIVITIES SF-12V2";
label variable ADCLIM42 "SAQ: HLTH LIMITS CLIMBING STAIRS SF-12V2";
label variable ADPALS42 "SAQ 4WKS:ACCMP LESS B/C PHY PRBS SF-12V2";
label variable ADPWLM42 "SAQ 4WKS:WORK LIMT B/C PHY PROBS SF-12V2";
label variable ADMALS42 "SAQ 4WKS:ACCMP LESS B/C MNT PRBS SF-12V2";
label variable ADMWLM42 "SAQ 4WKS:WORK LIMT B/C MNT PROBS SF-12V2";
label variable ADPAIN42 "SAQ 4WKS:PAIN LIMITS NORMAL WORK SF-12V2";
label variable ADCAPE42 "SAQ 4WKS: FELT CALM/PEACEFUL SF-12V2";
label variable ADNRGY42 "SAQ 4WKS: HAD A LOT OF ENERGY SF-12V2";
label variable ADDOWN42 "SAQ 4WKS: FELT DOWNHEARTED/DEPR SF-12V2";
label variable ADSOCA42 "SAQ 4WKS: HLTH STOPPED SOC ACTIV SF-12V2";
label variable PCS42 "SAQ:PHY COMPONENT SUMMRY SF-12V2 IMPUTED";
label variable MCS42 "SAQ:MNT COMPONENT SUMMRY SF-12V2 IMPUTED";
label variable SFFLAG42 "SAQ: PCS/MCS IMPUTATION FLAG SF-12V2";
label variable ADNERV42 "SAQ 30 DAYS: HOW OFTEN FELT NERVOUS";
label variable ADHOPE42 "SAQ 30 DAYS: HOW OFTEN FELT HOPELESS";
label variable ADREST42 "SAQ 30 DAYS: HOW OFTEN FELT RESTLESS";
label variable ADSAD42 "SAQ 30 DAYS: HOW OFTEN FELT SAD";
label variable ADEFRT42 "SAQ 30 DAYS: HOW OFTN EVRYTHNG AN EFFORT";
label variable ADWRTH42 "SAQ 30 DAYS: HOW OFTEN FELT WORTHLESS";
label variable K6SUM42 "SAQ 30 DAYS: OVERALL RATING OF FEELINGS";
label variable ADINTR42 "SAQ 2 WKS: LITTLE INTEREST IN THINGS";
label variable ADDPRS42 "SAQ 2 WKS: FELT DOWN/DEPRESSED/HOPELESS";
label variable PHQ242 "SAQ 2 WKS: OVERALL RATING OF FEELINGS";
label variable ADINSA42 "SAQ: DO NOT NEED HEALTH INSURANCE";
label variable ADINSB42 "SAQ: HEALTH INSURANCE NOT WORTH COST";
label variable ADRISK42 "SAQ: MORE LIKELY TO TAKE RISKS";
label variable ADOVER42 "SAQ: CAN OVERCOME ILLS WITHOUT MED HELP";
label variable ADCMPM42 "SAQ: DATE COMPLETED - MONTH";
label variable ADCMPD42 "SAQ: DATE COMPLETED - DAY";
label variable ADCMPY42 "SAQ: DATE COMPLETED - YEAR";
label variable ADLANG42 "SAQ: LANGUAGE OF SAQ INTERVIEW";
label variable DSDIA53 "DCS: DIABETES DIAGNOSIS BY HEALTH PROF";
label variable DSA1C53 "DCS: TIMES TESTED FOR A-ONE-C - 2006";
label variable DSCKFT53 "DCS: TIMES FEET CHECKED FOR SORES - 2006";
label variable DSEY0753 "DCS: DILATED EYE EXAM IN 2007";
label variable DSEY0653 "DCS: DILATED EYE EXAM IN 2006";
label variable DSEY0553 "DCS: DILATED EYE EXAM IN 2005";
label variable DSEB0553 "DCS: DILATED EYE EXAM BEFORE 2005";
label variable DSEYNV53 "DCS: NEVER HAD DILATED EYE EXAM";
label variable DSKIDN53 "DCS: HAS DIABETES CAUSED KIDNEY PROBLEMS";
label variable DSEYPR53 "DCS: HAS DIABETES CAUSED EYE PROBS";
label variable DSDIET53 "DCS: TREAT DIABETES W/DIET MODIFICATION";
label variable DSMED53 "DCS: TREAT DIABETES W/MEDS BY MOUTH";
label variable DSINSU53 "DCS: TREAT DIABETES W/INSULIN INJECTIONS";
label variable PHONE53 "DCS: LEARNED DIAB CARE FROM PHONE CALL";
label variable NURSE53 "DCS: LEARNED DIAB CARE FROM NURSE";
label variable VISIT53 "DCS: LEARNED DIAB CARE FROM HOME VISIT";
label variable REFER53 "DCS: LEARNED DIAB CARE FROM SPECIALIST";
label variable CHLCHK53 "DCS: HOW LONG SINCE CHOLESTEROL CHECK";
label variable FLSHOT53 "DCS: HOW LONG SINCE LAST FLU SHOT";
label variable DSPRX53 "DCS: WAS RESPONDENT A PROXY";
label variable DDNWRK31 "# DAYS MISSED WORK DUE TO ILL/INJ (RD31)";
label variable DDNWRK42 "# DAYS MISSED WORK DUE TO ILL/INJ (RD42)";
label variable DDNWRK53 "# DAYS MISSED WORK DUE TO ILL/INJ (RD53)";
label variable WKINBD31 "# DAYS MISSED WORK STAYED IN BED (RD31)";
label variable WKINBD42 "# DAYS MISSED WORK STAYED IN BED (RD42)";
label variable WKINBD53 "# DAYS MISSED WORK STAYED IN BED (RD53)";
label variable DDNSCL31 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD31)";
label variable DDNSCL42 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD42)";
label variable DDNSCL53 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD53)";
label variable SCLNBD31 "# DAYS MISSED SCHOOL STAYD IN BED (RD31)";
label variable SCLNBD42 "# DAYS MISSED SCHOOL STAYD IN BED (RD42)";
label variable SCLNBD53 "# DAYS MISSED SCHOOL STAYD IN BED (RD53)";
label variable DDBDYS31 "# OTH DAY SPENT IN BED SINCE START(RD31)";
label variable DDBDYS42 "# OTH DAY SPENT IN BED SINCE START(RD42)";
label variable DDBDYS53 "# OTH DAY SPENT IN BED SINCE START(RD53)";
label variable OTHDYS31 "MISS ANY WORK DAY TO CARE FOR OTH (RD31)";
label variable OTHDYS42 "MISS ANY WORK DAY TO CARE FOR OTH (RD42)";
label variable OTHDYS53 "MISS ANY WORK DAY TO CARE FOR OTH (RD53)";
label variable OTHNDD31 "# DAY MISSED WORK TO CARE FOR OTH (RD31)";
label variable OTHNDD42 "# DAY MISSED WORK TO CARE FOR OTH (RD42)";
label variable OTHNDD53 "# DAY MISSED WORK TO CARE FOR OTH (RD53)";
label variable ACCELI42 "PERS ELIGIBLE FOR ACCESS SUPPLEMENT-R4/2";
label variable LANGHM42 "AC01 LANGUAGE SPOKEN MOST IN HOME-R4/2";
label variable ENGHME42 "AC02 HH COMFORTABLE SPEAKNG ENGLISH-R4/2";
label variable ENGSPK42 "AC02A NOT COMFRTBLE SPEAKNG ENGLISH-R4/2";
label variable HAVEUS42 "AC05 DOES PERSON HAVE USC PROVIDER-R4/2";
label variable YNOUSC42 "AC07 MAIN REAS PERS DOESNT HAVE USC-R4/2";
label variable NOREAS42 "AC08 OTH REAS NO USC:NO OTH REASONS-R4/2";
label variable SELDSI42 "AC08 OTH REAS NO USC:SELDM/NEV SICK-R4/2";
label variable NEWARE42 "AC08 OTH REAS NO USC:RECENTLY MOVED-R4/2";
label variable DKWHRU42 "AC08 OTH REAS NO USC:DK WHERE TO GO-R4/2";
label variable USCNOT42 "AC08 OTH REAS NO USC: USC NOT AVAIL-R4/2";
label variable PERSLA42 "AC08 OTH REAS NO USC: LANGUAGE-R4/2";
label variable DIFFPL42 "AC08 OTH REAS NO USC:DIFFRNT PLACES-R4/2";
label variable INSRPL42 "AC08 OTH REAS NO USC:JUST CHNGD INS-R4/2";
label variable MYSELF42 "AC08 OTH REAS NO USC:NO DOC/TRT SLF-R4/2";
label variable CARECO42 "AC08 OTH REAS NO USC:COST OF MED CR-R4/2";
label variable OTHINS42 "AC08 OTH REAS NO USC: INS RELATED-R4/2";
label variable JOBRSN42 "AC08 OTH REAS NO USC: JOB RELATED-R4/2";
label variable NEWDOC42 "AC08 OTH REAS NO USC: LOOKNG FOR DR-R4/2";
label variable DOCELS42 "AC08 OTH REAS NO USC: DR ELSEWHERE-R4/2";
label variable NOLIKE42 "AC08 OTH REAS NO USC: DONT LIKE DRS-R4/2";
label variable KNOWDR42 "AC08 OTH REAS NO USC: KNOWS/IS A DR-R4/2";
label variable ONJOB42 "AC08 OTH REAS NO USC: DR AT WORK-R4/2";
label variable NOGODR42 "AC08 OTH REAS NO USC: WONT GO TO DR-R4/2";
label variable TRANS42 "AC08 OTH REAS NO USC: TRANSPRT/TIME-R4/2";
label variable CLINIC42 "AC08 OTH REAS NO USC: HOSP/ER/CLNIC-R4/2";
label variable OTHREA42 "AC08 OTH REAS NO USC: OTHER REASON-R4/2";
label variable PROVTY42 "PROVIDER TYPE-R4/2";
label variable FACLPR42 "AC10 DOES PERS SEE PARTICULAR PROV-R4/2";
label variable PLCTYP42 "USC TYPE OF PLACE-R4/2";
label variable GOTOUS42 "AC12 HOW DOES PERS GET TO USC PROV-R4/2";
label variable TMTKUS42 "AC13 HOW LONG IT TAKES GET TO USC-R4/2";
label variable DFTOUS42 "AC14 HOW DIFFICULT IS IT GET TO USC-R4/2";
label variable TYPEPE42 "USC TYPE OF PROVIDER-R4/2";
label variable LOCATN42 "USC LOCATION-R4/2";
label variable HSPLAP42 "AC18 IS PROVIDER HISPANIC OR LATINO-R4/2";
label variable WHITPR42 "AC19 IS PROVIDER WHITE-R4/2";
label variable BLCKPR42 "AC19 IS PROVIDER BLACK/AFRICAN AMER-R4/2";
label variable ASIANP42 "AC19 IS PROVIDER ASIAN-R4/2";
label variable NATAMP42 "AC19 IS PROVIDER NATIVE AMERICAN-R4/2";
label variable PACISP42 "AC19 IS PROVIDER OTH PACIFIC ISLNDR-R4/2";
label variable OTHRCP42 "AC19 IS PROVIDER SOME OTHER RACE-R4/2";
label variable GENDRP42 "AC20 IS PROVIDER MALE OR FEMALE-R4/2";
label variable MINORP42 "AC22 GO TO USC FOR NEW HEALTH PROB-R4/2";
label variable PREVEN42 "AC22 GO TO USC FOR PRVNTVE HLT CARE-R4/2";
label variable REFFRL42 "AC22 GO TO USC FOR REFERRALS-R4/2";
label variable ONGONG42 "AC22 GO TO USC FOR ONGOING HLTH PRB-R4/2";
label variable PHNREG42 "AC23 HOW DIFF CONTACT USC BY PHONE-R4/2";
label variable OFFHOU42 "AC24 USC HAS OFFCE HRS NGHTS/WKENDS-R4/2";
label variable AFTHOU42 "AC25 HOW DIFF CONTACT USC AFT HOURS-R4/2";
label variable TREATM42 "AC26 PROV ASK ABOUT OTH TREATMENTS-R4/2";
label variable RESPCT42 "AC27 PROV SHOWS RESPECT FOR TRTMNTS-R4/2";
label variable DECIDE42 "AC28 PROV ASKS PERS TO HELP DECIDE-R4/2";
label variable EXPLOP42 "AC30 PROV EXPLNS OPTIONS TO PERS-R4/2";
label variable LANGPR42 "AC31 PROV SPEAKS PERSON S LANGUAGE-R4/2";
label variable MDUNAB42 "UNABLE TO GET NECESSRY MEDICAL CARE-R4/2";
label variable MDUNRS42 "AC34 RSN UNABLE GET NECSRY MED CARE-R4/2";
label variable MDUNPR42 "AC35 PRB NOT GETTING NCSRY MED CARE-R4/2";
label variable MDDLAY42 "DELAYED IN GETTING NECSRY MED CARE-R4/2";
label variable MDDLRS42 "AC38 RSN DLAYD GETTING NEC MED CARE-R4/2";
label variable MDDLPR42 "AC39 PRB DLAYD GETTING NEC MED CARE-R4/2";
label variable DNUNAB42 "UNABLE TO GET NECESSARY DENTAL CARE-R4/2";
label variable DNUNRS42 "AC42 RSN UNABLE GET NCSRY DENT CARE-R4/2";
label variable DNUNPR42 "AC43 PRB UNABLE GET NCSRY DENT CARE-R4/2";
label variable DNDLAY42 "DELAYED IN GETTING NEC DENTAL CARE-R4/2";
label variable DNDLRS42 "AC46 RSN DLAYD GETTNG NEC DENT CARE-R4/2";
label variable DNDLPR42 "AC47 PRB DLAYD GETTNG NEC DENT CARE-R4/2";
label variable PMUNAB42 "UNABLE TO GET NECESSARY PRES MED-R4/2";
label variable PMUNRS42 "AC50 RSN UNABLE TO GET NEC PRES MED-R4/2";
label variable PMUNPR42 "AC51 PRB UNABLE TO GET NEC PRES MED-R4/2";
label variable PMDLAY42 "DELAYED IN GETTING NECSRY PRES MED-R4/2";
label variable PMDLRS42 "AC54 RSN DLAYD GETTING NEC PRES MED-R4/2";
label variable PMDLPR42 "AC55 PRB DLAYD GETTING NEC PRES MED-R4/2";
label variable EMPST31 "EMPLOYMENT STATUS RD 3/1";
label variable EMPST42 "EMPLOYMENT STATUS RD 4/2";
label variable EMPST53 "EMPLOYMENT STATUS RD 5/3";
label variable RNDFLG31 "DATA COLLECTION ROUND FOR RD 3/1 CMJ";
label variable MORJOB31 "HAS MORE THAN ONE JOB RD 3/1 INT DATE";
label variable MORJOB42 "HAS MORE THAN ONE JOB RD 4/2 INT DATE";
label variable MORJOB53 "HAS MORE THAN ONE JOB RD 5/3 INT DATE";
label variable EVRWRK "EVER WRKD FOR PAY IN LIFE AS OF 12/31/06";
label variable HRWG31X "HOURLY WAGE RD 3/1 CMJ (IMP)";
label variable HRWG42X "HOURLY WAGE RD 4/2 CMJ (IMP)";
label variable HRWG53X "HOURLY WAGE RD 5/3 CMJ (IMP)";
label variable HRWGIM31 "HRWG31X IMPUTATION FLAG";
label variable HRWGIM42 "HRWG42X IMPUTATION FLAG";
label variable HRWGIM53 "HRWG53X IMPUTATION FLAG";
label variable HRHOW31 "HOW HOURLY WAGE WAS CALCULATED RD 3/1";
label variable HRHOW42 "HOW HOURLY WAGE WAS CALCULATED RD 4/2";
label variable HRHOW53 "HOW HOURLY WAGE WAS CALCULATED RD 5/3";
label variable DIFFWG31 "PERSONS WAGES DIFFERENT THIS RD31 AT CMJ";
label variable DIFFWG42 "PERSONS WAGES DIFFERENT THIS RD42 AT CMJ";
label variable DIFFWG53 "PERSONS WAGES DIFFERENT THIS RD53 AT CMJ";
label variable NHRWG31 "UPDATED HRLY WAGE RD 3/1 CMJ (EDITED)";
label variable NHRWG42 "UPDATED HRLY WAGE RD 4/2 CMJ (EDITED)";
label variable NHRWG53 "UPDATED HRLY WAGE RD 5/3 CMJ (EDITED)";
label variable HOUR31 "HOURS PER WEEK AT RD 3/1 CMJ";
label variable HOUR42 "HOURS PER WEEK AT RD 4/2 CMJ";
label variable HOUR53 "HOURS PER WEEK AT RD 5/3 CMJ";
label variable TEMPJB31 "IS CMJ A TEMPORARY JOB RD 3/1";
label variable TEMPJB42 "IS CMJ A TEMPORARY JOB RD 4/2";
label variable TEMPJB53 "IS CMJ A TEMPORARY JOB RD 5/3";
label variable SSNLJB31 "IS CMJ A SEASONAL JOB RD 3/1";
label variable SSNLJB42 "IS CMJ A SEASONAL JOB RD 4/2";
label variable SSNLJB53 "IS CMJ A SEASONAL JOB RD 5/3";
label variable SELFCM31 "SELF-EMPLOYED AT RD 3/1 CMJ";
label variable SELFCM42 "SELF-EMPLOYED AT RD 4/2 CMJ";
label variable SELFCM53 "SELF-EMPLOYED AT RD 5/3 CMJ";
label variable DISVW31X "DISAVOWED HEALTH INS AT RD 3/1 CMJ (ED)";
label variable DISVW42X "DISAVOWED HEALTH INS AT RD 4/2 CMJ (ED)";
label variable DISVW53X "DISAVOWED HEALTH INS AT RD 5/3 CMJ (ED)";
label variable CHOIC31 "CHOICE OF HEALTH PLANS AT RD 3/1 CMJ";
label variable CHOIC42 "CHOICE OF HEALTH PLANS AT RD 4/2 CMJ";
label variable CHOIC53 "CHOICE OF HEALTH PLANS AT RD 5/3 CMJ";
label variable INDCAT31 "INDUSTRY GROUP RD 3/1 CMJ";
label variable INDCAT42 "INDUSTRY GROUP RD 4/2 CMJ";
label variable INDCAT53 "INDUSTRY GROUP RD 5/3 CMJ";
label variable NUMEMP31 "NUMBER OF EMPLOYEES AT RD 3/1 CMJ";
label variable NUMEMP42 "NUMBER OF EMPLOYEES AT RD 4/2 CMJ";
label variable NUMEMP53 "NUMBER OF EMPLOYEES AT RD 5/3 CMJ";
label variable MORE31 "RD 3/1 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE42 "RD 4/2 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE53 "RD 5/3 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable UNION31 "UNION STATUS AT RD 3/1 CMJ";
label variable UNION42 "UNION STATUS AT RD 4/2 CMJ";
label variable UNION53 "UNION STATUS AT RD 5/3 CMJ";
label variable NWK31 "REASON NOT WORKING DURING RD 3/1";
label variable NWK42 "REASON NOT WORKING DURING RD 4/2";
label variable NWK53 "REASON NOT WORKING DURING RD 5/3";
label variable CHGJ3142 "CHANGED JOB BETWEEN RD 3/1 AND RD 4/2";
label variable CHGJ4253 "CHANGED JOB BETWEEN RD 4/2 AND RD 5/3";
label variable YCHJ3142 "WHY CHNGD JOB BETWEEN RD 3/1 AND RD 4/2";
label variable YCHJ4253 "WHY CHNGD JOB BETWEEN RD 4/2 AND RD 5/3";
label variable STJBMM31 "MONTH STARTED RD 3/1 CMJ";
label variable STJBDD31 "DAY STARTED RD 3/1 CMJ";
label variable STJBYY31 "YEAR STARTED RD 3/1 CMJ";
label variable STJBMM42 "MONTH STARTED RD 4/2 CMJ";
label variable STJBDD42 "DAY STARTED RD 4/2 CMJ";
label variable STJBYY42 "YEAR STARTED RD 4/2 CMJ";
label variable STJBMM53 "MONTH STARTED RD 5/3 CMJ";
label variable STJBDD53 "DAY STARTED RD 5/3 CMJ";
label variable STJBYY53 "YEAR STARTED RD 5/3 CMJ";
label variable EVRETIRE "PERSON HAS EVER RETIRED";
label variable OCCCAT31 "OCCUPATION GROUP RD 3/1 CMJ";
label variable OCCCAT42 "OCCUPATION GROUP RD 4/2 CMJ";
label variable OCCCAT53 "OCCUPATION GROUP RD 5/3 CMJ";
label variable PAYVAC31 "PAID VACATION AT RD 3/1 CMJ";
label variable PAYVAC42 "PAID VACATION AT RD 4/2 CMJ";
label variable PAYVAC53 "PAID VACATION AT RD 5/3 CMJ";
label variable SICPAY31 "PAID SICK LEAVE AT RD 3/1 CMJ";
label variable SICPAY42 "PAID SICK LEAVE AT RD 4/2 CMJ";
label variable SICPAY53 "PAID SICK LEAVE AT RD 5/3 CMJ";
label variable PAYDR31 "PAID LEAVE TO VISIT DR RD 3/1 CMJ";
label variable PAYDR42 "PAID LEAVE TO VISIT DR RD 4/2 CMJ";
label variable PAYDR53 "PAID LEAVE TO VISIT DR RD 5/3 CMJ";
label variable RETPLN31 "PENSION PLAN AT RD 3/1 CMJ";
label variable RETPLN42 "PENSION PLAN AT RD 4/2 CMJ";
label variable RETPLN53 "PENSION PLAN AT RD 5/3 CMJ";
label variable BSNTY31 "SOLE PROP, PARTNER, CORP, RD 3/1 CMJ";
label variable BSNTY42 "SOLE PROP, PARTNER, CORP, RD 4/2 CMJ";
label variable BSNTY53 "SOLE PROP, PARTNER, CORP, RD 5/3 CMJ";
label variable JOBORG31 "PRIV (PROFIT,NONPROFIT) GOV RD 3/1 CMJ";
label variable JOBORG42 "PRIV (PROFIT,NONPROFIT) GOV RD 4/2 CMJ";
label variable JOBORG53 "PRIV (PROFIT,NONPROFIT) GOV RD 5/3 CMJ";
label variable HELD31X "HEALTH INSUR HELD FROM RD 3/1 CMJ (ED)";
label variable HELD42X "HEALTH INSUR HELD FROM RD 4/2 CMJ (ED)";
label variable HELD53X "HEALTH INSUR HELD FROM RD 5/3 CMJ (ED)";
label variable OFFER31X "HEALTH INSUR OFFERED BY RD 3/1 CMJ (ED)";
label variable OFFER42X "HEALTH INSUR OFFERED BY RD 4/2 CMJ (ED)";
label variable OFFER53X "HEALTH INSUR OFFERED BY RD 5/3 CMJ (ED)";
label variable OFREMP31 "EMPLOYER OFFERS HEALTH INS RD 3/1 CMJ";
label variable OFREMP42 "EMPLOYER OFFERS HEALTH INS RD 4/2 CMJ";
label variable OFREMP53 "EMPLOYER OFFERS HEALTH INS RD 5/3 CMJ";
label variable YNOINS31 "WHY NOT ELIGIBLE HEALTH INS RD 3/1 CMJ";
label variable YNOINS42 "WHY NOT ELIGIBLE HEALTH INS RD 4/2 CMJ";
label variable YNOINS53 "WHY NOT ELIGIBLE HEALTH INS RD 5/3 CMJ";
label variable TRIJA06X "COVERED BY TRICARE/CHAMPVA IN JAN06 (ED)";
label variable TRIFE06X "COVERED BY TRICARE/CHAMPVA IN FEB06 (ED)";
label variable TRIMA06X "COVERED BY TRICARE/CHAMPVA IN MAR06 (ED)";
label variable TRIAP06X "COVERED BY TRICARE/CHAMPVA IN APR06 (ED)";
label variable TRIMY06X "COVERED BY TRICARE/CHAMPVA IN MAY06 (ED)";
label variable TRIJU06X "COVERED BY TRICARE/CHAMPVA IN JUN06 (ED)";
label variable TRIJL06X "COVERED BY TRICARE/CHAMPVA IN JUL06 (ED)";
label variable TRIAU06X "COVERED BY TRICARE/CHAMPVA IN AUG06 (ED)";
label variable TRISE06X "COVERED BY TRICARE/CHAMPVA IN SEP06 (ED)";
label variable TRIOC06X "COVERED BY TRICARE/CHAMPVA IN OCT06 (ED)";
label variable TRINO06X "COVERED BY TRICARE/CHAMPVA IN NOV06 (ED)";
label variable TRIDE06X "COVERED BY TRICARE/CHAMPVA IN DEC06 (ED)";
label variable MCRJA06 "COVERED BY MEDICARE IN JAN06";
label variable MCRFE06 "COVERED BY MEDICARE IN FEB06";
label variable MCRMA06 "COVERED BY MEDICARE IN MAR06";
label variable MCRAP06 "COVERED BY MEDICARE IN APR06";
label variable MCRMY06 "COVERED BY MEDICARE IN MAY06";
label variable MCRJU06 "COVERED BY MEDICARE IN JUN06";
label variable MCRJL06 "COVERED BY MEDICARE IN JUL06";
label variable MCRAU06 "COVERED BY MEDICARE IN AUG06";
label variable MCRSE06 "COVERED BY MEDICARE IN SEP06";
label variable MCROC06 "COVERED BY MEDICARE IN OCT06";
label variable MCRNO06 "COVERED BY MEDICARE IN NOV06";
label variable MCRDE06 "COVERED BY MEDICARE IN DEC06";
label variable MCRJA06X "COVERED BY MEDICARE IN JAN06 (ED)";
label variable MCRFE06X "COVERED BY MEDICARE IN FEB06 (ED)";
label variable MCRMA06X "COVERED BY MEDICARE IN MAR06 (ED)";
label variable MCRAP06X "COVERED BY MEDICARE IN APR06 (ED)";
label variable MCRMY06X "COVERED BY MEDICARE IN MAY06 (ED)";
label variable MCRJU06X "COVERED BY MEDICARE IN JUN06 (ED)";
label variable MCRJL06X "COVERED BY MEDICARE IN JUL06 (ED)";
label variable MCRAU06X "COVERED BY MEDICARE IN AUG06 (ED)";
label variable MCRSE06X "COVERED BY MEDICARE IN SEP06 (ED)";
label variable MCROC06X "COVERED BY MEDICARE IN OCT06 (ED)";
label variable MCRNO06X "COVERED BY MEDICARE IN NOV06 (ED)";
label variable MCRDE06X "COVERED BY MEDICARE IN DEC06 (ED)";
label variable MCDJA06 "COV BY MEDICAID OR SCHIP IN JAN06";
label variable MCDFE06 "COV BY MEDICAID OR SCHIP IN FEB06";
label variable MCDMA06 "COV BY MEDICAID OR SCHIP IN MAR06";
label variable MCDAP06 "COV BY MEDICAID OR SCHIP IN APR06";
label variable MCDMY06 "COV BY MEDICAID OR SCHIP IN MAY06";
label variable MCDJU06 "COV BY MEDICAID OR SCHIP IN JUN06";
label variable MCDJL06 "COV BY MEDICAID OR SCHIP IN JUL06";
label variable MCDAU06 "COV BY MEDICAID OR SCHIP IN AUG06";
label variable MCDSE06 "COV BY MEDICAID OR SCHIP IN SEP06";
label variable MCDOC06 "COV BY MEDICAID OR SCHIP IN OCT06";
label variable MCDNO06 "COV BY MEDICAID OR SCHIP IN NOV06";
label variable MCDDE06 "COV BY MEDICAID OR SCHIP IN DEC06";
label variable MCDJA06X "COV BY MEDICAID OR SCHIP IN JAN06 (ED)";
label variable MCDFE06X "COV BY MEDICAID OR SCHIP IN FEB06 (ED)";
label variable MCDMA06X "COV BY MEDICAID OR SCHIP IN MAR06 (ED)";
label variable MCDAP06X "COV BY MEDICAID OR SCHIP IN APR06 (ED)";
label variable MCDMY06X "COV BY MEDICAID OR SCHIP IN MAY06 (ED)";
label variable MCDJU06X "COV BY MEDICAID OR SCHIP IN JUN06 (ED)";
label variable MCDJL06X "COV BY MEDICAID OR SCHIP IN JUL06 (ED)";
label variable MCDAU06X "COV BY MEDICAID OR SCHIP IN AUG06 (ED)";
label variable MCDSE06X "COV BY MEDICAID OR SCHIP IN SEP06 (ED)";
label variable MCDOC06X "COV BY MEDICAID OR SCHIP IN OCT06 (ED)";
label variable MCDNO06X "COV BY MEDICAID OR SCHIP IN NOV06 (ED)";
label variable MCDDE06X "COV BY MEDICAID OR SCHIP IN DEC06 (ED)";
label variable OPAJA06 "COV BY OTHER PUBLIC A INS IN JAN06";
label variable OPAFE06 "COV BY OTHER PUBLIC A INS IN FEB06";
label variable OPAMA06 "COV BY OTHER PUBLIC A INS IN MAR06";
label variable OPAAP06 "COV BY OTHER PUBLIC A INS IN APR06";
label variable OPAMY06 "COV BY OTHER PUBLIC A INS IN MAY06";
label variable OPAJU06 "COV BY OTHER PUBLIC A INS IN JUN06";
label variable OPAJL06 "COV BY OTHER PUBLIC A INS IN JUL06";
label variable OPAAU06 "COV BY OTHER PUBLIC A INS IN AUG06";
label variable OPASE06 "COV BY OTHER PUBLIC A INS IN SEP06";
label variable OPAOC06 "COV BY OTHER PUBLIC A INS IN OCT06";
label variable OPANO06 "COV BY OTHER PUBLIC A INS IN NOV06";
label variable OPADE06 "COV BY OTHER PUBLIC A INS IN DEC06";
label variable OPBJA06 "COV BY OTHER PUBLIC B INS IN JAN06";
label variable OPBFE06 "COV BY OTHER PUBLIC B INS IN FEB06";
label variable OPBMA06 "COV BY OTHER PUBLIC B INS IN MAR06";
label variable OPBAP06 "COV BY OTHER PUBLIC B INS IN APR06";
label variable OPBMY06 "COV BY OTHER PUBLIC B INS IN MAY06";
label variable OPBJU06 "COV BY OTHER PUBLIC B INS IN JUN06";
label variable OPBJL06 "COV BY OTHER PUBLIC B INS IN JUL06";
label variable OPBAU06 "COV BY OTHER PUBLIC B INS IN AUG06";
label variable OPBSE06 "COV BY OTHER PUBLIC B INS IN SEP06";
label variable OPBOC06 "COV BY OTHER PUBLIC B INS IN OCT06";
label variable OPBNO06 "COV BY OTHER PUBLIC B INS IN NOV06";
label variable OPBDE06 "COV BY OTHER PUBLIC B INS IN DEC06";
label variable STAJA06 "COVERED BY OTHER STATE PROG IN JAN06";
label variable STAFE06 "COVERED BY OTHER STATE PROG IN FEB06";
label variable STAMA06 "COVERED BY OTHER STATE PROG IN MAR06";
label variable STAAP06 "COVERED BY OTHER STATE PROG IN APR06";
label variable STAMY06 "COVERED BY OTHER STATE PROG IN MAY06";
label variable STAJU06 "COVERED BY OTHER STATE PROG IN JUN06";
label variable STAJL06 "COVERED BY OTHER STATE PROG IN JUL06";
label variable STAAU06 "COVERED BY OTHER STATE PROG IN AUG06";
label variable STASE06 "COVERED BY OTHER STATE PROG IN SEP06";
label variable STAOC06 "COVERED BY OTHER STATE PROG IN OCT06";
label variable STANO06 "COVERED BY OTHER STATE PROG IN NOV06";
label variable STADE06 "COVERED BY OTHER STATE PROG IN DEC06";
label variable PUBJA06X "COVR BY ANY PUBLIC INS IN JAN06 (ED)";
label variable PUBFE06X "COVR BY ANY PUBLIC INS IN FEB06 (ED)";
label variable PUBMA06X "COVR BY ANY PUBLIC INS IN MAR06 (ED)";
label variable PUBAP06X "COVR BY ANY PUBLIC INS IN APR06 (ED)";
label variable PUBMY06X "COVR BY ANY PUBLIC INS IN MAY06 (ED)";
label variable PUBJU06X "COVR BY ANY PUBLIC INS IN JUN06 (ED)";
label variable PUBJL06X "COVR BY ANY PUBLIC INS IN JUL06 (ED)";
label variable PUBAU06X "COVR BY ANY PUBLIC INS IN AUG06 (ED)";
label variable PUBSE06X "COVR BY ANY PUBLIC INS IN SEP06 (ED)";
label variable PUBOC06X "COVR BY ANY PUBLIC INS IN OCT06 (ED)";
label variable PUBNO06X "COVR BY ANY PUBLIC INS IN NOV06 (ED)";
label variable PUBDE06X "COVR BY ANY PUBLIC INS IN DEC06 (ED)";
label variable PEGJA06 "COVERED BY EMPL UNION INS IN JAN06";
label variable PEGFE06 "COVERED BY EMPL UNION INS IN FEB06";
label variable PEGMA06 "COVERED BY EMPL UNION INS IN MAR06";
label variable PEGAP06 "COVERED BY EMPL UNION INS IN APR06";
label variable PEGMY06 "COVERED BY EMPL UNION INS IN MAY06";
label variable PEGJU06 "COVERED BY EMPL UNION INS IN JUN06";
label variable PEGJL06 "COVERED BY EMPL UNION INS IN JUL06";
label variable PEGAU06 "COVERED BY EMPL UNION INS IN AUG06";
label variable PEGSE06 "COVERED BY EMPL UNION INS IN SEP06";
label variable PEGOC06 "COVERED BY EMPL UNION INS IN OCT06";
label variable PEGNO06 "COVERED BY EMPL UNION INS IN NOV06";
label variable PEGDE06 "COVERED BY EMPL UNION INS IN DEC06";
label variable PDKJA06 "COVR BY PRIV INS (SOURCE UNKNWN) JAN06";
label variable PDKFE06 "COVR BY PRIV INS (SOURCE UNKNWN) FEB06";
label variable PDKMA06 "COVR BY PRIV INS (SOURCE UNKNWN) MAR06";
label variable PDKAP06 "COVR BY PRIV INS (SOURCE UNKNWN) APR06";
label variable PDKMY06 "COVR BY PRIV INS (SOURCE UNKNWN) MAY06";
label variable PDKJU06 "COVR BY PRIV INS (SOURCE UNKNWN) JUN06";
label variable PDKJL06 "COVR BY PRIV INS (SOURCE UNKNWN) JUL06";
label variable PDKAU06 "COVR BY PRIV INS (SOURCE UNKNWN) AUG06";
label variable PDKSE06 "COVR BY PRIV INS (SOURCE UNKNWN) SEP06";
label variable PDKOC06 "COVR BY PRIV INS (SOURCE UNKNWN) OCT06";
label variable PDKNO06 "COVR BY PRIV INS (SOURCE UNKNWN) NOV06";
label variable PDKDE06 "COVR BY PRIV INS (SOURCE UNKNWN) DEC06";
label variable PNGJA06 "COVERED BY NONGROUP INS IN JAN06";
label variable PNGFE06 "COVERED BY NONGROUP INS IN FEB06";
label variable PNGMA06 "COVERED BY NONGROUP INS IN MAR06";
label variable PNGAP06 "COVERED BY NONGROUP INS IN APR06";
label variable PNGMY06 "COVERED BY NONGROUP INS IN MAY06";
label variable PNGJU06 "COVERED BY NONGROUP INS IN JUN06";
label variable PNGJL06 "COVERED BY NONGROUP INS IN JUL06";
label variable PNGAU06 "COVERED BY NONGROUP INS IN AUG06";
label variable PNGSE06 "COVERED BY NONGROUP INS IN SEP06";
label variable PNGOC06 "COVERED BY NONGROUP INS IN OCT06";
label variable PNGNO06 "COVERED BY NONGROUP INS IN NOV06";
label variable PNGDE06 "COVERED BY NONGROUP INS IN DEC06";
label variable POGJA06 "COVERED BY OTHER GROUP INS IN JAN06";
label variable POGFE06 "COVERED BY OTHER GROUP INS IN FEB06";
label variable POGMA06 "COVERED BY OTHER GROUP INS IN MAR06";
label variable POGAP06 "COVERED BY OTHER GROUP INS IN APR06";
label variable POGMY06 "COVERED BY OTHER GROUP INS IN MAY06";
label variable POGJU06 "COVERED BY OTHER GROUP INS IN JUN06";
label variable POGJL06 "COVERED BY OTHER GROUP INS IN JUL06";
label variable POGAU06 "COVERED BY OTHER GROUP INS IN AUG06";
label variable POGSE06 "COVERED BY OTHER GROUP INS IN SEP06";
label variable POGOC06 "COVERED BY OTHER GROUP INS IN OCT06";
label variable POGNO06 "COVERED BY OTHER GROUP INS IN NOV06";
label variable POGDE06 "COVERED BY OTHER GROUP INS IN DEC06";
label variable PRSJA06 "COVERED BY SELF-EMP-1 INS IN JAN06";
label variable PRSFE06 "COVERED BY SELF-EMP-1 INS IN FEB06";
label variable PRSMA06 "COVERED BY SELF-EMP-1 INS IN MAR06";
label variable PRSAP06 "COVERED BY SELF-EMP-1 INS IN APR06";
label variable PRSMY06 "COVERED BY SELF-EMP-1 INS IN MAY06";
label variable PRSJU06 "COVERED BY SELF-EMP-1 INS IN JUN06";
label variable PRSJL06 "COVERED BY SELF-EMP-1 INS IN JUL06";
label variable PRSAU06 "COVERED BY SELF-EMP-1 INS IN AUG06";
label variable PRSSE06 "COVERED BY SELF-EMP-1 INS IN SEP06";
label variable PRSOC06 "COVERED BY SELF-EMP-1 INS IN OCT06";
label variable PRSNO06 "COVERED BY SELF-EMP-1 INS IN NOV06";
label variable PRSDE06 "COVERED BY SELF-EMP-1 INS IN DEC06";
label variable POUJA06 "COVERED BY HOLDER OUTSIDE OF RU IN JAN06";
label variable POUFE06 "COVERED BY HOLDER OUTSIDE OF RU IN FEB06";
label variable POUMA06 "COVERED BY HOLDER OUTSIDE OF RU IN MAR06";
label variable POUAP06 "COVERED BY HOLDER OUTSIDE OF RU IN APR06";
label variable POUMY06 "COVERED BY HOLDER OUTSIDE OF RU IN MAY06";
label variable POUJU06 "COVERED BY HOLDER OUTSIDE OF RU IN JUN06";
label variable POUJL06 "COVERED BY HOLDER OUTSIDE OF RU IN JUL06";
label variable POUAU06 "COVERED BY HOLDER OUTSIDE OF RU IN AUG06";
label variable POUSE06 "COVERED BY HOLDER OUTSIDE OF RU IN SEP06";
label variable POUOC06 "COVERED BY HOLDER OUTSIDE OF RU IN OCT06";
label variable POUNO06 "COVERED BY HOLDER OUTSIDE OF RU IN NOV06";
label variable POUDE06 "COVERED BY HOLDER OUTSIDE OF RU IN DEC06";
label variable PRIJA06 "COVERED BY PRIVATE INS IN JAN06";
label variable PRIFE06 "COVERED BY PRIVATE INS IN FEB06";
label variable PRIMA06 "COVERED BY PRIVATE INS IN MAR06";
label variable PRIAP06 "COVERED BY PRIVATE INS IN APR06";
label variable PRIMY06 "COVERED BY PRIVATE INS IN MAY06";
label variable PRIJU06 "COVERED BY PRIVATE INS IN JUN06";
label variable PRIJL06 "COVERED BY PRIVATE INS IN JUL06";
label variable PRIAU06 "COVERED BY PRIVATE INS IN AUG06";
label variable PRISE06 "COVERED BY PRIVATE INS IN SEP06";
label variable PRIOC06 "COVERED BY PRIVATE INS IN OCT06";
label variable PRINO06 "COVERED BY PRIVATE INS IN NOV06";
label variable PRIDE06 "COVERED BY PRIVATE INS IN DEC06";
label variable HPEJA06 "HOLDER OF EMPL UNION INS IN JAN06";
label variable HPEFE06 "HOLDER OF EMPL UNION INS IN FEB06";
label variable HPEMA06 "HOLDER OF EMPL UNION INS IN MAR06";
label variable HPEAP06 "HOLDER OF EMPL UNION INS IN APR06";
label variable HPEMY06 "HOLDER OF EMPL UNION INS IN MAY06";
label variable HPEJU06 "HOLDER OF EMPL UNION INS IN JUN06";
label variable HPEJL06 "HOLDER OF EMPL UNION INS IN JUL06";
label variable HPEAU06 "HOLDER OF EMPL UNION INS IN AUG06";
label variable HPESE06 "HOLDER OF EMPL UNION INS IN SEP06";
label variable HPEOC06 "HOLDER OF EMPL UNION INS IN OCT06";
label variable HPENO06 "HOLDER OF EMPL UNION INS IN NOV06";
label variable HPEDE06 "HOLDER OF EMPL UNION INS IN DEC06";
label variable HPDJA06 "HOLDER OF PRIV INS (SOURCE UNKNWN) JAN06";
label variable HPDFE06 "HOLDER OF PRIV INS (SOURCE UNKNWN) FEB06";
label variable HPDMA06 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAR06";
label variable HPDAP06 "HOLDER OF PRIV INS (SOURCE UNKNWN) APR06";
label variable HPDMY06 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAY06";
label variable HPDJU06 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUN06";
label variable HPDJL06 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUL06";
label variable HPDAU06 "HOLDER OF PRIV INS (SOURCE UNKNWN) AUG06";
label variable HPDSE06 "HOLDER OF PRIV INS (SOURCE UNKNWN) SEP06";
label variable HPDOC06 "HOLDER OF PRIV INS (SOURCE UNKNWN) OCT06";
label variable HPDNO06 "HOLDER OF PRIV INS (SOURCE UNKNWN) NOV06";
label variable HPDDE06 "HOLDER OF PRIV INS (SOURCE UNKNWN) DEC06";
label variable HPNJA06 "HOLDER OF NONGROUP INS IN JAN06";
label variable HPNFE06 "HOLDER OF NONGROUP INS IN FEB06";
label variable HPNMA06 "HOLDER OF NONGROUP INS IN MAR06";
label variable HPNAP06 "HOLDER OF NONGROUP INS IN APR06";
label variable HPNMY06 "HOLDER OF NONGROUP INS IN MAY06";
label variable HPNJU06 "HOLDER OF NONGROUP INS IN JUN06";
label variable HPNJL06 "HOLDER OF NONGROUP INS IN JUL06";
label variable HPNAU06 "HOLDER OF NONGROUP INS IN AUG06";
label variable HPNSE06 "HOLDER OF NONGROUP INS IN SEP06";
label variable HPNOC06 "HOLDER OF NONGROUP INS IN OCT06";
label variable HPNNO06 "HOLDER OF NONGROUP INS IN NOV06";
label variable HPNDE06 "HOLDER OF NONGROUP INS IN DEC06";
label variable HPOJA06 "HOLDER OF OTHER GROUP INS IN JAN06";
label variable HPOFE06 "HOLDER OF OTHER GROUP INS IN FEB06";
label variable HPOMA06 "HOLDER OF OTHER GROUP INS IN MAR06";
label variable HPOAP06 "HOLDER OF OTHER GROUP INS IN APR06";
label variable HPOMY06 "HOLDER OF OTHER GROUP INS IN MAY06";
label variable HPOJU06 "HOLDER OF OTHER GROUP INS IN JUN06";
label variable HPOJL06 "HOLDER OF OTHER GROUP INS IN JUL06";
label variable HPOAU06 "HOLDER OF OTHER GROUP INS IN AUG06";
label variable HPOSE06 "HOLDER OF OTHER GROUP INS IN SEP06";
label variable HPOOC06 "HOLDER OF OTHER GROUP INS IN OCT06";
label variable HPONO06 "HOLDER OF OTHER GROUP INS IN NOV06";
label variable HPODE06 "HOLDER OF OTHER GROUP INS IN DEC06";
label variable HPSJA06 "HOLDER OF SELF-EMP-1 INS IN JAN06";
label variable HPSFE06 "HOLDER OF SELF-EMP-1 INS IN FEB06";
label variable HPSMA06 "HOLDER OF SELF-EMP-1 INS IN MAR06";
label variable HPSAP06 "HOLDER OF SELF-EMP-1 INS IN APR06";
label variable HPSMY06 "HOLDER OF SELF-EMP-1 INS IN MAY06";
label variable HPSJU06 "HOLDER OF SELF-EMP-1 INS IN JUN06";
label variable HPSJL06 "HOLDER OF SELF-EMP-1 INS IN JUL06";
label variable HPSAU06 "HOLDER OF SELF-EMP-1 INS IN AUG06";
label variable HPSSE06 "HOLDER OF SELF-EMP-1 INS IN SEP06";
label variable HPSOC06 "HOLDER OF SELF-EMP-1 INS IN OCT06";
label variable HPSNO06 "HOLDER OF SELF-EMP-1 INS IN NOV06";
label variable HPSDE06 "HOLDER OF SELF-EMP-1 INS IN DEC06";
label variable HPRJA06 "HOLDER OF PRIVATE INSURANCE IN JAN06";
label variable HPRFE06 "HOLDER OF PRIVATE INSURANCE IN FEB06";
label variable HPRMA06 "HOLDER OF PRIVATE INSURANCE IN MAR06";
label variable HPRAP06 "HOLDER OF PRIVATE INSURANCE IN APR06";
label variable HPRMY06 "HOLDER OF PRIVATE INSURANCE IN MAY06";
label variable HPRJU06 "HOLDER OF PRIVATE INSURANCE IN JUN06";
label variable HPRJL06 "HOLDER OF PRIVATE INSURANCE IN JUL06";
label variable HPRAU06 "HOLDER OF PRIVATE INSURANCE IN AUG06";
label variable HPRSE06 "HOLDER OF PRIVATE INSURANCE IN SEP06";
label variable HPROC06 "HOLDER OF PRIVATE INSURANCE IN OCT06";
label variable HPRNO06 "HOLDER OF PRIVATE INSURANCE IN NOV06";
label variable HPRDE06 "HOLDER OF PRIVATE INSURANCE IN DEC06";
label variable INSJA06X "COVR BY HOSP/MED INS IN JAN06 (ED)";
label variable INSFE06X "COVR BY HOSP/MED INS IN FEB06 (ED)";
label variable INSMA06X "COVR BY HOSP/MED INS IN MAR06 (ED)";
label variable INSAP06X "COVR BY HOSP/MED INS IN APR06 (ED)";
label variable INSMY06X "COVR BY HOSP/MED INS IN MAY06 (ED)";
label variable INSJU06X "COVR BY HOSP/MED INS IN JUN06 (ED)";
label variable INSJL06X "COVR BY HOSP/MED INS IN JUL06 (ED)";
label variable INSAU06X "COVR BY HOSP/MED INS IN AUG06 (ED)";
label variable INSSE06X "COVR BY HOSP/MED INS IN SEP06 (ED)";
label variable INSOC06X "COVR BY HOSP/MED INS IN OCT06 (ED)";
label variable INSNO06X "COVR BY HOSP/MED INS IN NOV06 (ED)";
label variable INSDE06X "COVR BY HOSP/MED INS IN DEC06 (ED)";
label variable PRVEV06 "EVER HAVE PRIVATE INSURANCE DURING 06";
label variable TRIEV06 "EVER HAVE TRICARE/CHAMPVA DURING 06";
label variable MCREV06 "EVER HAVE MEDICARE DURING 06 (ED)";
label variable MCDEV06 "EVER HAVE MEDICAID/SCHIP DURING 06 (ED)";
label variable OPAEV06 "EVER HAVE OTHER PUBLIC A INS DURING 06";
label variable OPBEV06 "EVER HAVE OTHER PUBLIC B INS DURING 06";
label variable UNINS06 "UNINSURED ALL OF 06";
label variable INSCOV06 "HEALTH INSURANCE COVERAGE INDICATOR 06";
label variable TRIST31X "COVERED BY TRICARE STANDARD - R3/1";
label variable TRIST42X "COVERED BY TRICARE STANDARD - R4/2";
label variable TRIST06X "COVERED BY TRICARE STANDARD - 12/31/06";
label variable TRIPR31X "COVERED BY TRICARE PRIME - R3/1";
label variable TRIPR42X "COVERED BY TRICARE PRIME - R4/2";
label variable TRIPR06X "COVERED BY TRICARE PRIME - 12/31/06";
label variable TRIEX31X "COVERED BY TRICARE EXTRA - R3/1";
label variable TRIEX42X "COVERED BY TRICARE EXTRA - R4/2";
label variable TRIEX06X "COVERED BY TRICARE EXTRA - 12/31/06";
label variable TRILI31X "COVERED BY TRICARE FOR LIFE - R3/1";
label variable TRILI42X "COVERED BY TRICARE FOR LIFE - R4/2";
label variable TRILI06X "COVERED BY TRICARE FOR LIFE - 12/31/06";
label variable TRICH31X "COVERED BY TRICARE CHAMPVA - R3/1";
label variable TRICH42X "COVERED BY TRICARE CHAMPVA - R4/2";
label variable TRICH06X "COVERED BY TRICARE CHAMPVA - 12/31/06";
label variable MCRPD31 "COV BY MEDICARE PMED BENEFIT - R3/1";
label variable MCRPD42 "COV BY MEDICARE PMED BENEFIT - R4/2";
label variable MCRPD06 "COV BY MEDICARE PMED BENEFIT - 12/31/06";
label variable MCRPD31X "COV BY MEDICARE PMED BENEFIT - R3/1 (ED)";
label variable MCRPD42X "COV BY MEDICARE PMED BENEFIT - R4/2 (ED)";
label variable MCRPD06X "COV BY MCARE PMED BENEFIT-12/31/06 (ED)";
label variable MCRPHO31 "COV BY MEDICARE MANAGED CARE - R3/1";
label variable MCRPHO42 "COV BY MEDICARE MANAGED CARE - R4/2";
label variable MCRPHO06 "COV BY MEDICARE MANAGED CARE - 12/31/06";
label variable MCDHMO31 "COVERED BY MEDICAID OR SCHIP HMO - R3/1";
label variable MCDHMO42 "COVERED BY MEDICAID OR SCHIP HMO - R4/2";
label variable MCDHMO06 "COVRED BY MEDICAID OR SCHIP HMO-12/31/06";
label variable MCDMC31 "COV BY MCAID/SCHIP GATEKEEPER PLAN-R3/1";
label variable MCDMC42 "COV BY MCAID/SCHIP GATEKEEPER PLAN-R4/2";
label variable MCDMC06 "COV BY MCAID/SCHIP GTKEEPR PLAN-12/31/06";
label variable PRVHMO31 "COVERED BY PRIVATE HMO - R3/1";
label variable PRVHMO42 "COVERED BY PRIVATE HMO - R4/2";
label variable PRVHMO06 "COVERED BY PRIVATE HMO - 12/31/06";
label variable PRVMNC31 "COVERED BY PRIVATE GATEKEEPER PLAN-R3/1";
label variable PRVMNC42 "COVERED BY PRIVATE GATEKEEPER PLAN-R4/2";
label variable PRVMNC06 "COVERED BY PRIV GATEKEEPER PLAN-12/31/06";
label variable PRVDRL31 "COV BY PRIV PLAN W/DOCTOR LIST - R3/1";
label variable PRVDRL42 "COV BY PRIV PLAN W/DOCTOR LIST - R4/2";
label variable PRVDRL06 "COV BY PRIV PLAN W/DOCTOR LIST-12/31/06";
label variable PHMONP31 "COV BY HMO-PAYS NON-PLAN DR VISITS-R3/1";
label variable PHMONP42 "COV BY HMO-PAYS NON-PLAN DR VISITS-R4/2";
label variable PHMONP06 "COV BY HMO-PAYS NON-PLAN DRS - 12/31/06";
label variable PMNCNP31 "COV BY GATEKPR-PAYS NON-PLAN DRS-R3/1";
label variable PMNCNP42 "COV BY GATEKPR-PAYS NON-PLAN DRS-R4/2";
label variable PMNCNP06 "COV BY GATEKP-PAYS NON-PLAN DRS-12/31/06";
label variable PRDRNP31 "COV BY DR LIST-PAYS NON-PLAN DRS-R3/1";
label variable PRDRNP42 "COV BY DR LIST-PAYS NON-PLAN DRS-R4/2";
label variable PRDRNP06 "COV BY DR LIST-PAYS NON-PLAN DR-12/31/06";
label variable PREVCOVR "PER COV BY INS IN PREV 2 YRS-PNL 11 ONLY";
label variable COVRMM "MONTH MOST RECENTLY COVERED-PNL 11 ONLY";
label variable COVRYY "YEAR MOST RECENTLY COVERED-PANEL 11 ONLY";
label variable WASESTB "WAS PREV INS BY EMPL OR UNION-PN 11 ONLY";
label variable WASMCARE "WAS PREV INS BY MEDICARE-PANEL 11 ONLY";
label variable WASMCAID "WAS PREV INS BY MCAID/SCHIP-PNL 11 ONLY";
label variable WASCHAMP "WAS PREV INS TRICARE/CHAMPVA-PNL 11 ONLY";
label variable WASVA "WAS PREV INS VA/MILITAR CARE-PNL 11 ONLY";
label variable WASPRIV "WAS PREV INS GRP/ASSOC/INS CO-PN 11 ONLY";
label variable WASOTGOV "WAS PREV INS BY OTH GOV PRG-PNL 11 ONLY";
label variable WASAFDC "WAS PREV INS BY PUBLIC AFDC-PNL 11 ONLY";
label variable WASSSI "WAS PREV INS BY SSI PROGRAM-PNL 11 ONLY";
label variable WASSTAT1 "WAS PREV INS BY STAT PROG 1-PNL 11 ONLY";
label variable WASSTAT2 "WAS PREV INS BY STAT PROG 2-PNL 11 ONLY";
label variable WASSTAT3 "WAS PREV INS BY STAT PROG 3-PNL 11 ONLY";
label variable WASSTAT4 "WAS PREV INS BY STAT PROG 4-PNL 11 ONLY";
label variable WASOTHER "WAS PREV INS BY OTH SOURCE-PANEL 11 ONLY";
label variable NOINSBEF "EVR WOUT HLTH INSR PREV YR-PANEL 11 ONLY";
label variable NOINSTM "# WKS/MON WOUT HLTH INS PRV YR-PN 11 ONL";
label variable NOINUNIT "UNIT OF TIME WOUT HLTH INS-PANEL 11 ONLY";
label variable MORECOVR "COV BY MOR COMPR PL PREV 2 YR-PN 11 ONLY";
label variable INSENDMM "MONTH MOST RECENTLY COVD-PANEL 11 ONLY";
label variable INSENDYY "YEAR MOST RECENTLY COVD-PANEL 11 ONLY";
label variable TRICR31X "COV BY TRICR/CHAMV - R3/1 INT DT (ED)";
label variable TRICR42X "COV BY TRICR/CHAMV - R4/2 INT DT (ED)";
label variable TRICR53X "COV BY TRICR/CHAMV 12-31/R3 INT DT (ED)";
label variable TRICR06X "COV BY TRICR/CHAMV - 12/31/06 (ED)";
label variable TRIAT31X "ANY TIME COV TRICARE/CHAMPVA - R3/1";
label variable TRIAT42X "ANY TIME COV TRICARE/CHAMPVA - R4/2";
label variable TRIAT53X "ANY TIME COV TRICARE/CHAMPVA - R5/3";
label variable TRIAT06X "ANY TIME COV TRICARE/CHAMPVA - 12/31/06";
label variable MCAID31 "COV BY MEDICAID OR SCHIP - R3/1 INT DT";
label variable MCAID42 "COV BY MEDICAID OR SCHIP - R4/2 INT DT";
label variable MCAID53 "COV BY MEDICAID OR SCHIP 12-31/R3 INT DT";
label variable MCAID06 "COV BY MEDICAID OR SCHIP - 12/31/06";
label variable MCAID31X "COV BY MEDICAID/SCHIP - R3/1 INT DT (ED)";
label variable MCAID42X "COV BY MEDICAID/SCHIP - R4/2 INT DT (ED)";
label variable MCAID53X "COV MEDICAID/SCHIP 12-31/R3 INT DT(ED)";
label variable MCAID06X "COV BY MEDICAID OR SCHIP - 12/31/06 (ED)";
label variable MCARE31 "COV BY MEDICARE - R3/1 INT DT";
label variable MCARE42 "COV BY MEDICARE - R4/2 INT DT";
label variable MCARE53 "COV BY MEDICARE 12-31/R3 INT DT";
label variable MCARE06 "COV BY MEDICARE - 12/31/06";
label variable MCARE31X "COV BY MEDICARE - R3/1 INT DT (ED)";
label variable MCARE42X "COV BY MEDICARE - R4/2 INT DT (ED)";
label variable MCARE53X "COV BY MEDICARE 12-31/R3 INT DT (ED)";
label variable MCARE06X "COV BY MEDICARE - 12/31/06 (ED)";
label variable MCDAT31X "ANY TIME COV MEDICAID OR SCHIP - R3/1";
label variable MCDAT42X "ANY TIME COV MEDICAID OR SCHIP - R4/2";
label variable MCDAT53X "ANY TIME COV MEDICAID OR SCHIP - R5/3";
label variable MCDAT06X "ANY TIME COV MEDICAID OR SCHIP-12/31/06";
label variable OTPAAT31 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R3/1";
label variable OTPAAT42 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R4/2";
label variable OTPAAT53 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R5/3";
label variable OTPAAT06 "ANY COV OT GOV MCAID/SCHIP HMO-12/31/06";
label variable OTPBAT31 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R3/1";
label variable OTPBAT42 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R4/2";
label variable OTPBAT53 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R5/3";
label variable OTPBAT06 "ANY CV OT GV NT MCAID/SCHIP HMO-12/31/06";
label variable OTPUBA31 "COV/PAY OTH GOV MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBA42 "COV/PAY OTH GOV MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBA53 "COV/PAY OTH GOV MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBA06 "COV/PAY OTH GOV MCAID/SCHIP HMO-12/31/06";
label variable OTPUBB31 "COV OTH GOV NOT MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBB42 "COV OTH GOV NOT MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBB53 "COV OTH GOV NOT MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBB06 "COV OTH GOV NOT MCAID/SCHIP HMO-12/31/06";
label variable PRIDK31 "COV BY PRIV INS (DK PLAN) - R3/1 INT";
label variable PRIDK42 "COV BY PRIV INS (DK PLAN) - R4/2 INT";
label variable PRIDK53 "COV BY PRIV INS (DK PLAN) 12-31/R3 INT";
label variable PRIDK06 "COV BY PRIV INS (DK PLAN) - 12/31/06";
label variable PRIEU31 "COV BY EMPL/UNION GRP INS - R3/1 INT DT";
label variable PRIEU42 "COV BY EMPL/UNION GRP INS - R4/2 INT DT";
label variable PRIEU53 "COV BY EMPL/UNION GRP INS 12-31/R3 INT";
label variable PRIEU06 "COV BY EMPL/UNION GRP INS - 12/31/06";
label variable PRING31 "COV BY NON-GROUP INS - R3/1 INT DT";
label variable PRING42 "COV BY NON-GROUP INS - R4/2 INT DT";
label variable PRING53 "COV BY NON-GROUP INS 12-31/R3 INT DT";
label variable PRING06 "COV BY NON-GROUP INS - 12/31/06";
label variable PRIOG31 "COV BY OTHER GROUP INS - R3/1 INT DT";
label variable PRIOG42 "COV BY OTHER GROUP INS - R4/2 INT DT";
label variable PRIOG53 "COV BY OTHER GROUP INS 12-31/R3 INT DT";
label variable PRIOG06 "COV BY OTHER GROUP INS - 12/31/06";
label variable PRIS31 "COV BY SELF-EMP-1 INS - R3/1 INT DT";
label variable PRIS42 "COV BY SELF-EMP-1 INS - R4/2 INT DT";
label variable PRIS53 "COV BY SELF-EMP-1 INS 12-31/R3 INT DT";
label variable PRIS06 "COV BY SELF-EMP-1 INS - 12/31/06";
label variable PRIV31 "COV BY PRIV HLTH INS - R3/1 INT DATE";
label variable PRIV42 "COV BY PRIV HLTH INS - R4/2 INT DATE";
label variable PRIV53 "COV BY PRIV HLTH INS 12-31/R3 INT DATE";
label variable PRIV06 "COV BY PRIV HLTH INS - 12/31/06";
label variable PRIVAT31 "ANY TIME COV PRIVATE INS - R3/1";
label variable PRIVAT42 "ANY TIME COV PRIVATE INS - R4/2";
label variable PRIVAT53 "ANY TIME COV PRIVATE INS - R5/3";
label variable PRIVAT06 "ANY TIME COV PRIVATE INS - 12/31/06";
label variable PROUT31 "COV BY SOMEONE OUT OF RU - R3/1 INT";
label variable PROUT42 "COV BY SOMEONE OUT OF RU - R4/2 INT";
label variable PROUT53 "COV BY SOMEONE OUT OF RU 12-31/R3 INT DT";
label variable PROUT06 "COV BY SOMEONE OUT OF RU - 12/31/06";
label variable PUB31X "COV BY PUBLIC INS - R3/1 INT DT (ED)";
label variable PUB42X "COV BY PUBLIC INS - R4/2 INT DT (ED)";
label variable PUB53X "COV BY PUBLIC INS 12-31/R3 INT DT (ED)";
label variable PUB06X "COV BY PUBLIC INS - 12/31/06 (ED)";
label variable PUBAT31X "ANY TIME COV BY PUBLIC - R3/1";
label variable PUBAT42X "ANY TIME COV BY PUBLIC - R4/2";
label variable PUBAT53X "ANY TIME COV BY PUBLIC - R5/3";
label variable PUBAT06X "ANY TIME COV BY PUBLIC - 12/31/06";
label variable INS31X "INSURED - R3/1 INT DATE (ED)";
label variable INS42X "INSURED - R4/2 INT DATE (ED)";
label variable INS53X "INSURED 12-31/R3 INT DATE (ED)";
label variable INS06X "INSURED - 12/31/06 (ED)";
label variable INSAT31X "INSURED ANY TIME IN R3/1";
label variable INSAT42X "INSURED ANY TIME IN R4/2";
label variable INSAT53X "INSURED ANY TIME IN R5/3";
label variable INSAT06X "INSURED ANY TIME IN R5/R3 UNTIL 12/31/06";
label variable STAPR31 "COV BY STATE-SPEC PROG - R3/1 INT DT";
label variable STAPR42 "COV BY STATE-SPEC PROG - R4/2 INT DT";
label variable STAPR53 "COV BY STATE-SPEC PROG 12-31/R3 INT DT";
label variable STAPR06 "COV BY STATE-SPEC PROG - 12/31/06";
label variable STPRAT31 "ANY TIME COVERAGE BY STATE INS - R3/1";
label variable STPRAT42 "ANY TIME COVERAGE BY STATE INS - R4/2";
label variable STPRAT53 "ANY TIME COVERAGE BY STATE INS - R5/3";
label variable STPRAT06 "ANY TIME COV BY STATE INS - 12/31/06";
label variable EVRUNINS "EVER UNINSURED IN 06 USING PRIV/PUBX";
label variable EVRUNAT "EVER UNINSURED IN 06 USING PRIVAT/PUBATX";
label variable DENTIN31 "DENTAL INSURANCE - RD 3/1";
label variable DENTIN42 "DENTAL INSURANCE - RD 4/2";
label variable DENTIN53 "DENTAL INSURANCE - RD 5/3";
label variable DNTINS31 "DENTAL INS - RD 3/1 IN 06";
label variable DNTINS06 "DENTAL INS - R5/R3 UNTIL 12/31/06";
label variable PMEDIN31 "PRESCRIPTION DRUG INSURANCE - RD 3/1";
label variable PMEDIN42 "PRESCRIPTION DRUG INSURANCE - RD 4/2";
label variable PMEDIN53 "PRESCRIPTION DRUG INSURANCE - RD 5/3";
label variable PMDINS31 "PMED INS - RD 3/1 IN 06";
label variable PMDINS06 "PMED INS - R5/R3 UNTIL 12/31/06";
label variable PMEDUP31 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R3/1";
label variable PMEDUP42 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R4/2";
label variable PMEDUP53 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R5/3";
label variable PMEDPY31 "USUAL 3RD PARTY PAYER FOR PMEDS - R3/1";
label variable PMEDPY42 "USUAL 3RD PARTY PAYER FOR PMEDS - R4/2";
label variable PMEDPY53 "USUAL 3RD PARTY PAYER FOR PMEDS - R5/3";
label variable PMEDOP31 "OUT-OF-POCKET PAYMENT FOR LAST PMED-R3/1";
label variable PMEDOP42 "OUT-OF-POCKET PAYMENT FOR LAST PMED-R4/2";
label variable PMEDOP53 "OUT-OF-POCKET PAYMENT FOR LAST PMED-R5/3";
label variable GDCPBM42 "MCAID/SCHIP/O PUB: PRB GET PERS DOC-R4/2";
label variable APRTRM42 "MCAID/SCHIP/O PUB: NEED APPRV 4 TRT-R4/2";
label variable APRDLM42 "MCAID/SCHIP/O PUB: DLY WAIT 4 APPRV-R4/2";
label variable LKINFM42 "MCAID/SCHIP/O PUB: LOOK 4 PLAN INFO-R4/2";
label variable PBINFM42 "MCAID/SCHIP/O PUB: PROB FINDNG INFO-R4/2";
label variable CSTSVM42 "MCAID/SCHIP/O PUB: CALL CUSTMR SERV-R4/2";
label variable PBSVCM42 "MCAID/SCHIP/O PUB: PRB W CUSRVC HLP-R4/2";
label variable PPRWKM42 "MCAID/SCHIP/O PUB: COMP PLAN PPRWRK-R4/2";
label variable PBPWKM42 "MCAID/SCHIP/O PUB: PRB W PLN PPRWRK-R4/2";
label variable RTPLNM42 "MCAID/SCHIP/O PUB: RATE EXP W PLAN-R4/2";
label variable GDCPBT42 "TRICR/CHAMV: PROB GETTING PERS DOC-R4/2";
label variable APRTRT42 "TRICR/CHAMV: NEED APPRVL 4 TREATMNT-R4/2";
label variable APRDLT42 "TRICR/CHAMV: DELAY WAITING 4 APPRVL-R4/2";
label variable LKINFT42 "TRICR/CHAMV: INFO ON HOW PLAN WORKS-R4/2";
label variable PBINFT42 "TRICR/CHAMV: PROBLEM FINDING INFO-R4/2";
label variable CSTSVT42 "TRICR/CHAMV: CALL CUSTOMER SERVICE-R4/2";
label variable PBSVCT42 "TRICR/CHAMV: PROB GET HELP FR CSRVC-R4/2";
label variable PPRWKT42 "TRICR/CHAMV:FILL OUT PAPERWRK 4 PLN-R4/2";
label variable PBPWKT42 "TRICR/CHAMV: PROB W PLAN PAPERWORK-R4/2";
label variable RTPLNT42 "TRICR/CHAMV: RATE EXPERIENCE W PLAN-R4/2";
label variable TOTTCH06 "TOTAL HEALTH CARE CHARGES 06, EXCL RX";
label variable TOTEXP06 "TOTAL HEALTH CARE EXP 06";
label variable TOTSLF06 "TOTAL AMT PAID BY SELF/FAMILY 06";
label variable TOTMCR06 "TOTAL AMT PAID BY MEDICARE 06";
label variable TOTMCD06 "TOTAL AMT PAID BY MEDICAID 06";
label variable TOTPRV06 "TOTAL AMT PAID BY PRIVATE INS 06";
label variable TOTVA06 "TOTAL AMT PAID BY VA 06";
label variable TOTTRI06 "TOTAL AMT PAID BY TRICARE 06";
label variable TOTOFD06 "TOTAL AMT PAID BY OTHER FEDERAL 06";
label variable TOTSTL06 "TOTAL AMT PAID BY OTH ST/LOCAL 06";
label variable TOTWCP06 "TOTAL AMT PAID BY WORKERS COMP 06";
label variable TOTOPR06 "TOTAL AMT PAID BY OTHER PRIVATE 06";
label variable TOTOPU06 "TOTAL AMT PAID BY OTHER PUBLIC 06";
label variable TOTOSR06 "TOTAL AMT PAID BY OTHER SOURCES 06";
label variable OBTOTV06 "# OFFICE-BASED PROVIDER VISITS 06";
label variable OBVTCH06 "OFFICE-BASED PROVIDER VISIT CHARGES 06";
label variable OBVEXP06 "TOTAL OFFICE-BASED EXP 06";
label variable OBVSLF06 "ALL OFFICE VISITS -SELF/FAMILY AMT 06";
label variable OBVMCR06 "ALL OFFICE VISITS -MEDICARE AMT 06";
label variable OBVMCD06 "ALL OFFICE VISITS -MEDICAID AMT 06";
label variable OBVPRV06 "ALL OFFICE VISITS -PRIVATE INS AMT 06";
label variable OBVVA06 "ALL OFFICE VISITS-VA AMT 06";
label variable OBVTRI06 "ALL OFFICE VISITS-TRICARE AMT 06";
label variable OBVOFD06 "ALL OFFICE VISITS-OTHER FEDERAL AMT 06";
label variable OBVSTL06 "ALL OFFICE VISITS-OTH ST/LOCAL AMT 06";
label variable OBVWCP06 "ALL OFFICE VISITS -WORKERS COMP AMT 06";
label variable OBVOPR06 "ALL OFFICE VISITS - OTH PRIVATE AMT 06";
label variable OBVOPU06 "ALL OFFICE VISITS - OTH PUBLIC AMT 06";
label variable OBVOSR06 "ALL OFF VSTS - OTH UNCLASS SRCE AMT 06";
label variable OBDRV06 "# OFFICE-BASED PHYSICIAN VISITS 06";
label variable OBDTCH06 "OFFICE-BASED PHYSICIAN VISIT CHARGES 06";
label variable OBDEXP06 "TOTAL OFF-BASED DR EXP 06";
label variable OBDSLF06 "DR OFFICE VISITS -SELF/FAMILY AMT 06";
label variable OBDMCR06 "DR OFFICE VISITS -MEDICARE AMT 06";
label variable OBDMCD06 "DR OFFICE VISITS -MEDICAID AMT 06";
label variable OBDPRV06 "DR OFFICE VISITS -PRIVATE INS AMT 06";
label variable OBDVA06 "DR OFFICE VISITS -VA AMT 06";
label variable OBDTRI06 "DR OFFICE VISITS -TRICARE AMT 06";
label variable OBDOFD06 "DR OFFICE VISITS -OTHER FEDERAL AMT 06";
label variable OBDSTL06 "DR OFFICE VISITS -OTH ST/LOCAL AMT 06";
label variable OBDWCP06 "DR OFFICE VISITS -WORKERS COMP AMT 06";
label variable OBDOPR06 "DR OFFICE VISITS - OTH PRIVATE AMT 06";
label variable OBDOPU06 "DR OFFICE VISITS - OTH PUBLIC AMT 06";
label variable OBDOSR06 "DR OFF VSTS - OTH UNCLASS SRCE AMT 06";
label variable OBOTHV06 "# OFFICE-BASED NON-PHYSICAN VISITS 06";
label variable OBOTCH06 "OFFICE-BASED NON-DR VISIT CHARGES 06";
label variable OBOEXP06 "TOTAL OFF-BASED NON-DR EXP 06";
label variable OBOSLF06 "NON-DR OFF VISTS -SELF/FAMILY AMT 06";
label variable OBOMCR06 "NON-DR OFF VISTS -MEDICARE AMT 06";
label variable OBOMCD06 "NON-DR OFF VISTS -MEDICAID AMT 06";
label variable OBOPRV06 "NON-DR OFF VISTS -PRIVATE INS AMT 06";
label variable OBOVA06 "NON-DR OFF VISTS -VA AMT 06";
label variable OBOTRI06 "NON-DR OFF VISTS -TRICARE AMT 06";
label variable OBOOFD06 "NON-DR OFF VISTS -OTHER FEDERAL AMT 06";
label variable OBOSTL06 "NON-DR OFF VISTS -OTH ST/LOCAL AMT 06";
label variable OBOWCP06 "NON-DR OFF VISTS -WORKERS COMP AMT 06";
label variable OBOOPR06 "NON-DR OFF VISTS - OTH PRIVATE AMT 06";
label variable OBOOPU06 "NON-DR OFF VISTS - OTH PUBLIC AMT 06";
label variable OBOOSR06 "NON-DR OF VSTS - OTH UNCLASS SRCE AMT 06";
label variable OBCHIR06 "# OFFICE-BASED CHIROPRACTOR VISITS 06";
label variable OBCTCH06 "OFFICE-BASED CHIRO VISIT CHARGES 06";
label variable OBCEXP06 "TOTAL OFF-BASED CHIRO EXP 06";
label variable OBCSLF06 "CHIRO OFF VISITS -SELF/FAMILY AMT 06";
label variable OBCMCR06 "CHIRO OFF VISITS -MEDICARE AMT 06";
label variable OBCMCD06 "CHIRO OFF VISITS -MEDICAID AMT 06";
label variable OBCPRV06 "CHIRO OFF VISITS -PRIVATE INS AMT 06";
label variable OBCVA06 "CHIRO OFF VISITS -VA AMT 06";
label variable OBCTRI06 "CHIRO OFF VISITS -TRICARE AMT 06";
label variable OBCOFD06 "CHIRO OFF VISITS -OTHER FEDERAL AMT 06";
label variable OBCSTL06 "CHIRO OFF VISITS -OTH ST/LOCAL AMT 06";
label variable OBCWCP06 "CHIRO OFF VISITS -WORKERS COMP AMT 06";
label variable OBCOPR06 "CHIRO OFF VISTS - OTHR PRIVATE AMT 06";
label variable OBCOPU06 "CHIRO OFF VISTS - OTHR PUBLIC AMT 06";
label variable OBCOSR06 "CHIRO OF VSTS - OTHR UNCLASS SRCE AMT 06";
label variable OBNURS06 "# OFF-BASED NURSE/PRACTITIONER VISITS 06";
label variable OBNTCH06 "OFFICE-BASED NURSE/PRAC VISIT CHARGES 06";
label variable OBNEXP06 "TOTAL OFF-BASED NURSE/PRAC 06";
label variable OBNSLF06 "NURSE/PRAC OFF VISITS-SELF/FAMILY AMT 06";
label variable OBNMCR06 "NURSE/PRAC OFF VISITS -MEDICARE AMT 06";
label variable OBNMCD06 "NURSE/PRAC OFF VSTS -MEDICAID AMT 06";
label variable OBNPRV06 "NURSE/PRAC OFF VSTS -PRIVATE INS AMT 06";
label variable OBNVA06 "NURSE/PRAC OFF VSTS -VA AMT 06";
label variable OBNTRI06 "NURSE/PRAC OFF VSTS -TRICARE AMT 06";
label variable OBNOFD06 "NURSE/PRAC OFF VSTS-OTHER FEDERAL AMT 06";
label variable OBNSTL06 "NURSE/PRAC OFF VSTS -OTH ST/LOCAL AMT 06";
label variable OBNWCP06 "NURSE/PRAC OFF VSTS -WORKERS COMP AMT 06";
label variable OBNOPR06 "NURSE/PRAC OFF VSTS - OTH PRIVATE AMT 06";
label variable OBNOPU06 "NURSE/PRAC OFF VSTS - OTH PUBLIC AMT 06";
label variable OBNOSR06 "NRS/PR OF VSTS - OTH UNCLASS SRCE AMT 06";
label variable OBOPTO06 "# OFF-BASED OPTOMETRIST VISITS 06";
label variable OBETCH06 "OFFICE-BASED OPTOMTRIST VISIT CHARGES 06";
label variable OBEEXP06 "TOTAL OFF-BASED OPOTMETRIST EXP 06";
label variable OBESLF06 "OPTOMETRIST OFF VSTS -SELF/FAMILY AMT 06";
label variable OBEMCR06 "OPTOMETRIST OFF VSTS -MEDICARE AMT 06";
label variable OBEMCD06 "OPTOMETRIST OFF VSTS -MEDICAID AMT 06";
label variable OBEPRV06 "OPTOMETRIST OFF VSTS -PRIVATE INS AMT 06";
label variable OBEVA06 "OPTOMETRIST OFF VSTS -VA AMT 06";
label variable OBETRI06 "OPTOMETRIST OFF VSTS -TRICARE AMT 06";
label variable OBEOFD06 "OPTOMETRIST OFF VSTS-OTH FEDERAL AMT 06";
label variable OBESTL06 "OPTOMETRIST OFF VSTS -OTH ST/LOCL AMT 06";
label variable OBEWCP06 "OPTOMETRIST OFF VSTS-WORKERS COMP AMT 06";
label variable OBEOPR06 "OPTOMETRIST OFF VSTS -OTH PRIVATE AMT 06";
label variable OBEOPU06 "OPTOMETRIST OFF VSTS -OTH PUBLIC AMT 06";
label variable OBEOSR06 "OPTOM OF VSTS - OTH UNCLASS SRCE AMT 06";
label variable OBASST06 "# OFF-BASED PHYSICIAN ASSIST VISITS 06";
label variable OBATCH06 "OFFICE-BASED PHYS ASST VISIT CHARGES 06";
label variable OBAEXP06 "TOTAL OFF-BASED PHYS ASS T EXP 06";
label variable OBASLF06 "PHYS ASS T OFF VSTS -SELF/FAMILY AMT 06";
label variable OBAMCR06 "PHYS ASS T OFF VSTS -MEDICARE AMT 06";
label variable OBAMCD06 "PHYS ASS T OFF VSTS -MEDICAID AMT 06";
label variable OBAPRV06 "PHYS ASS T OFF VSTS -PRIVATE INS AMT 06";
label variable OBAVA06 "PHYS ASS T OFF VSTS -VA AMT 06";
label variable OBATRI06 "PHYS ASS T OFF VSTS -TRICARE AMT 06";
label variable OBAOFD06 "PHYS ASS T OFF VSTS -OTHER FED AMT 06";
label variable OBASTL06 "PHYS ASS T OFF VSTS -OTH ST/LOCL AMT 06";
label variable OBAWCP06 "PHYS ASS T OFF VSTS-WORKERS COMP AMT 06";
label variable OBAOPR06 "PHYS ASS T OFF VSTS - OTH PRIVATE AMT 06";
label variable OBAOPU06 "PHYS ASS T OFF VSTS - OTH PUBLIC AMT 06";
label variable OBAOSR06 "P A OFF VSTS - OTH UNCLASS SRCE AMT 06";
label variable OBTHER06 "# OFF-BASED PT/OT VISITS 06";
label variable OBTTCH06 "OFFICE-BASED PT/OC VISIT CHARGES 06";
label variable OBTEXP06 "TOT OFF-BASED PT EXP 06";
label variable OBTSLF06 "PT/OT OFF VISITS -SELF/FAMILY AMT 06";
label variable OBTMCR06 "PT/OT OFF VISITS -MEDICARE AMT 06";
label variable OBTMCD06 "PT/OT OFF VISITS -MEDICAID AMT 06";
label variable OBTPRV06 "PT/OT OFF VISITS -PRIVATE INS AMT 06";
label variable OBTVA06 "PT/OT OFF VISITS -VA AMT 06";
label variable OBTTRI06 "PT/OT OFF VISITS -TRICARE AMT 06";
label variable OBTOFD06 "PT/OT OFF VISITS -OTHER FED AMT 06";
label variable OBTSTL06 "PT/OT OFF VISITS -OTH ST/LOCL AMT 06";
label variable OBTWCP06 "PT/OT OFF VISITS -WORKERS COMP AMT 06";
label variable OBTOPR06 "PT/OT OFF VISITS - OTH PRIVATE AMT 06";
label variable OBTOPU06 "PT/OT OFF VISITS - OTH PUBLIC AMT 06";
label variable OBTOSR06 "PT/OT OF VSTS-OTH UNCLASS SRCE AMT 06";
label variable OPTOTV06 "# OUTPATIENT DEPT PROVIDER VISITS 06";
label variable OPFTCH06 "OPD PROVIDER VISIT CHARGES - FAC 06";
label variable OPFEXP06 "TOTAL OUTPATIENT FACILITY EXP 06";
label variable OPFSLF06 "ALL OPD VISITS-SELF/FAMILY AMT-FAC 06";
label variable OPFMCR06 "ALL OPD VISITS-MEDICARE AMT-FAC 06";
label variable OPFMCD06 "ALL OPD VISITS-MEDICAID AMT-FAC 06";
label variable OPFPRV06 "ALL OPD VISITS-PRIV INS AMT-FAC 06";
label variable OPFVA06 "ALL OPD VISITS-VA AMT-FAC 06";
label variable OPFTRI06 "ALL OPD VISITS-TRICARE AMT-FAC 06";
label variable OPFOFD06 "ALL OPD VISITS-OTHER FED AMT-FAC 06";
label variable OPFSTL06 "ALL OPD VISITS-OTH ST/LOCAL AMT-FAC 06";
label variable OPFWCP06 "ALL OPD VISITS-WORKERS COMP AMT-FAC 06";
label variable OPFOPR06 "ALL OPD VISITS - OTH PRIVATE AMT-FAC 06";
label variable OPFOPU06 "ALL OPD VISITS - OTH PUBLIC AMT-FAC 06";
label variable OPFOSR06 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-FAC 06";
label variable OPDEXP06 "TOTAL OUTPATIENT PROVIDER EXP 06";
label variable OPDTCH06 "OPD PROVIDER VISIT CHARGES - DR 06";
label variable OPDSLF06 "ALL OPD VISITS-SELF/FAMILY AMT-DR 06";
label variable OPDMCR06 "ALL OPD VISITS-MEDICARE AMT -DR 06";
label variable OPDMCD06 "ALL OPD VISITS-MEDICAID AMT -DR 06";
label variable OPDPRV06 "ALL OPD VISITS-PRIV INS AMT-DR 06";
label variable OPDVA06 "ALL OPD VISITS-VA AMT-DR 06";
label variable OPDTRI06 "ALL OPD VISITS-TRICARE AMT-DR 06";
label variable OPDOFD06 "ALL OPD VISITS-OTHER FED AMT-DR 06";
label variable OPDSTL06 "ALL OPD VISITS-OTH ST/LOCAL AMT-DR 06";
label variable OPDWCP06 "ALL OPD VISITS-WORKERS COMP AMT-DR 06";
label variable OPDOPR06 "ALL OPD VISITS - OTH PRIVATE AMT-DR 06";
label variable OPDOPU06 "ALL OPD VISITS-OTH PUBLIC AMT-DR 06";
label variable OPDOSR06 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-DR 06";
label variable OPDRV06 "# OUTPATIENT DEPT PHYSICIAN VISITS 06";
label variable OPVTCH06 "OPD PHYSICIAN VISIT CHARGES - FAC 06";
label variable OPVEXP06 "TOTAL OUTPATIENT PHYSICIAN - FAC EXP 06";
label variable OPVSLF06 "OPD DR VISITS-SELF/FAMILY AMT-FAC 06";
label variable OPVMCR06 "OPD DR VISITS-MEDICARE AMT-FAC 06";
label variable OPVMCD06 "OPD DR VISITS-MEDICAID AMT-FAC 06";
label variable OPVPRV06 "OPD DR VISITS-PRIV INS AMT-FAC 06";
label variable OPVVA06 "OPD DR VISITS-VA AMT-FAC 06";
label variable OPVTRI06 "OPD DR VISITS-TRICARE AMT-FAC 06";
label variable OPVOFD06 "OPD DR VISITS-OTHER FED AMT-FAC 06";
label variable OPVSTL06 "OPD DR VISITS-OTH ST/LOCAL AMT-FAC 06";
label variable OPVWCP06 "OPD DR VISITS-WORKERS COMP AMT-FAC 06";
label variable OPVOPR06 "OPD DR VISITS - OTH PRIVATE AMT-FAC 06";
label variable OPVOPU06 "OPD DR VISITS-OTH PUBLIC AMT-FAC 06";
label variable OPVOSR06 "OPD DR VSTS-OTH UNCLASS SRCE AMT-FAC 06";
label variable OPSEXP06 "TOTAL OUTPATIENT PHYSICIAN - DR EXP 06";
label variable OPSTCH06 "OPD PHYSICIAN VISIT CHARGES - DR 06";
label variable OPSSLF06 "OPD DR VISITS-SELF/FAMILY AMT-DR 06";
label variable OPSMCR06 "OPD DR VISITS-MEDICARE AMT-DR 06";
label variable OPSMCD06 "OPD DR VISITS-MEDICAID AMT-DR 06";
label variable OPSPRV06 "OPD DR VISITS-PRIV INS AMT-DR 06";
label variable OPSVA06 "OPD DR VISITS-VA AMT-DR 06";
label variable OPSTRI06 "OPD DR VISITS-TRICARE AMT-DR 06";
label variable OPSOFD06 "OPD DR VISITS-OTHER FED AMT-DR 06";
label variable OPSSTL06 "OPD DR VISITS-OTH ST/LOCAL AMT-DR 06";
label variable OPSWCP06 "OPD DR VISITS-WORKERS COMP AMT-DR 06";
label variable OPSOPR06 "OPD DR VISITS - OTH PRIVATE AMT-DR 06";
label variable OPSOPU06 "OPD DR VISITS-OTH PUBLIC AMT-DR 06";
label variable OPSOSR06 "OPD DR VSTS-OTH UNCLASS SRCE AMT-DR 06";
label variable OPOTHV06 "# OUTPATIENT DEPT NON-DR VISITS 06";
label variable OPOTCH06 "OPD NON-PHYS VISIT CHARGES - FAC 06";
label variable OPOEXP06 "TOTAL OUTPATIENT NON-DR - FAC EXP 06";
label variable OPOSLF06 "OPD NON-DR VISITS-SELF/FAM AMT-FAC 06";
label variable OPOMCR06 "OPD NON-DR VISITS-MEDICARE AMT-FAC 06";
label variable OPOMCD06 "OPD NON-DR VISITS-MEDICAID AMT-FAC 06";
label variable OPOPRV06 "OPD NON-DR VISITS-PRIV INS AMT-FAC 06";
label variable OPOVA06 "OPD NON-DR VISITS-VA AMT-FAC 06";
label variable OPOTRI06 "OPD NON-DR VISITS-TRICARE AMT-FAC 06";
label variable OPOOFD06 "OPD NON-DR VISITS-OTHER FED AMT-FAC 06";
label variable OPOSTL06 "OPD NON-DR VISITS-OTH ST/LOC AMT-FAC 06";
label variable OPOWCP06 "OPD NON-DR VISITS-WRKRS COMP AMT-FAC 06";
label variable OPOOPR06 "OPD NON-DR VISITS-OTH PRIVATE AMT-FAC 06";
label variable OPOOPU06 "OPD NON-DR VISITS-OTH PUBLIC AMT-FAC 06";
label variable OPOOSR06 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-FAC 06";
label variable OPPEXP06 "TOTAL OUTPATIENT NON-DR - DR EXP 06";
label variable OPPTCH06 "OPD NON-PHYS VISIT CHARGES - DR 06";
label variable OPPSLF06 "OPD NON-DR VISITS-SELF/FAM AMT-DR 06";
label variable OPPMCR06 "OPD NON-DR VISITS-MEDICARE AMT-DR 06";
label variable OPPMCD06 "OPD NON-DR VISITS-MEDICAID AMT-DR 06";
label variable OPPPRV06 "OPD NON-DR VISITS-PRIV INS AMT-DR 06";
label variable OPPVA06 "OPD NON-DR VISITS-VA AMT-DR 06";
label variable OPPTRI06 "OPD NON-DR VISITS-TRICARE AMT-DR 06";
label variable OPPOFD06 "OPD NON-DR VISITS-OTHER FED AMT-DR 06";
label variable OPPSTL06 "OPD NON-DR VISITS-OTH ST/LOC AMT-DR 06";
label variable OPPWCP06 "OPD NON-DR VISITS-WRKRS COMP AMT-DR 06";
label variable OPPOPR06 "OPD NON-DR VISITS-OTH PRIVATE AMT-DR 06";
label variable OPPOPU06 "OPD NON-DR VISITS-OTH PUBLIC AMT-DR 06";
label variable OPPOSR06 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-DR 06";
label variable AMCHIR06 "# CHIROPRACTR VSTS (OFF+OUTPAT), 2006";
label variable AMCTCH06 "CHIRO AMBULATORY VISIT CHARGES 06";
label variable AMCEXP06 "TOTL AMBULTRY (OB+OP) CHIRO EXP 06";
label variable AMCSLF06 "CHIRO AMB VISITS -SELF/FAMILY AMT 06";
label variable AMCMCR06 "CHIRO AMB VISITS -MEDICARE AMT 06";
label variable AMCMCD06 "CHIRO AMB VISITS -MEDICAID AMT 06";
label variable AMCPRV06 "CHIRO AMB VISITS -PRIVATE INS AMT 06";
label variable AMCVA06 "CHIRO AMB VISITS -VA AMT 06";
label variable AMCTRI06 "CHIRO AMB VISITS-TRICARE AMT 06";
label variable AMCOFD06 "CHIRO AMB VISITS -OTHER FEDERAL AMT 06";
label variable AMCSTL06 "CHIRO AMB VISITS -OTH ST/LOCAL AMT 06";
label variable AMCWCP06 "CHIRO AMB VISITS-WORKERS COMP AMT 06";
label variable AMCOPR06 "CHIRO AMB VISITS - OTH PRIVATE AMT 06";
label variable AMCOPU06 "CHIRO AMB VISITS - OTH PUBLIC AMT 06";
label variable AMCOSR06 "CHIR AMB VSTS - OTH UNCLASS SRCE AMT 06";
label variable AMNURS06 "# AMB NURSE/PRCTITIONR VSTS(OB+OP) 06";
label variable AMNTCH06 "NRS/PRAC AMBULATORY VISIT CHARGES 06";
label variable AMNEXP06 "TOTL AMBULTRY (OB+OP) NURSE/PRAC EXP 06";
label variable AMNSLF06 "NRS/PRAC AMB VSTS -SELF/FAMILY AMT 06";
label variable AMNMCR06 "NRS/PRAC AMB VSTS -MEDICARE AMT 06";
label variable AMNMCD06 "NRS/PRAC AMB VSTS -MEDICAID AMT 06";
label variable AMNPRV06 "NRS/PRAC AMB VSTS -PRIV INS AMT 06";
label variable AMNVA06 "NRS/PRAC AMB VSTS-VA AMT 06";
label variable AMNTRI06 "NRS/PRAC AMB VSTS-TRICARE AMT 06";
label variable AMNOFD06 "NRS/PRAC AMB VSTS-OTHER FEDERAL AMT 06";
label variable AMNSTL06 "NRS/PRAC AMB VSTS-OTH ST/LOCAL AMT 06";
label variable AMNWCP06 "NRS/PRAC AMB VSTS-WORKERS COMP AMT 06";
label variable AMNOPR06 "NRS/PRAC AMB VSTS - OTH PRIVATE AMT 06";
label variable AMNOPU06 "NRS/PRAC AMB VSTS - OTH PUBLIC AMT 06";
label variable AMNOSR06 "NRS/PR AMB VSTS - OTH UNCLAS SRCE AMT 06";
label variable AMOPTO06 "# AMB OPTOMETRIST VSTS (OB+OP) 06";
label variable AMETCH06 "OPTOMETRIST AMBULATORY VISIT CHARGES 06";
label variable AMEEXP06 "TOTL AMBULTRY (OB+OP) OPTOMETRIST EXP 06";
label variable AMESLF06 "OPTMTRIST AMB VSTS -SELF/FAMILY AMT 06";
label variable AMEMCR06 "OPTMTRIST AMB VSTS -MEDICARE AMT 06";
label variable AMEMCD06 "OPTMTRIST AMB VSTS -MEDICAID AMT 06";
label variable AMEPRV06 "OPTMTRIST AMB VSTS -PRIVATE INS AMT 06";
label variable AMEVA06 "OPTMTRIST AMB VSTS-VA AMT 06";
label variable AMETRI06 "OPTMTRIST AMB VSTS-TRICARE AMT 06";
label variable AMEOFD06 "OPTMTRIST AMB VSTS-OTHER FED AMT 06";
label variable AMESTL06 "OPTMTRIST AMB VSTS-OTH ST/LOCAL AMT 06";
label variable AMEWCP06 "OPTMTRIST AMB VSTS-WORKERS COMP AMT 06";
label variable AMEOPR06 "OPTMTRIST AMB VSTS - OTH PRIVATE AMT 06";
label variable AMEOPU06 "OPTMTRIST AMB VSTS - OTH PUBLIC AMT 06";
label variable AMEOSR06 "OPTOM AMB VSTS - OTH UNCLAS SRCE AMT 06";
label variable AMASST06 "# PHYSICIAN ASS T VSTS (OFF+OUPAT), 2006";
label variable AMATCH06 "PHYS ASS T AMBULATORY VISIT CHARGES 06";
label variable AMAEXP06 "TOTL AMBULTRY (OB+OP) PHYS ASS T EXP 06";
label variable AMASLF06 "PHYS ASS T AMB VSTS-SELF/FAMILY AMT 06";
label variable AMAMCR06 "PHYS ASS T AMB VSTS-MEDICARE AMT 06";
label variable AMAMCD06 "PHYS ASS T AMB VSTS-MEDICAID AMT 06";
label variable AMAPRV06 "PHYS ASS T AMB VSTS-PRIVATE INS AMT 06";
label variable AMAVA06 "PHYS ASS T AMB VSTS-VA AMT 06";
label variable AMATRI06 "PHYS ASS T AMB VSTS-TRICARE AMT 06";
label variable AMAOFD06 "PHYS ASS T AMB VSTS -OTHER FED AMT 06";
label variable AMASTL06 "PHYS ASS T AMB VSTS-OTH ST/LOCL AMT 06";
label variable AMAWCP06 "PHYS ASS T AMB VSTS-WRKERS COMP AMT 06";
label variable AMAOPR06 "PHYS ASS T AMB VSTS - OTH PRIVATE AMT 06";
label variable AMAOPU06 "PHYS ASS T AMB VSTS - OTH PUBLIC AMT 06";
label variable AMAOSR06 "P A AMB VSTS- OTH UNCLASS SRCE AMT 06";
label variable AMTHER06 "# AMB PT/OT THRPY VISITS (OB+OP) 06";
label variable AMTTCH06 "PT/OC AMBULATORY VISIT CHARGES 06";
label variable AMTEXP06 "TOTL AMBULTRY (OB+OP) PT/OT EXP 06";
label variable AMTSLF06 "PT/OT AMB VISITS-SELF/FAMILY AMT 06";
label variable AMTMCR06 "PT/OT AMB VISITS-MEDICARE AMT 06";
label variable AMTMCD06 "PT/OT AMB VISITS-MEDICAID AMT 06";
label variable AMTPRV06 "PT/OT AMB VISITS-PRIVATE INS AMT 06";
label variable AMTVA06 "PT/OT AMB VISITS-VA AMT 06";
label variable AMTTRI06 "PT/OT AMB VISITS-TRICARE AMT 06";
label variable AMTOFD06 "PT/OT AMB VISITS -OTHER FED AMT 06";
label variable AMTSTL06 "PT/OT AMB VISITS-OTH ST/LOCL AMT 06";
label variable AMTWCP06 "PT/OT AMB VISITS-WORKERS COMP AMT 06";
label variable AMTOPR06 "PT/OT AMB VISITS - OTH PRIVATE AMT 06";
label variable AMTOPU06 "PT/OT AMB VISITS-OTH PUBLIC AMT 06";
label variable AMTOSR06 "PT/OT AMB VSTS-OTH UNCLAS SRCE AMT 06";
label variable AMTOTC06 "# CALLS W/OFFICE & OUPAT DEPTS, 2006";
label variable AMDRC06 "# CALLS W/OFF & OUTPAT PHYSICIANS, 2006";
label variable ERTOT06 "# EMERGENCY ROOM VISITS 06";
label variable ERFTCH06 "ER FACILITY VISIT CHARGES 06";
label variable ERFEXP06 "TOTAL ER FACILITY EXP 06";
label variable ERFSLF06 "ER-SELF/FAMILY AMT - FAC 06";
label variable ERFMCR06 "ER-MEDICARE AMT - FAC 06";
label variable ERFMCD06 "ER-MEDICAID AMT - FAC 06";
label variable ERFPRV06 "ER-PRIVATE INS AMT - FAC 06";
label variable ERFVA06 "ER-VA AMT - FAC 06";
label variable ERFTRI06 "ER-TRICARE AMT - FAC 06";
label variable ERFOFD06 "ER-OTHER FEDERAL AMT - FAC 06";
label variable ERFSTL06 "ER-OTH ST/LOCAL AMT - FAC 06";
label variable ERFWCP06 "ER-WORKERS COMP AMT - FAC 06";
label variable ERFOPR06 "ER-OTHER PRIVATE AMT - FAC 06";
label variable ERFOPU06 "ER-OTHER PUBLIC AMT - FAC 06";
label variable ERFOSR06 "ER-OTH UNCLASS SRCE AMT - FAC 06";
label variable ERDEXP06 "TOTAL EMERGENCY ROOM DR EXP 06";
label variable ERDTCH06 "ER DOCTOR VISIT CHARGES 06";
label variable ERDSLF06 "ER-SELF/FAMILY AMT - DR 06";
label variable ERDMCR06 "ER-MEDICARE AMT - DR 06";
label variable ERDMCD06 "ER-MEDICAID AMT - DR 06";
label variable ERDPRV06 "ER-PRIVATE INS AMT - DR 06";
label variable ERDVA06 "ER-VA AMT - DR 06";
label variable ERDTRI06 "ER-TRICARE AMT - DR 06";
label variable ERDOFD06 "ER-OTHER FED AMT - DR 06";
label variable ERDSTL06 "ER-OTH ST/LOCAL AMT - DR 06";
label variable ERDWCP06 "ER-WORKERS COMP AMT - DR 06";
label variable ERDOPR06 "ER - OTHER PRIVATE AMT - DR 06";
label variable ERDOPU06 "ER - OTHER PUBLIC AMT - DR 06";
label variable ERDOSR06 "ER-OTH UNCLASS SRCE AMT - DR 06";
label variable IPZERO06 "# ZERO-NIGHT HOSPITAL STAYS 06";
label variable ZIFTCH06 "ZERO-NITE IP STAY CHARGES - FAC 06";
label variable ZIFEXP06 "TOTAL ZERO-NITE STAYS FAC EXP 06";
label variable ZIFSLF06 "ZERO-NITE IP STAZ -SELF/FAM AMT-FAC 06";
label variable ZIFMCR06 "ZERO-NITE IP STAZ-MEDICARE AMT-FAC 06";
label variable ZIFMCD06 "ZERO-NITE IP STAZ-MEDICAID AMT-FAC 06";
label variable ZIFPRV06 "ZERO-NITE IP STAZ-PRIV INS AMT-FAC 06";
label variable ZIFVA06 "ZERO-NITE IP STAZ-VA AMT-FAC 06";
label variable ZIFTRI06 "ZERO-NITE IP STAZ-TRICARE AMT-FAC 06";
label variable ZIFOFD06 "ZERO-NITE IP STAZ-OTHER FED AMT-FAC 06";
label variable ZIFSTL06 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-FAC 06";
label variable ZIFWCP06 "ZERO-NITE IP STAZ-WRKERS COMP AMT-FAC 06";
label variable ZIFOPR06 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-FAC 06";
label variable ZIFOPU06 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-FAC 06";
label variable ZIFOSR06 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-FAC 06";
label variable ZIDEXP06 "TOTAL ZERO-NITE STAZ DR 06";
label variable ZIDTCH06 "ZERO-NITE IP STAY CHARGES - DR 06";
label variable ZIDSLF06 "ZERO-NITE IP STAZ-SELF/FAM AMT-DR 06";
label variable ZIDMCR06 "ZERO-NITE IP STAZ-MEDICARE AMT-DR 06";
label variable ZIDMCD06 "ZERO-NITE IP STAZ-MEDICAID AMT-DR 06";
label variable ZIDPRV06 "ZERO-NITE IP STAZ-PRIV INS AMT-DR 06";
label variable ZIDVA06 "ZERO-NITE IP STAZ-VA AMT-DR 06";
label variable ZIDTRI06 "ZERO-NITE IP STAZ-TRICARE AMT-DR 06";
label variable ZIDOFD06 "ZERO-NITE IP STAZ-OTHER FED AMT-DR 06";
label variable ZIDSTL06 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-DR 06";
label variable ZIDWCP06 "ZERO-NITE IP STAZ-WRKERS COMP AMT-DR 06";
label variable ZIDOPR06 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-DR 06";
label variable ZIDOPU06 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-DR 06";
label variable ZIDOSR06 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-DR 06";
label variable IPDIS06 "# HOSPITAL DISCHARGES, 2006";
label variable IPFEXP06 "TOT HOSP IP FACILITY EXP-INC 0 NITES 06";
label variable IPFTCH06 "IP HOSP STAY CHARGES - FAC 06";
label variable IPFSLF06 "IP HOSP STAZ-SELF/FAMILY AMT-FAC 06";
label variable IPFMCR06 "IP HOSP STAZ-MEDICARE AMT-FAC 06";
label variable IPFMCD06 "IP HOSP STAZ-MEDICAID AMT-FAC 06";
label variable IPFPRV06 "IP HOSP STAZ-PRIV INS AMT-FAC 06";
label variable IPFVA06 "IP HOSP STAZ-VA AMT-FAC 06";
label variable IPFTRI06 "IP HOSP STAZ-TRICARE AMT-FAC 06";
label variable IPFOFD06 "IP HOSP STAZ-OTHER FED AMT-FAC 06";
label variable IPFSTL06 "IP HOSP STAZ-OTH ST/LOCAL AMT-FAC 06";
label variable IPFWCP06 "IP HOSP STAZ-WORKERS COMP AMT-FAC 06";
label variable IPFOPR06 "IP HOSP STAZ - OTH PRIVATE AMT-FAC 06";
label variable IPFOPU06 "IP HOSP STAZ - OTH PUBLIC AMT-FAC 06";
label variable IPFOSR06 "IP HOSP STAZ-OT UNCLASS SRCE AMT-FAC 06";
label variable IPDEXP06 "TOTL HOSP STAZ DR EXP 06";
label variable IPDTCH06 "IP HOSP STAY CHARGES - DR 06";
label variable IPDSLF06 "IP HOSP STAZ-SELF/FAMILY AMT-DR 06";
label variable IPDMCR06 "IP HOSP STAZ-MEDICARE AMT- DR 06";
label variable IPDMCD06 "IP HOSP STAZ-MEDICAID AMT-DR 06";
label variable IPDPRV06 "IP HOSP STAZ-PRIV INS AMT- DR 06";
label variable IPDVA06 "IP HOSP STAZ-VA AMT-DR 06";
label variable IPDTRI06 "IP HOSP STAZ-TRICARE AMT-DR 06";
label variable IPDOFD06 "IP HOSP STAZ-OTHER FED AMT-DR 06";
label variable IPDSTL06 "IP HOSP STAZ-OTH ST/LOCAL AMT-DR 06";
label variable IPDWCP06 "IP HOSP STAZ-WORKERS COMP AMT-DR 06";
label variable IPDOPR06 "IP HOSP STAZ - OTH PRIVATE AMT-DR 06";
label variable IPDOPU06 "IP HOSP STAZ - OTH PUBLIC AMT-DR 06";
label variable IPDOSR06 "IP HOSP STAZ-OT UNCLASS SORCE AMT-DR 06";
label variable IPNGTD06 "# NIGHTS IN HOSP FOR DISCHARGES, 2006";
label variable DVTOT06 "# DENTAL CARE VISITS 06";
label variable DVTTCH06 "TOTAL DENTAL CARE VISIT CHARGES 06";
label variable DVTEXP06 "TOTAL DENTAL CARE EXP 06";
label variable DVTSLF06 "ALL DENTAL CARE -SELF/FAMILY AMT 06";
label variable DVTMCR06 "ALL DENTAL CARE -MEDICARE AMT 06";
label variable DVTMCD06 "ALL DENTAL CARE -MEDICAID AMT 06";
label variable DVTPRV06 "ALL DENTAL CARE -PRIVATE INS AMT 06";
label variable DVTVA06 "ALL DENTAL CARE -VA AMT 06";
label variable DVTTRI06 "ALL DENTAL CARE -TRICARE AMT 06";
label variable DVTOFD06 "ALL DENTAL CARE -OTHER FEDRL AMT 06";
label variable DVTSTL06 "ALL DENTAL CARE -OTH ST/LOCAL AMT 06";
label variable DVTWCP06 "ALL DENTAL CARE -WORKERS COMP AMT 06";
label variable DVTOPR06 "ALL DENTAL CARE - OTH PRIVATE AMT 06";
label variable DVTOPU06 "ALL DENTAL CARE - OTH PUBLIC AMT 06";
label variable DVTOSR06 "ALL DENT CARE-OT UNCLASS SRCE AMT 06";
label variable DVGEN06 "# GENERAL DENTIST VISITS 06";
label variable DVGTCH06 "GENERAL DENTAL CARE VISIT CHARGES 06";
label variable DVGEXP06 "TOTAL GENERAL DENTIST EXP 06";
label variable DVGSLF06 "GNRL DENTAL VISITS -SELF/FAM AMT 06";
label variable DVGMCR06 "GNRL DENTAL VISITS -MEDICARE AMT 06";
label variable DVGMCD06 "GNRL DENTAL VISITS -MEDICAID AMT 06";
label variable DVGPRV06 "GNRL DENTAL VISITS -PRIVATE INS AMT 06";
label variable DVGVA06 "GNRL DENTAL VISITS -VA AMT 06";
label variable DVGTRI06 "GNRL DENTAL VISITS-TRICARE AMT 06";
label variable DVGOFD06 "GNRL DENTAL VISITS- OTHER FED AMT 06";
label variable DVGSTL06 "GNRL DENTAL VISITS - OTH ST/LOCAL AMT 06";
label variable DVGWCP06 "GNRL DENTAL VISITS - WORKERS COMP AMT 06";
label variable DVGOPR06 "GNRL DENTAL VISITS - OTH PRIVATE AMT 06";
label variable DVGOPU06 "GNRL DENTAL VISITS - OTH PUBLIC AMT 06";
label variable DVGOSR06 "GNRL DENT VSTS - OT UNCLASS SRCE AMT 06";
label variable DVORTH06 "# ORTHODONTIST VISITS 06";
label variable DVOTCH06 "ORTHODONTIST VISIT CHARGES 06";
label variable DVOEXP06 "TOTAL ORTHODONTIST EXP 06";
label variable DVOSLF06 "ORTHODONTIST VISITS -SELF/FAMILY AMT 06";
label variable DVOMCR06 "ORTHODONTIST VISITS -MEDICARE AMT 06";
label variable DVOMCD06 "ORTHODONTIST VISITS -MEDICAID AMT 06";
label variable DVOPRV06 "ORTHODONTIST VISITS -PRIVATE INS AMT 06";
label variable DVOVA06 "ORTHODONTIST VISITS-VA AMT 06";
label variable DVOTRI06 "ORTHODONTIST VISITS-TRICARE AMT 06";
label variable DVOOFD06 "ORTHODONTIST VISITS-OTHR FED AMT 06";
label variable DVOSTL06 "ORTHODONTIST VISITS-OTHR ST/LOCAL AMT 06";
label variable DVOWCP06 "ORTHODONTIST VISITS-WORKERS COMP AMT 06";
label variable DVOOPR06 "ORTHODONTIST VISITS-OTHR PRIVATE AMT 06";
label variable DVOOPU06 "ORTHODONTIST VISITS-OTHR PUBLIC AMT 06";
label variable DVOOSR06 "ORTHODONT VSTS - OT UNCLASS SRCE AMT 06";
label variable HHTOTD06 "# HOME HEALTH PROVIDER DAYS, 2006";
label variable HHAGD06 "# AGENCY HOME HEALTH PROVIDER DAYS 06";
label variable HHATCH06 "HOME HEALTH AGENCY VISIT CHARGES 06";
label variable HHAEXP06 "TOTAL HOME HEALTH AGENCY EXP 06";
label variable HHASLF06 "HOME HLTH AGENCY -SELF/FAMILY AMT 06";
label variable HHAMCR06 "HOME HLTH AGENCY -MEDICARE AMT 06";
label variable HHAMCD06 "HOME HLTH AGENCY -MEDICAID AMT 06";
label variable HHAPRV06 "HOME HLTH AGENCY -PRIVATE INS AMT 06";
label variable HHAVA06 "HOME HLTH AGENCY-VA AMT 06";
label variable HHATRI06 "HOME HLTH AGENCY-TRICARE AMT 06";
label variable HHAOFD06 "HOME HLTH AGENCY-OTHER FED AMT 06";
label variable HHASTL06 "HOME HLTH AGENCY-OTHR ST/LOCAL AMT 06";
label variable HHAWCP06 "HOME HLTH AGENCY- WORKERS COMP AMT 06";
label variable HHAOPR06 "HOME HLTH AGENCY - OTH PRIVATE AMT 06";
label variable HHAOPU06 "HOME HLTH AGENCY - OTH PUBLIC AMT 06";
label variable HHAOSR06 "H HLTH AGENCY - OT UNCLASS SRCE AMT 06";
label variable HHINDD06 "# NON-AGENCY HOME HEALTH PROVIDR DAYS 06";
label variable HHNTCH06 "HOME HEALTH NON-AGENCY VISIT CHARGES 06";
label variable HHNEXP06 "TOTAL HOME HEALTH NON-AGNCY EXP 06";
label variable HHNSLF06 "HOME HLTH NON-AGNCY -SELF/FAM AMT 06";
label variable HHNMCR06 "HOME HLTH NON-AGNCY -MEDICARE AMT 06";
label variable HHNMCD06 "HOME HLTH NON-AGNCY -MEDICAID AMT 06";
label variable HHNPRV06 "HOME HLTH NON-AGNCY -PRIV INS AMT 06";
label variable HHNVA06 "HOME HLTH NON-AGNCY-VA AMT 06";
label variable HHNTRI06 "HOME HLTH NON-AGNCY-TRICARE AMT 06";
label variable HHNOFD06 "HOME HLTH NON-AGNCY-OTHR FED AMT 06";
label variable HHNSTL06 "HOME HLTH NON-AGNCY-OTHR ST/LOCL AMT 06";
label variable HHNWCP06 "HOME HLTH NON-AGNCY-WORKERS COMP AMT 06";
label variable HHNOPR06 "HOME HLTH NON-AGNCY-OTH PRIVATE AMT 06";
label variable HHNOPU06 "HOME HLTH NON-AGNCY-OTH PUBLIC AMT 06";
label variable HHNOSR06 "H HLTH NON-AGNCY-OT UNCLASS SRCE AMT 06";
label variable HHINFD06 "# INFORMAL HOME HEALTH PROVIDER DAYS 06";
label variable VISEXP06 "TOTAL GLASSES/CONTACT LENS EXP 06";
label variable VISTCH06 "GLASSES/CONTACT LENSES CHARGES 06";
label variable VISSLF06 "GLASSES/CNTCT LENSES -SELF/FAM AMT 06";
label variable VISMCR06 "GLASSES/CNTCT LENSES-MEDICARE AMT 06";
label variable VISMCD06 "GLASSES/CNTCT LENSES-MEDICAID AMT 06";
label variable VISPRV06 "GLASSES/CNTCT LENSES-PRIV INS AMT 06";
label variable VISVA06 "GLASSES/CNTCT LENSES-VA AMT 06";
label variable VISTRI06 "GLASSES/LENSES-TRICARE AMT 06";
label variable VISOFD06 "GLASSES/CNTCT LENSES-OTHR FED AMT 06";
label variable VISSTL06 "GLASSES/CNTCT LENSES-OTH ST/LOCL AMT 06";
label variable VISWCP06 "GLASSES/CNTCT LENSES-WORKERS COMP AMT 06";
label variable VISOPR06 "GLASSES/CNTCT LENSES-OTH PRIVATE AMT 06";
label variable VISOPU06 "GLASSES/CNTCT LENSES-OTH PUBLIC AMT 06";
label variable VISOSR06 "GLASES/CNTCT LENSE-OT UNCLAS SRCE AMT 06";
label variable OTHTCH06 "OTHER EQUP/SUPPLIES CHARGES 06";
label variable OTHEXP06 "TOT OTHER EQUIP/SPLY (EXCL DIAB) EXP 06";
label variable OTHSLF06 "OTHER EQUP/SUPPLIES -SELF/FAM AMT 06";
label variable OTHMCR06 "OTHER EQUP/SUPPLIES-MEDICARE AMT 06";
label variable OTHMCD06 "OTHER EQUP/SUPPLIES-MEDICAID AMT 06";
label variable OTHPRV06 "OTHER EQUP/SUPPLIES-PRIV INS AMT 06";
label variable OTHVA06 "OTHER EQUP/SUPPLY-VA AMT 06";
label variable OTHTRI06 "OTHER EQUP/SUPPLY-TRICARE AMT 06";
label variable OTHOFD06 "OTHER EQUP/SUPPLIES-OTHR FEDRL AMT 06";
label variable OTHSTL06 "OTHER EQUP/SUPPLY-OTHR ST/LOCAL AMT 06";
label variable OTHWCP06 "OTHER EQUP/SUPPLY -WORKERS COMP AMT 06";
label variable OTHOPR06 "OTHER EQUP/SUPPLY-OTH PRIVATE AMT 06";
label variable OTHOPU06 "OTHER EQUP/SUPPLY -OTH PUBLIC AMT 06";
label variable OTHOSR06 "OTH EQUP/SUPLY -OT UNCLASS SRCE AMT 06";
label variable RXTOT06 "# PRESC MEDS INCL REFILLS 06";
label variable RXEXP06 "TOTAL RX-EXP 06";
label variable RXSLF06 "TOTAL RX-SELF/FAMILY AMT 06";
label variable RXMCR06 "TOTAL RX--MEDICARE AMT 06";
label variable RXMCD06 "TOTAL RX-MEDICAID AMT 06";
label variable RXPRV06 "TOTAL RX-PRIVATE INS AMT 06";
label variable RXVA06 "TOTAL RX-VA AMT 06";
label variable RXTRI06 "TOTAL RX-TRICARE AMT 06";
label variable RXOFD06 "TOTAL RX-OTHER FED AMT 06";
label variable RXSTL06 "TOTAL RX-OTHER ST/LOCAL AMT 06";
label variable RXWCP06 "TOTAL RX-WORKERS COMP AMT 06";
label variable RXOPR06 "TOTAL RX - OTH PRIVATE AMT 06";
label variable RXOPU06 "TOTAL RX - OTH PUBLIC AMT 06";
label variable RXOSR06 "TOT RX-OTH UNCLASS SRCE AMT 06";
label variable PERWT06F "FINAL PERSON WEIGHT, 2006";
label variable FAMWT06F "FINAL FAMILY WEIGHT, 2006";
label variable FAMWT06C "POV ADJ FAMILY WGT-CPS FAM ON 12/31/06";
label variable SAQWT06F "FINAL SAQ-PAQ PERSON WEIGHT, 2006";
label variable DIABW06F "FINAL DIABETES CARE SUPPLEMENT WEIGHT";
label variable VARSTR "VARIANCE ESTIMATION STRATUM - 2006";
label variable VARPSU "VARIANCE ESTIMATION PSU - 2006";


*DEFINE VALUE LABELS FOR REPORTS;
label define H1050001X
         -1 "-1 INAPPLICABLE"
         1 "1 YES" ;

label define H1050002X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1050003X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1050004X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1050005X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050006X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050007X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H1050008X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1050009X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H1050010X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050011X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050012X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050013X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H1050014X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1050015X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H1050016X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050017X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1050018X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1050019X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1050020X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H1050021X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1050022X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050023X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1050024X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1050025X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1050026X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H1050027X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050028X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050029X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050030X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH VERSION SAQ WAS ADMINISTERED"
         2 "2 SPANISH VERSION SAQ WAS ADMINISTERED" ;

label define H1050031X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050032X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050033X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050034X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1050035X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1050036X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1050037X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050038X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BIG PROBLEM"
         2 "2 SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1050039X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1050040X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1050041X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 HAD NO VISITS IN THE LAST 12 MONTHS" ;

label define H1050042X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1050043X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT AT ALL"
         2 "2 A LITTLE BIT"
         3 "3 MODERATELY"
         4 "4 QUITE A BIT"
         5 "5 EXTREMELY" ;

label define H1050044X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1050045X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BIG PROBLEM"
         2 "2 SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1050046X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1050047X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF-ADMINISTERED"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         100 "100 INTERVIEWER ADMINISTERED"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP - /HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 PARTNER'S DAUGHTER"
         33 "33 PARTNER'S SON"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP - /HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 PARENT"
         48 "48 GRANDPARENT"
         49 "49 NOT PERSON ON SAQ LABEL,RELATIONSHIP UNK"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1050048X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1050049X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1050050X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1050051X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1050052X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050053X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1050054X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1050055X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050056X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1050057X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050058X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1050059X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1050060X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AFDC"
         2 "2 NOT AFDC" ;

label define H1050061X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1050062X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050063X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050064X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1050065X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050066X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050067X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050068X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050069X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050070X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050071X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050072X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050073X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050074X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050075X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050076X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050077X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050078X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050079X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050080X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050081X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050082X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050083X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050084X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050085X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         40 "$40" ;

label define H1050086X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050087X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050088X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050089X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050090X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050091X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050092X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050093X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050094X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050095X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050096X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050097X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050098X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050099X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050100X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050101X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050102X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050103X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050104X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050105X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050106X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050107X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050108X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050109X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050110X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         217 "$217" ;

label define H1050111X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050112X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050113X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050114X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050115X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050116X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050117X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050118X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050119X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050120X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050121X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050122X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050123X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050124X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050125X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050126X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050127X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050128X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050129X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050130X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050131X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         289 "$289" ;

label define H1050132X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050133X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050134X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050135X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050136X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050137X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050138X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050139X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050140X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050141X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050142X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050143X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050144X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050145X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 NO VISITS IN LAST 12 MONTHS" ;

label define H1050146X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 NO VISITS IN LAST 12 MONTHS" ;

label define H1050147X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050148X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050149X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050150X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT APPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050151X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050152X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050153X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050154X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050155X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050156X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050157X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050158X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050159X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050160X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050161X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050162X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN LAST 7 DAYS"
         2 "2 MORE THAN 7, BUT WITHIN LAST 30 DAYS"
         3 "3 MORE THAN 30 DAYS AGO" ;

label define H1050163X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050164X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050165X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050166X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1050167X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1050168X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1050169X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2005 "2005 YEAR"
         2006 "2006 YEAR" ;

label define H1050170X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2006 "2006 YEAR" ;

label define H1050171X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2006 "2006 YEAR"
         2007 "2007 YEAR" ;

label define H1050172X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1050173X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1050174X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050175X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050176X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050177X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050178X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050179X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1050180X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050181X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050182X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1050183X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1050184X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1050185X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1050186X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1050187X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050188X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050189X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050190X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H1050191X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050192X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050193X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050194X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1050195X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050196X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1050197X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H1050198X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H1050199X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H1050200X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050201X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1050202X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050203X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NEVER"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS" ;

label define H1050204X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050205X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050206X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050207X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050208X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1050209X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1050210X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050211X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BIG PROBLEM"
         2 "2 SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1050212X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050213X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050214X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050215X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1050216X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050217X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050218X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050219X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050220X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1050221X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1050222X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1050223X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050224X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1050225X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050226X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050227X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050228X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050229X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050230X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050231X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050232X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050233X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050234X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H1050235X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H1050236X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H1050237X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050238X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050239X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNKNOWN" ;

label define H1050240X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1050241X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050242X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050243X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1050244X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050245X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050246X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050247X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050248X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050249X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050250X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050251X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050252X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050253X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050254X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1050255X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ITEMIZED DEDUCTIONS"
         2 "2 STANDARD DEDUCTIONS" ;

label define H1050256X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050257X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 TWICE A YEAR OR MORE"
         2 "2 ONCE A YEAR"
         3 "3 LESS THAN ONCE A YEAR"
         4 "4 NEVER GO TO DENTIST" ;

label define H1050258X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050259X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050260X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050261X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES" ;

label define H1050262X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1050263X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050264X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050265X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050266X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES [WAGE AMOUNT CHANGED]"
         2 "2 NO [WAGE AMOUNT DID NOT CHANGE]" ;

label define H1050267X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES [WAGE AMOUNT CHANGED]"
         2 "2 NO [WAGE AMOUNT DID NOT CHANGE]" ;

label define H1050268X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES [WAGE AMOUNT CHANGED]"
         2 "2 NO [WAGE AMOUNT DID NOT CHANGE]" ;

label define H1050269X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1050270X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1050271X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1050272X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050273X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H1050274X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050275X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050276X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1050277X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1050278X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050279X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050280X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050281X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1050282X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1050283X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1050284X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050285X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050286X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEPS IN RU"
         2 "2 DEPS IN AND OUT OF RU"
         3 "3 DEPS OUT OF RU" ;

label define H1050287X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO DEPENDENTS OUTSIDE RU"
         1 "1 ONE DEPENDENT OUTSIDE RU"
         2 "2 TWO DEPENDENTS OUTSIDE RU"
         3 "3 THREE DEPENDENTS OUTSIDE RU" ;

label define H1050288X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050289X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NUMBER OF TIMES"
         95 "95 95 TIMES OR MORE"
         96 "96 DID NOT HAVE BLOOD TEST" ;

label define H1050290X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NUMBER OF TIMES"
         95 "95 95 TIMES OR MORE" ;

label define H1050291X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050292X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050293X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050294X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050295X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050296X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050297X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050298X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050299X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050300X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050301X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050302X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050303X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050304X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050305X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050306X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050307X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050308X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050309X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050310X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050311X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050312X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050313X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050314X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050315X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050316X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050317X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         103 "$103" ;

label define H1050318X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050319X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050320X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050321X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050322X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050323X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050324X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         221 "$221" ;

label define H1050325X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050326X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050327X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050328X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050329X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050330X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050331X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         300 "$300" ;

label define H1050332X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         87 "$87" ;

label define H1050333X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050334X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050335X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050336X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050337X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050338X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050339X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050340X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050341X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050342X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050343X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050344X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050345X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050346X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050347X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050348X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050349X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO SCHOOL/KINDERGARTEN ONLY"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H1050350X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H1050351X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1050352X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1050353X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1050354X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1050355X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050356X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         3 "3 JOB DURING RD 3/1 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 3/1" ;

label define H1050357X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 4/2 INT DATE"
         3 "3 JOB DURING RD 4/2 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 4/2" ;

label define H1050358X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         3 "3 JOB DURING RD 5/3 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 5/3" ;

label define H1050359X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050360X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050361X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050362X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050363X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1050364X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1050365X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1050366X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1050367X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2006 "2006 YEAR" ;

label define H1050368X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2005 "2005 YEAR"
         2006 "2006 YEAR" ;

label define H1050369X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2006 "2006 YEAR" ;

label define H1050370X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2006 "2006 YEAR"
         2007 "2007 YEAR" ;

label define H1050371X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050372X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050373X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050374X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050375X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050376X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         34 "$34" ;

label define H1050377X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050378X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050379X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050380X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050381X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050382X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050383X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050384X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050385X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050386X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050387X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050388X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050389X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050390X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050391X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050392X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050393X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050394X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050395X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050396X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050397X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050398X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050399X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050400X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050401X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050402X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050403X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050404X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050405X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050406X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050407X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050408X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050409X
         -1 "-1 INAPPLICABLE"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H1050410X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1050411X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1050412X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1050413X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050414X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050415X
         -1 "-1 INAPP, NOT MEM OF 12/31 FAMILY"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H1050416X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050417X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIMARY FILER"
         2 "2 SECONDARY FILER" ;

label define H1050418X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NEVER"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS" ;

label define H1050419X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SINGLE"
         2 "2 MARRIED FILING JOINT RETURN"
         3 "3 MARRIED FILING SEPARATELY"
         4 "4 HEAD OF HOUSEHOLD W/ QUALIFYING PERSON"
         5 "5 QUALIFYING WIDOWER W/ DEPENDENT" ;

label define H1050420X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1050421X
         -1 "-1 INAPPLICABLE"
         0 "0 NONRESPONDING 12/31 FAMILY"
         1 "1 RESPONDING 12/31 FAMILY" ;

label define H1050422X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1050423X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1050424X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050425X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050426X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050427X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1050428X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1050429X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1050430X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1050431X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 DO NOT HAVE PERSONAL DOCTOR OR NURSE" ;

label define H1050432X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 DO NOT HAVE PERSONAL DOCTOR OR NURSE" ;

label define H1050433X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H1050434X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DRIVE"
         2 "2 IS DRIVEN"
         3 "3 TAXI, BUS, TRAIN, OTHER PUBLIC TRANSPO"
         4 "4 WALKS" ;

label define H1050435X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050436X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1050437X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050438X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050439X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050440X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SLIGHT IMPAIRMENT"
         3 "3 MODERATE IMPAIRMENT"
         4 "4 MAJOR IMPAIRMENT"
         5 "5 DEAF" ;

label define H1050441X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050442X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050443X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050444X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050445X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050446X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050447X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050448X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050449X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050450X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050451X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050452X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         273 "$273" ;

label define H1050453X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050454X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050455X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050456X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050457X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050458X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         22 "$22" ;

label define H1050459X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050460X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050461X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050462X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050463X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050464X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050465X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050466X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         5175 "$5175 - $5175"
         6358 "$6359 - $6358" ;

label define H1050467X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         520 "$520" ;

label define H1050468X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050469X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1605 "$1605" ;

label define H1050470X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050471X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050472X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050473X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050474X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050475X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050476X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050477X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050478X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050479X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16-INAPPLICABLE" ;

label define H1050480X
         1 "1 HISPANIC"
         2 "2 NOT HISPANIC" ;

label define H1050481X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PUERTO RICAN"
         2 "2 CUBAN/CUBAN AMERICAN"
         3 "3 DOMINICAN"
         4 "4 MEXICAN/MEXICAN AMERICAN"
         5 "5 CENTRAL OR SOUTH AMERICAN"
         6 "6 NON-HISPANIC"
         91 "91 OTHER LATIN AMERICAN"
         92 "92 OTHER HISPANIC/LATINO" ;

label define H1050482X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1050483X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1050484X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1050485X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1050486X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1050487X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050488X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050489X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050490X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050491X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050492X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050493X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050494X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050495X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050496X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050497X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050498X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050499X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050500X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050501X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050502X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050503X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050504X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050505X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050506X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050507X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050508X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050509X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050510X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050511X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050512X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050513X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050514X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050515X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050516X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050517X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050518X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050519X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050520X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050521X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050522X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050523X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050524X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050525X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050526X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050527X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050528X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050529X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050530X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050531X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050532X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050533X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050534X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050535X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050536X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050537X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050538X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050539X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050540X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050541X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050542X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050543X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050544X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050545X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050546X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050547X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050548X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050549X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050550X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050551X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050552X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050553X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050554X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050555X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050556X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050557X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050558X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050559X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050560X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050561X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050562X
         -1 "-1 INAPPLICABLE"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1050563X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1050564X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1050565X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $72.12"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050566X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $72.12"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050567X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $72.12"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050568X
         0 "0 NO"
         1 "1 YES" ;

label define H1050569X
         0 "0 NO"
         1 "1 YES" ;

label define H1050570X
         0 "0 NO"
         1 "1 YES" ;

label define H1050571X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050572X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050573X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050574X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050575X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050576X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050577X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050578X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050579X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050580X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050581X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1050582X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1050583X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1050584X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050585X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050586X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050587X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050588X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050589X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050590X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050591X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050592X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050593X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050594X
         0 "0 NOT IN-SCOPE - NOT RESP/NOT IN AN RU"
         1 "1 IN-SCOPE ON 12/31/2006"
         2 "2 NOT IN-SCOPE ON 12/31/2006" ;

label define H1050595X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/06"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H1050596X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/06"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H1050597X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/06"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H1050598X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/06"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H1050599X
         0 "0 NOT RECORDED AS BEING INSCOPE"
         1 "1 INSCOPE AT SOME TIME DURING 2006"
         2 "2 OUT-OF-SCOPE FOR ALL OF 2006" ;

label define H1050600X
         1 "1 ANY PRIVATE"
         2 "2 PUBLIC ONLY"
         3 "3 UNINSURED" ;

label define H1050601X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050602X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050603X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050604X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050605X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050606X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050607X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050608X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050609X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050610X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050611X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050612X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050613X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050614X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H1050615X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050616X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ENGLISH & SPANISH"
         91 "91 OTHER" ;

label define H1050617X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050618X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050619X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050620X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050621X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         131 "$131" ;

label define H1050622X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050623X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050624X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050625X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050626X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050627X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050628X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050629X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050630X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050631X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050632X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050633X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050634X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050635X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050636X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050637X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050638X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050639X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050640X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050641X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050642X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050643X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050644X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050645X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050646X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050647X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050648X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1050649X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050650X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050651X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1050652X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1050653X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1050654X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050655X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050656X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050657X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050658X
         -1 "-1 INAPPLICABLE"
         1 "1 KEY"
         2 "2 NOT KEY" ;

label define H1050659X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1050660X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050661X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ANOTHER LANGUAGE" ;

label define H1050662X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050663X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050664X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1050665X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1050666X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050667X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050668X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 OFFICE"
         2 "2 HOSPITAL, NOT ER"
         3 "3 HOSPITAL, ER" ;

label define H1050669X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1050670X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050671X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1050672X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE" ;

label define H1050673X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1050674X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1050675X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1050676X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050677X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050678X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050679X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050680X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050681X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050682X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050683X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050684X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050685X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050686X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050687X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050688X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050689X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050690X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050691X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050692X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050693X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050694X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050695X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050696X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050697X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050698X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050699X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050700X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050701X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050702X
         1 "1 YES"
         2 "2 NO" ;

label define H1050703X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050704X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050705X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1050706X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1050707X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1050708X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050709X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050710X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050711X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050712X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050713X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050714X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050715X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050716X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1050717X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1050718X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1050719X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050720X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050721X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050722X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050723X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050724X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050725X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050726X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050727X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050728X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050729X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050730X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050731X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050732X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050733X
         1 "1 YES"
         2 "2 NO" ;

label define H1050734X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050735X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050736X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050737X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050738X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050739X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050740X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050741X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050742X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050743X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050744X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050745X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050746X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050747X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050748X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050749X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050750X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1050751X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1050752X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1050753X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1050754X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1050755X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1050756X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1050757X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1050758X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1050759X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050760X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050761X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050762X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050763X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1050764X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1050765X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050766X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1050767X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1050768X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H1050769X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050770X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H1050771X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050772X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050773X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1050774X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1050775X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050776X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1050777X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1050778X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1050779X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1050780X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050781X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050782X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050783X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050784X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1050785X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1050786X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1050787X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H1050788X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H1050789X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H1050790X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H1050791X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050792X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050793X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1050794X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1050795X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050796X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050797X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$72.12"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050798X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$72.12"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050799X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$72.12"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050800X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050801X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050802X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050803X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050804X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050805X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WEEKS"
         2 "2 MONTHS" ;

label define H1050806X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050807X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050808X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050809X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050810X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050811X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1050812X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050813X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1050814X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1050815X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1050816X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050817X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050818X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050819X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050820X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050821X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050822X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050823X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050824X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050825X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050826X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050827X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050828X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050829X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050830X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050831X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050832X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050833X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050834X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050835X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         40 "$40" ;

label define H1050836X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050837X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050838X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050839X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050840X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050841X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050842X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050843X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050844X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050845X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050846X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050847X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050848X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050849X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050850X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050851X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050852X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050853X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050854X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050855X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050856X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050857X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050858X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050859X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050860X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050861X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050862X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050863X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050864X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050865X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050866X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050867X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050868X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050869X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050870X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050871X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050872X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050873X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050874X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         217 "$217" ;

label define H1050875X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050876X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050877X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050878X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050879X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050880X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050881X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050882X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050883X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050884X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050885X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050886X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050887X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050888X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050889X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050890X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050891X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050892X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050893X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050894X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050895X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050896X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050897X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050898X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050899X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050900X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050901X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050902X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050903X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050904X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050905X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050906X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050907X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050908X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050909X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050910X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         289 "$289" ;

label define H1050911X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050912X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         134 "$134" ;

label define H1050913X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050914X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050915X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050916X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050917X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050918X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050919X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050920X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050921X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050922X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050923X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050924X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050925X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050926X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050927X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050928X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050929X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050930X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050931X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050932X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050933X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050934X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050935X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050936X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NO WORK EXPERIENCE SINCE 1996"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1050937X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NO WORK EXPERIENCE SINCE 1996"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1050938X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NO WORK EXPERIENCE SINCE 1996"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1050939X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050940X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050941X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050942X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050943X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050944X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050945X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050946X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050947X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050948X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1050949X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050950X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050951X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050952X
         1 "1 YES"
         2 "2 NO" ;

label define H1050953X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050954X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050955X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050956X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050957X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050958X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050959X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050960X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050961X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050962X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050963X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050964X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050965X
         1 "1 YES"
         2 "2 NO" ;

label define H1050966X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050967X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050968X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050969X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050970X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050971X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050972X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050973X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050974X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1050975X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050976X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050977X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050978X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         2 "$2" ;

label define H1050979X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050980X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050981X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050982X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050983X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050984X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050985X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         6 "$6" ;

label define H1050986X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050987X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050988X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050989X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050990X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050991X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050992X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050993X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050994X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050995X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050996X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050997X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050998X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1050999X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051000X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051001X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051002X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051003X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051004X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051005X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051006X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051007X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051008X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051009X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051010X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051011X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051012X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051013X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051014X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051015X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051016X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051017X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051018X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051019X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051020X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051021X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051022X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         11 "$11" ;

label define H1051023X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051024X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051025X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         53 "$53" ;

label define H1051026X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051027X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051028X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         6 "$6" ;

label define H1051029X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051030X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051031X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         15 "$15" ;

label define H1051032X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         20 "$20" ;

label define H1051033X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051034X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051035X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051036X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         2 "$2" ;

label define H1051037X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051038X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051039X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1166 "$1166" ;

label define H1051040X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051041X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051042X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         6 "$6" ;

label define H1051043X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051044X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051045X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051046X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051047X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051048X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051049X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051050X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051051X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051052X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051053X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051054X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051055X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051056X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051057X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051058X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051059X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051060X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051061X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051062X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051063X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051064X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051065X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051066X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1051067X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051068X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051069X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051070X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051071X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051072X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051073X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         308 "$308" ;

label define H1051074X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051075X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051076X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051077X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051078X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051079X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051080X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051081X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051082X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         20 "$20" ;

label define H1051083X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051084X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051085X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051086X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051087X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051088X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051089X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051090X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051091X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051092X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051093X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051094X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051095X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051096X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051097X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051098X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051099X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051100X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051101X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051102X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051103X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051104X
         10 "10 PANEL 10"
         11 "11 PANEL 11" ;

label define H1051105X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1051106X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051107X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051108X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051109X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051110X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051111X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051112X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1051113X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1051114X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1051115X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1051116X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1051117X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1051118X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051119X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051120X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051121X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051122X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051123X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051124X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051125X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051126X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051127X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051128X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051129X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051130X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051131X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051132X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051133X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051134X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051135X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051136X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051137X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051138X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051139X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051140X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051141X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051142X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H1051143X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051144X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051145X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051146X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H1051147X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H1051148X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H1051149X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1051150X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051151X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1051152X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT APPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051153X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051154X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOSPITAL CLINIC/OUTPATIENT DEPT"
         2 "2 HOSPITAL EMERGENCY ROOM"
         3 "3 NON-HOSPITAL PLACE" ;

label define H1051155X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051156X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051157X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051158X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1051159X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1051160X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051161X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051162X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051163X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051164X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051165X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051166X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA"
         5 "5 TRICARE/CHAMPVA"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1051167X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA"
         5 "5 TRICARE/CHAMPVA"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1051168X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA"
         5 "5 TRICARE/CHAMPVA"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1051169X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051170X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051171X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051172X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H1051173X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H1051174X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H1051175X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051176X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1051177X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1051178X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051179X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051180X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051181X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051182X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051183X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051184X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051185X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051186X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051187X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051188X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051189X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051190X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051191X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051192X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051193X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051194X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051195X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051196X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051197X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051198X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051199X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051200X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051201X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051202X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051203X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051204X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051205X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051206X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051207X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051208X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051209X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051210X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051211X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051212X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051213X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051214X
         1 "1 POOR/NEGATIVE"
         2 "2 NEAR POOR"
         3 "3 LOW INCOME"
         4 "4 MIDDLE INCOME"
         5 "5 HIGH INCOME" ;

label define H1051215X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051216X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051217X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST-NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H1051218X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST - NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H1051219X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST - NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H1051220X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051221X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051222X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051223X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051224X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051225X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051226X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051227X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051228X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051229X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051230X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051231X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051232X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051233X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051234X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051235X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051236X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051237X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051238X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051239X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051240X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051241X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051242X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051243X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051244X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051245X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051246X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051247X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051248X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051249X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051250X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051251X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051252X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051253X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051254X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051255X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051256X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051257X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051258X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051259X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051260X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051261X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051262X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051263X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051264X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051265X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051266X
         -1 "-1 INAPPLICABLE"
         1 "1 FACILITY"
         2 "2 PERSON"
         3 "3 PERSON IN FACILITY PROVIDER" ;

label define H1051267X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1051268X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1051269X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1051270X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1051271X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051272X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051273X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051274X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051275X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051276X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051277X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051278X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051279X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051280X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051281X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051282X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051283X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1051284X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1051285X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1051286X
         1 "1 YES"
         2 "2 NO" ;

label define H1051287X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1051288X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1051289X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1051290X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1051291X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1051292X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1051293X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1051294X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1051295X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1051296X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1051297X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051298X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051299X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051300X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051301X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051302X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051303X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051304X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051305X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051306X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051307X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051308X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051309X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1051310X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051311X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051312X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051313X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051314X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051315X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051316X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051317X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051318X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051319X
         -1 "-1 INAPPLICABLE"
         1 "1 ASIAN - NO OTHER RACE REPORTED"
         2 "2 ASIAN - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1051320X
         -1 "-1 INAPPLICABLE"
         1 "1 BLACK - NO OTHER RACE REPORTED"
         2 "2 BLACK - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1051321X
         1 "1 PERSON IS HISPANIC"
         2 "2 PERSON IS BLACK-NO OTH RACE/NOT HISPANIC"
         3 "3 PERSON IS ASIAN-NO OTH RACE/NOT HISPANIC"
         4 "4 OTHER RACE/NOT HISPANIC" ;

label define H1051322X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 WHITE - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1051323X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 BLACK - NO OTHER RACE REPORTED"
         3 "3 AMER INDIAN/ALASKA NATIVE - NO OTH RAC"
         4 "4 ASIAN - NO OTHER RACE REPORTED"
         5 "5 NATIVE HAWAIIAN/PACIFIC ISLANDER-NO OTHR"
         6 "6 MULTIPLE RACES REPORTED" ;

label define H1051324X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1051325X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1051326X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051327X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051328X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051329X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051330X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051331X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1051332X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1051333X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1051334X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1051335X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1051336X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1051337X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1051338X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1051339X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1051340X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1051341X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051342X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051343X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051344X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1051345X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1051346X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1051347X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1051348X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ROUND 1"
         2 "2 ROUND 2"
         3 "3 ROUND 3" ;

label define H1051349X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1051350X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1051351X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1051352X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1051353X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1051354X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1051355X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1051356X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1051357X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1051358X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1051359X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1051360X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1051361X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1051362X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051363X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051364X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051365X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051366X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051367X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051368X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051369X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051370X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051371X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051372X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051373X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051374X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051375X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051376X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051377X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051378X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1051379X
         0 "0 NOT ELIGIBLE"
         1 "1 ELIGIBLE FOR SAQ - HAS SAQ DATA"
         2 "2 ELIGIBLE FOR SAQ - NO SAQ DATA" ;

label define H1051380X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051381X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1051382X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051383X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051384X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1051385X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051386X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051387X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051388X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALWAYS"
         2 "2 NEARLY ALWAYS"
         3 "3 SOMETIMES"
         4 "4 SELDOM"
         5 "5 NEVER"
         6 "6 NEVER DRIVES/RIDES IN A CAR" ;

label define H1051389X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051390X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051391X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051392X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051393X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051394X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H1051395X
         -1 "-1 INAPPLICABLE"
         0 "0 NO"
         1 "1 YES" ;

label define H1051396X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1051397X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1051398X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051399X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051400X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051401X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051402X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051403X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1051404X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1051405X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1051406X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1051407X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1051408X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1051409X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1051410X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1051411X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1051412X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051413X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H1051414X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051415X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISABILITY"
         2 "2 SOME OTHER REASON" ;

label define H1051416X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1051417X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051418X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1051419X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1051420X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1051421X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051422X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051423X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051424X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051425X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051426X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051427X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051428X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051429X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051430X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051431X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051432X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051433X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051434X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051435X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051436X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051437X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1051438X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1051439X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1051440X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1051441X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1051442X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1051443X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1051444X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1051445X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1051446X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1051447X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1051448X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051449X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051450X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H1051451X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H1051452X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051453X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051454X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051455X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051456X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051457X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LONG TERM 1040"
         2 "2 SHORT FORM 1040A"
         3 "3 SHORT FORM 1040EZ"
         91 "91 OTHER" ;

label define H1051458X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1051459X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1051460X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1051461X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051462X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051463X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051464X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051465X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051466X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SORE THROAT"
         2 "2 OTHER SYMPTOMS" ;

label define H1051467X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051468X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 15 MINUTES"
         2 "2 15 TO 30 MINUTES"
         3 "3 31 TO 60 MINUTES (1 HOUR)"
         4 "4 61 TO 90 MINUTES"
         5 "5 91 MINUTES TO 120 MINUTES (2 HOURS)"
         6 "6 MORE THAN 120 MINUTES (2 HOURS)" ;

label define H1051469X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051470X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051471X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051472X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051473X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051474X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051475X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051476X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051477X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051478X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051479X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051480X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051481X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051482X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051483X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051484X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051485X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1051486X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051487X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051488X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051489X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051490X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051491X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051492X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051493X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1051494X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1051495X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1051496X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051497X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051498X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051499X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051500X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051501X
         1 "1 YES"
         2 "2 NO" ;

label define H1051502X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1051503X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1051504X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1051505X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051506X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051507X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051508X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051509X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1051510X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1051511X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1051512X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051513X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051514X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051515X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051516X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1051517X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1051518X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1051519X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1051520X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV  BY TRICARE/CHAMPVA" ;

label define H1051521X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1051522X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1051523X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1051524X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051525X
         -1 "-1 INAPPLICABLE"
         1 "1 MD - GENERAL/FAMILY PRACTICE"
         10 "10 PHYSICIAN'S ASSISTANT"
         11 "11 OTHER NON-MD PROVIDER"
         12 "12 UNKNOWN"
         13 "13 MD - CARDIOLOGIST"
         14 "14 DOCTOR OF OSTEOPATHY"
         15 "15 MD - ENDOCRINOLOGIST"
         16 "16 MD - GASTROENTEROLOGIST"
         17 "17 MD - GERIATRICIAN"
         18 "18 MD - NEPHROLOGIST"
         19 "19 MD - ONCOLOGIST"
         2 "2 MD - INTERNAL MEDICINE"
         20 "20 MD - PULMONOLOGIST"
         21 "21 MD- RHEUMATOLOGIST"
         22 "22 PSYCHIATRIST/PSYCHOLOGIST"
         23 "23 MD - NEUROLOGIST"
         24 "24 ALTERNATIVE CARE PROVIDER"
         3 "3 MD - PEDIATRICS"
         4 "4 MD - OB/GYN"
         5 "5 MD - SURGERY"
         6 "6 MD - OTHER"
         7 "7 CHIROPRACTOR"
         8 "8 NURSE"
         9 "9 NURSE PRACTITIONER" ;

label define H1051526X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051527X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051528X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1051529X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051530X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1051531X
         1 "1 YES"
         2 "2 NO" ;

label define H1051532X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051533X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051534X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051535X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051536X
         1 "1 ORIGINAL RESPONSE USED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1051537X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051538X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051539X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 IMPAIRED NEAR, BUT NOT FAR"
         4 "4 IMPAIRED BOTH NEAR AND FAR"
         5 "5 BLIND" ;

label define H1051540X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051541X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051542X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051543X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051544X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051545X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051546X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051547X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051548X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051549X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051550X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051551X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051552X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051553X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         10 "$10" ;

label define H1051554X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051555X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1051556X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051557X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051558X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051559X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051560X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051561X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051562X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051563X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051564X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051565X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051566X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051567X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051568X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051569X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051570X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051571X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1051572X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS" ;

label define H1051573X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051574X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1051575X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1051576X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS" ;

label define H1051577X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1051578X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1051579X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1051580X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1051581X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1051582X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1051583X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1051584X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1051585X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1051586X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051587X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051588X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051589X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051590X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051591X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051592X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1051593X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1051594X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051595X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051596X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051597X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1051598X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051599X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1051600X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE ANOTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H1051601X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE OTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H1051602X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEM"
         91 "91 SOME OTHER REASON" ;

label define H1051603X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEM"
         91 "91 SOME OTHER REASON" ;

label define H1051604X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEMS"
         91 "91 SOME OTHER REASON" ;

label define H1051605X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELDOM OR NEVER SICK"
         10 "10 INSURANCE-RELATED REASONS"
         11 "11 JOB-RELATED REASONS"
         12 "12 LOOKING FOR A NEW DOCTOR/NO DOCTOR YET"
         13 "13 USC DOCTOR IS SOMEWHERE ELSE"
         14 "14 DON'T LIKE/DON'T TRUST DOCTORS"
         15 "15 HEALTH-RELATED REASONS"
         16 "16 NEWBORN - NO DOCTOR YET"
         17 "17 SELF, RELATIVE, OR FRIEND IS A DOCTOR"
         19 "19 CARE AVAILABLE ON JOB"
         2 "2 RECENTLY MOVED TO AREA"
         20 "20 WILL NOT GO TO THE DOCTOR"
         21 "21 PROBLEMS WITH TIME AND TRANSPORTATION"
         22 "22 GOES TO HOSPITAL/EMERGENCY ROOM/CLINIC"
         23 "23 USES ALTERNATIVE CARE"
         3 "3 DON'T KNOW WHERE TO GO"
         4 "4 USC IN AREA NOT AVAILABLE"
         5 "5 CAN'T FIND PROVIDER WHO SPEAKS LANGUAGE"
         6 "6 GOES DIFFERENT PLACES FOR DIFF NEEDS"
         7 "7 JUST CHANGED INSURANCE PLANS"
         8 "8 DON'T USE DOCS/TREAT SELF"
         9 "9 COST OF MEDICAL CARE"
         91 "91 OTHER REASON" ;

label define H1051606X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051607X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051608X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051609X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051610X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         16 "$16" ;

label define H1051611X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051612X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         15 "$15" ;

label define H1051613X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051614X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051615X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051616X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051617X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051618X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         3291 "$3291" ;

label define H1051619X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         69 "$69" ;

label define H1051620X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051621X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051622X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051623X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         13435 "$13435" ;

label define H1051624X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         954 "$954" ;

label define H1051625X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051626X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         13461 "$13461" ;

label define H1051627X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051628X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051629X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051630X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051631X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         832 "$832" ;

label define H1051632X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1051633X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         257 "$257" ;

* ASSOCIATE VARIABLES WITH VALUE LABEL DEFINITIONS;
label value ACCELI42 H1050001X;
label value ACTDTY31 H1050002X;
label value ACTDTY42 H1050003X;
label value ACTDTY53 H1050004X;
label value ACTLIM31 H1050005X;
label value ACTLIM53 H1050006X;
label value ADAPPT42 H1050007X;
label value ADCAPE42 H1050008X;
label value ADCLIM42 H1050009X;
label value ADCMPD42 H1050010X;
label value ADCMPM42 H1050011X;
label value ADCMPY42 H1050012X;
label value ADDAYA42 H1050013X;
label value ADDOWN42 H1050014X;
label value ADDPRS42 H1050015X;
label value ADDRBP42 H1050016X;
label value ADEFRT42 H1050017X;
label value ADEXPL42 H1050018X;
label value ADGENH42 H1050019X;
label value ADHECR42 H1050020X;
label value ADHOPE42 H1050021X;
label value ADILCR42 H1050022X;
label value ADILWW42 H1050023X;
label value ADINSA42 H1050024X;
label value ADINSB42 H1050025X;
label value ADINTR42 H1050026X;
label value ADL3MO31 H1050027X;
label value ADL3MO42 H1050028X;
label value ADL3MO53 H1050029X;
label value ADLANG42 H1050030X;
label value ADLHLP31 H1050031X;
label value ADLHLP42 H1050032X;
label value ADLHLP53 H1050033X;
label value ADLIST42 H1050034X;
label value ADMALS42 H1050035X;
label value ADMWLM42 H1050036X;
label value ADNDCR42 H1050037X;
label value ADNECP42 H1050038X;
label value ADNERV42 H1050039X;
label value ADNRGY42 H1050040X;
label value ADNSMK42 H1050041X;
label value ADOVER42 H1050042X;
label value ADPAIN42 H1050043X;
label value ADPALS42 H1050044X;
label value ADPRRE42 H1050045X;
label value ADPRTM42 H1050046X;
label value ADPRX42 H1050047X;
label value ADPWLM42 H1050048X;
label value ADRESP42 H1050049X;
label value ADREST42 H1050050X;
label value ADRISK42 H1050051X;
label value ADRTCR42 H1050052X;
label value ADRTWW42 H1050053X;
label value ADSAD42 H1050054X;
label value ADSMOK42 H1050055X;
label value ADSOCA42 H1050056X;
label value ADSPEC42 H1050057X;
label value ADUPRO42 H1050058X;
label value ADWRTH42 H1050059X;
label value AFDC06 H1050060X;
label value AFTHOU42 H1050061X;
label value AIDHLP31 H1050062X;
label value AIDHLP53 H1050063X;
label value ALIIMP06 H1050064X;
label value ALIMP06X H1050065X;
label value AMAEXP06 H1050066X;
label value AMAMCD06 H1050067X;
label value AMAMCR06 H1050068X;
label value AMAOFD06 H1050069X;
label value AMAOPR06 H1050070X;
label value AMAOPU06 H1050071X;
label value AMAOSR06 H1050072X;
label value AMAPRV06 H1050073X;
label value AMASLF06 H1050074X;
label value AMASST06 H1050075X;
label value AMASTL06 H1050076X;
label value AMATCH06 H1050077X;
label value AMATRI06 H1050078X;
label value AMAVA06 H1050079X;
label value AMAWCP06 H1050080X;
label value AMCEXP06 H1050081X;
label value AMCHIR06 H1050082X;
label value AMCMCD06 H1050083X;
label value AMCMCR06 H1050084X;
label value AMCOFD06 H1050085X;
label value AMCOPR06 H1050086X;
label value AMCOPU06 H1050087X;
label value AMCOSR06 H1050088X;
label value AMCPRV06 H1050089X;
label value AMCSLF06 H1050090X;
label value AMCSTL06 H1050091X;
label value AMCTCH06 H1050092X;
label value AMCTRI06 H1050093X;
label value AMCVA06 H1050094X;
label value AMCWCP06 H1050095X;
label value AMDRC06 H1050096X;
label value AMEEXP06 H1050097X;
label value AMEMCD06 H1050098X;
label value AMEMCR06 H1050099X;
label value AMEOFD06 H1050100X;
label value AMEOPR06 H1050101X;
label value AMEOPU06 H1050102X;
label value AMEOSR06 H1050103X;
label value AMEPRV06 H1050104X;
label value AMESLF06 H1050105X;
label value AMESTL06 H1050106X;
label value AMETCH06 H1050107X;
label value AMETRI06 H1050108X;
label value AMEVA06 H1050109X;
label value AMEWCP06 H1050110X;
label value AMNEXP06 H1050111X;
label value AMNMCD06 H1050112X;
label value AMNMCR06 H1050113X;
label value AMNOFD06 H1050114X;
label value AMNOPR06 H1050115X;
label value AMNOPU06 H1050116X;
label value AMNOSR06 H1050117X;
label value AMNPRV06 H1050118X;
label value AMNSLF06 H1050119X;
label value AMNSTL06 H1050120X;
label value AMNTCH06 H1050121X;
label value AMNTRI06 H1050122X;
label value AMNURS06 H1050123X;
label value AMNVA06 H1050124X;
label value AMNWCP06 H1050125X;
label value AMOPTO06 H1050126X;
label value AMTEXP06 H1050127X;
label value AMTHER06 H1050128X;
label value AMTMCD06 H1050129X;
label value AMTMCR06 H1050130X;
label value AMTOFD06 H1050131X;
label value AMTOPR06 H1050132X;
label value AMTOPU06 H1050133X;
label value AMTOSR06 H1050134X;
label value AMTOTC06 H1050135X;
label value AMTPRV06 H1050136X;
label value AMTSLF06 H1050137X;
label value AMTSTL06 H1050138X;
label value AMTTCH06 H1050139X;
label value AMTTRI06 H1050140X;
label value AMTVA06 H1050141X;
label value AMTWCP06 H1050142X;
label value ANGIDX53 H1050143X;
label value ANYLIM06 H1050144X;
label value APRDLM42 H1050145X;
label value APRDLT42 H1050146X;
label value APRTRM42 H1050147X;
label value APRTRT42 H1050148X;
label value ARTHDX53 H1050149X;
label value ARTHTX53 H1050150X;
label value ASACUT53 H1050151X;
label value ASATAK53 H1050152X;
label value ASDALY53 H1050153X;
label value ASEVFL53 H1050154X;
label value ASIANP42 H1050155X;
label value ASMRCN53 H1050156X;
label value ASPKFL53 H1050157X;
label value ASPREV53 H1050158X;
label value ASPRIN53 H1050159X;
label value ASSTIL53 H1050160X;
label value ASTHDX53 H1050161X;
label value ASWNFL53 H1050162X;
label value BEGRFD31 H1050163X;
label value BEGRFD42 H1050164X;
label value BEGRFD53 H1050165X;
label value BEGRFM31 H1050166X;
label value BEGRFM42 H1050167X;
label value BEGRFM53 H1050168X;
label value BEGRFY31 H1050169X;
label value BEGRFY42 H1050170X;
label value BEGRFY53 H1050171X;
label value BENDIF31 H1050172X;
label value BENDIF53 H1050173X;
label value BLCKPR42 H1050174X;
label value BLIND42 H1050175X;
label value BMINDX53 H1050176X;
label value BOOST42 H1050177X;
label value BOWEL53 H1050178X;
label value BPCHEK53 H1050179X;
label value BPMLDX53 H1050180X;
label value BPMONT53 H1050181X;
label value BRSTEX53 H1050182X;
label value BSNTY31 H1050183X;
label value BSNTY42 H1050184X;
label value BSNTY53 H1050185X;
label value BUSIMP06 H1050186X;
label value BUSNP06X H1050187X;
label value CARECO42 H1050188X;
label value CASHP06X H1050189X;
label value CHAPPT42 H1050190X;
label value CHBMIX42 H1050191X;
label value CHCOUN42 H1050192X;
label value CHDDX53 H1050193X;
label value CHECK53 H1050194X;
label value CHEMPB42 H1050195X;
label value CHEXPL42 H1050196X;
label value CHGJ3142 H1050197X;
label value CHGJ4253 H1050198X;
label value CHHECR42 H1050199X;
label value CHILCR42 H1050200X;
label value CHILWW42 H1050201X;
label value CHLAGE53 H1050202X;
label value CHLCHK53 H1050203X;
label value CHLDP06X H1050204X;
label value CHLICO42 H1050205X;
label value CHLIHB42 H1050206X;
label value CHLIMI42 H1050207X;
label value CHLIMP06 H1050208X;
label value CHLIST42 H1050209X;
label value CHNDCR42 H1050210X;
label value CHNECP42 H1050211X;
label value CHOIC31 H1050212X;
label value CHOIC42 H1050213X;
label value CHOIC53 H1050214X;
label value CHOLCK53 H1050215X;
label value CHOLDX53 H1050216X;
label value CHPMCN42 H1050217X;
label value CHPMED42 H1050218X;
label value CHPMHB42 H1050219X;
label value CHPRRE42 H1050220X;
label value CHPRTM42 H1050221X;
label value CHRESP42 H1050222X;
label value CHRTCR42 H1050223X;
label value CHRTWW42 H1050224X;
label value CHSERV42 H1050225X;
label value CHSPEC42 H1050226X;
label value CHSRCN42 H1050227X;
label value CHSRHB42 H1050228X;
label value CHTHCO42 H1050229X;
label value CHTHER42 H1050230X;
label value CHTHHB42 H1050231X;
label value CLINIC42 H1050232X;
label value CLMDEP06 H1050233X;
label value CLMHIP06 H1050234X;
label value COGLIM31 H1050235X;
label value COGLIM53 H1050236X;
label value COVRMM H1050237X;
label value COVRYY H1050238X;
label value CSHCN42 H1050239X;
label value CSHIMP06 H1050240X;
label value CSTSVM42 H1050241X;
label value CSTSVT42 H1050242X;
label value DADPRO42 H1050243X;
label value DDBDYS31 H1050244X;
label value DDBDYS42 H1050245X;
label value DDBDYS53 H1050246X;
label value DDNSCL31 H1050247X;
label value DDNSCL42 H1050248X;
label value DDNSCL53 H1050249X;
label value DDNWRK31 H1050250X;
label value DDNWRK42 H1050251X;
label value DDNWRK53 H1050252X;
label value DEAF42 H1050253X;
label value DECIDE42 H1050254X;
label value DEDUCT06 H1050255X;
label value DENTAL42 H1050256X;
label value DENTCK53 H1050257X;
label value DENTIN31 H1050258X;
label value DENTIN42 H1050259X;
label value DENTIN53 H1050260X;
label value DEPDNT06 H1050261X;
label value DFTOUS42 H1050262X;
label value DIABDX53 H1050263X;
label value DIABW06F H1050264X;
label value DIFFPL42 H1050265X;
label value DIFFWG31 H1050266X;
label value DIFFWG42 H1050267X;
label value DIFFWG53 H1050268X;
label value DISVW31X H1050269X;
label value DISVW42X H1050270X;
label value DISVW53X H1050271X;
label value DIVDP06X H1050272X;
label value DIVIMP06 H1050273X;
label value DKWHRU42 H1050274X;
label value DNDLAY42 H1050275X;
label value DNDLPR42 H1050276X;
label value DNDLRS42 H1050277X;
label value DNTINS06 H1050278X;
label value DNTINS31 H1050279X;
label value DNUNAB42 H1050280X;
label value DNUNPR42 H1050281X;
label value DNUNRS42 H1050282X;
label value DOBMM H1050283X;
label value DOBYY H1050284X;
label value DOCELS42 H1050285X;
label value DPINRU06 H1050286X;
label value DPOTSD06 H1050287X;
label value DRTHRT53 H1050288X;
label value DSA1C53 H1050289X;
label value DSCKFT53 H1050290X;
label value DSDIA53 H1050291X;
label value DSDIET53 H1050292X;
label value DSEB0553 H1050293X;
label value DSEY0553 H1050294X;
label value DSEY0653 H1050295X;
label value DSEY0753 H1050296X;
label value DSEYNV53 H1050297X;
label value DSEYPR53 H1050298X;
label value DSINSU53 H1050299X;
label value DSKIDN53 H1050300X;
label value DSMED53 H1050301X;
label value DSPRX53 H1050302X;
label value DVGEN06 H1050303X;
label value DVGEXP06 H1050304X;
label value DVGMCD06 H1050305X;
label value DVGMCR06 H1050306X;
label value DVGOFD06 H1050307X;
label value DVGOPR06 H1050308X;
label value DVGOPU06 H1050309X;
label value DVGOSR06 H1050310X;
label value DVGPRV06 H1050311X;
label value DVGSLF06 H1050312X;
label value DVGSTL06 H1050313X;
label value DVGTCH06 H1050314X;
label value DVGTRI06 H1050315X;
label value DVGVA06 H1050316X;
label value DVGWCP06 H1050317X;
label value DVOEXP06 H1050318X;
label value DVOMCD06 H1050319X;
label value DVOMCR06 H1050320X;
label value DVOOFD06 H1050321X;
label value DVOOPR06 H1050322X;
label value DVOOPU06 H1050323X;
label value DVOOSR06 H1050324X;
label value DVOPRV06 H1050325X;
label value DVORTH06 H1050326X;
label value DVOSLF06 H1050327X;
label value DVOSTL06 H1050328X;
label value DVOTCH06 H1050329X;
label value DVOTRI06 H1050330X;
label value DVOVA06 H1050331X;
label value DVOWCP06 H1050332X;
label value DVTEXP06 H1050333X;
label value DVTMCD06 H1050334X;
label value DVTMCR06 H1050335X;
label value DVTOFD06 H1050336X;
label value DVTOPR06 H1050337X;
label value DVTOPU06 H1050338X;
label value DVTOSR06 H1050339X;
label value DVTOT06 H1050340X;
label value DVTPRV06 H1050341X;
label value DVTSLF06 H1050342X;
label value DVTSTL06 H1050343X;
label value DVTTCH06 H1050344X;
label value DVTTRI06 H1050345X;
label value DVTVA06 H1050346X;
label value DVTWCP06 H1050347X;
label value EATHLT42 H1050348X;
label value EDUCYR H1050349X;
label value EICRDT06 H1050350X;
label value ELGRND06 H1050351X;
label value ELGRND31 H1050352X;
label value ELGRND42 H1050353X;
label value ELGRND53 H1050354X;
label value EMPHDX53 H1050355X;
label value EMPST31 H1050356X;
label value EMPST42 H1050357X;
label value EMPST53 H1050358X;
label value ENDRFD06 H1050359X;
label value ENDRFD31 H1050360X;
label value ENDRFD42 H1050361X;
label value ENDRFD53 H1050362X;
label value ENDRFM06 H1050363X;
label value ENDRFM31 H1050364X;
label value ENDRFM42 H1050365X;
label value ENDRFM53 H1050366X;
label value ENDRFY06 H1050367X;
label value ENDRFY31 H1050368X;
label value ENDRFY42 H1050369X;
label value ENDRFY53 H1050370X;
label value ENGHME42 H1050371X;
label value ENGSPK42 H1050372X;
label value ERDEXP06 H1050373X;
label value ERDMCD06 H1050374X;
label value ERDMCR06 H1050375X;
label value ERDOFD06 H1050376X;
label value ERDOPR06 H1050377X;
label value ERDOPU06 H1050378X;
label value ERDOSR06 H1050379X;
label value ERDPRV06 H1050380X;
label value ERDSLF06 H1050381X;
label value ERDSTL06 H1050382X;
label value ERDTCH06 H1050383X;
label value ERDTRI06 H1050384X;
label value ERDVA06 H1050385X;
label value ERDWCP06 H1050386X;
label value ERFEXP06 H1050387X;
label value ERFMCD06 H1050388X;
label value ERFMCR06 H1050389X;
label value ERFOFD06 H1050390X;
label value ERFOPR06 H1050391X;
label value ERFOPU06 H1050392X;
label value ERFOSR06 H1050393X;
label value ERFPRV06 H1050394X;
label value ERFSLF06 H1050395X;
label value ERFSTL06 H1050396X;
label value ERFTCH06 H1050397X;
label value ERFTRI06 H1050398X;
label value ERFVA06 H1050399X;
label value ERFWCP06 H1050400X;
label value ERTOT06 H1050401X;
label value EVRETIRE H1050402X;
label value EVRUNAT H1050403X;
label value EVRUNINS H1050404X;
label value EVRWRK H1050405X;
label value EXPLOP42 H1050406X;
label value EXRCIS53 H1050407X;
label value FACLPR42 H1050408X;
label value FAMRFPYR H1050409X;
label value FAMSZE31 H1050410X;
label value FAMSZE42 H1050411X;
label value FAMSZE53 H1050412X;
label value FAMWT06C H1050413X;
label value FAMWT06F H1050414X;
label value FCRP1231 H1050415X;
label value FILEDR06 H1050416X;
label value FILER06 H1050417X;
label value FLSHOT53 H1050418X;
label value FLSTAT06 H1050419X;
label value FLUSHT53 H1050420X;
label value FMRS1231 H1050421X;
label value FNGRDF31 H1050422X;
label value FNGRDF53 H1050423X;
label value FOODMN06 H1050424X;
label value FOODST06 H1050425X;
label value FOODVL06 H1050426X;
label value FTSTU06X H1050427X;
label value FTSTU31X H1050428X;
label value FTSTU42X H1050429X;
label value FTSTU53X H1050430X;
label value GDCPBM42 H1050431X;
label value GDCPBT42 H1050432X;
label value GENDRP42 H1050433X;
label value GOTOUS42 H1050434X;
label value HAVEUS42 H1050435X;
label value HAVFUN42 H1050436X;
label value HEARAD42 H1050437X;
label value HEARDI42 H1050438X;
label value HEARMO42 H1050439X;
label value HEARNG42 H1050440X;
label value HEARSM42 H1050441X;
label value HELD31X H1050442X;
label value HELD42X H1050443X;
label value HELD53X H1050444X;
label value HELMET42 H1050445X;
label value HHAEXP06 H1050446X;
label value HHAGD06 H1050447X;
label value HHAMCD06 H1050448X;
label value HHAMCR06 H1050449X;
label value HHAOFD06 H1050450X;
label value HHAOPR06 H1050451X;
label value HHAOPU06 H1050452X;
label value HHAOSR06 H1050453X;
label value HHAPRV06 H1050454X;
label value HHASLF06 H1050455X;
label value HHASTL06 H1050456X;
label value HHATCH06 H1050457X;
label value HHATRI06 H1050458X;
label value HHAVA06 H1050459X;
label value HHAWCP06 H1050460X;
label value HHINDD06 H1050461X;
label value HHINFD06 H1050462X;
label value HHNEXP06 H1050463X;
label value HHNMCD06 H1050464X;
label value HHNMCR06 H1050465X;
label value HHNOFD06 H1050466X;
label value HHNOPR06 H1050467X;
label value HHNOPU06 H1050468X;
label value HHNOSR06 H1050469X;
label value HHNPRV06 H1050470X;
label value HHNSLF06 H1050471X;
label value HHNSTL06 H1050472X;
label value HHNTCH06 H1050473X;
label value HHNTRI06 H1050474X;
label value HHNVA06 H1050475X;
label value HHNWCP06 H1050476X;
label value HHTOTD06 H1050477X;
label value HIBPDX53 H1050478X;
label value HIDEG H1050479X;
label value HISPANX H1050480X;
label value HISPCAT H1050481X;
label value HLTHLF42 H1050482X;
label value HOMEBH42 H1050483X;
label value HONRDC31 H1050484X;
label value HONRDC42 H1050485X;
label value HONRDC53 H1050486X;
label value HOUR31 H1050487X;
label value HOUR42 H1050488X;
label value HOUR53 H1050489X;
label value HPDAP06 H1050490X;
label value HPDAU06 H1050491X;
label value HPDDE06 H1050492X;
label value HPDFE06 H1050493X;
label value HPDJA06 H1050494X;
label value HPDJL06 H1050495X;
label value HPDJU06 H1050496X;
label value HPDMA06 H1050497X;
label value HPDMY06 H1050498X;
label value HPDNO06 H1050499X;
label value HPDOC06 H1050500X;
label value HPDSE06 H1050501X;
label value HPEAP06 H1050502X;
label value HPEAU06 H1050503X;
label value HPEDE06 H1050504X;
label value HPEFE06 H1050505X;
label value HPEJA06 H1050506X;
label value HPEJL06 H1050507X;
label value HPEJU06 H1050508X;
label value HPEMA06 H1050509X;
label value HPEMY06 H1050510X;
label value HPENO06 H1050511X;
label value HPEOC06 H1050512X;
label value HPESE06 H1050513X;
label value HPNAP06 H1050514X;
label value HPNAU06 H1050515X;
label value HPNDE06 H1050516X;
label value HPNFE06 H1050517X;
label value HPNJA06 H1050518X;
label value HPNJL06 H1050519X;
label value HPNJU06 H1050520X;
label value HPNMA06 H1050521X;
label value HPNMY06 H1050522X;
label value HPNNO06 H1050523X;
label value HPNOC06 H1050524X;
label value HPNSE06 H1050525X;
label value HPOAP06 H1050526X;
label value HPOAU06 H1050527X;
label value HPODE06 H1050528X;
label value HPOFE06 H1050529X;
label value HPOJA06 H1050530X;
label value HPOJL06 H1050531X;
label value HPOJU06 H1050532X;
label value HPOMA06 H1050533X;
label value HPOMY06 H1050534X;
label value HPONO06 H1050535X;
label value HPOOC06 H1050536X;
label value HPOSE06 H1050537X;
label value HPRAP06 H1050538X;
label value HPRAU06 H1050539X;
label value HPRDE06 H1050540X;
label value HPRFE06 H1050541X;
label value HPRJA06 H1050542X;
label value HPRJL06 H1050543X;
label value HPRJU06 H1050544X;
label value HPRMA06 H1050545X;
label value HPRMY06 H1050546X;
label value HPRNO06 H1050547X;
label value HPROC06 H1050548X;
label value HPRSE06 H1050549X;
label value HPSAP06 H1050550X;
label value HPSAU06 H1050551X;
label value HPSDE06 H1050552X;
label value HPSFE06 H1050553X;
label value HPSJA06 H1050554X;
label value HPSJL06 H1050555X;
label value HPSJU06 H1050556X;
label value HPSMA06 H1050557X;
label value HPSMY06 H1050558X;
label value HPSNO06 H1050559X;
label value HPSOC06 H1050560X;
label value HPSSE06 H1050561X;
label value HRHOW31 H1050562X;
label value HRHOW42 H1050563X;
label value HRHOW53 H1050564X;
label value HRWG31X H1050565X;
label value HRWG42X H1050566X;
label value HRWG53X H1050567X;
label value HRWGIM31 H1050568X;
label value HRWGIM42 H1050569X;
label value HRWGIM53 H1050570X;
label value HSELIM31 H1050571X;
label value HSELIM53 H1050572X;
label value HSPLAP42 H1050573X;
label value HYSTER53 H1050574X;
label value IADL3M31 H1050575X;
label value IADL3M42 H1050576X;
label value IADL3M53 H1050577X;
label value IADLHP31 H1050578X;
label value IADLHP42 H1050579X;
label value IADLHP53 H1050580X;
label value INDCAT31 H1050581X;
label value INDCAT42 H1050582X;
label value INDCAT53 H1050583X;
label value INS06X H1050584X;
label value INS31X H1050585X;
label value INS42X H1050586X;
label value INS53X H1050587X;
label value INSAP06X H1050588X;
label value INSAT06X H1050589X;
label value INSAT31X H1050590X;
label value INSAT42X H1050591X;
label value INSAT53X H1050592X;
label value INSAU06X H1050593X;
label value INSC1231 H1050594X;
label value INSCOP06 H1050595X;
label value INSCOP31 H1050596X;
label value INSCOP42 H1050597X;
label value INSCOP53 H1050598X;
label value INSCOPE H1050599X;
label value INSCOV06 H1050600X;
label value INSDE06X H1050601X;
label value INSENDMM H1050602X;
label value INSENDYY H1050603X;
label value INSFE06X H1050604X;
label value INSJA06X H1050605X;
label value INSJL06X H1050606X;
label value INSJU06X H1050607X;
label value INSMA06X H1050608X;
label value INSMY06X H1050609X;
label value INSNO06X H1050610X;
label value INSOC06X H1050611X;
label value INSRPL42 H1050612X;
label value INSSE06X H1050613X;
label value INTIMP06 H1050614X;
label value INTRP06X H1050615X;
label value INTVLANG H1050616X;
label value IPDEXP06 H1050617X;
label value IPDIS06 H1050618X;
label value IPDMCD06 H1050619X;
label value IPDMCR06 H1050620X;
label value IPDOFD06 H1050621X;
label value IPDOPR06 H1050622X;
label value IPDOPU06 H1050623X;
label value IPDOSR06 H1050624X;
label value IPDPRV06 H1050625X;
label value IPDSLF06 H1050626X;
label value IPDSTL06 H1050627X;
label value IPDTCH06 H1050628X;
label value IPDTRI06 H1050629X;
label value IPDVA06 H1050630X;
label value IPDWCP06 H1050631X;
label value IPFEXP06 H1050632X;
label value IPFMCD06 H1050633X;
label value IPFMCR06 H1050634X;
label value IPFOFD06 H1050635X;
label value IPFOPR06 H1050636X;
label value IPFOPU06 H1050637X;
label value IPFOSR06 H1050638X;
label value IPFPRV06 H1050639X;
label value IPFSLF06 H1050640X;
label value IPFSTL06 H1050641X;
label value IPFTCH06 H1050642X;
label value IPFTRI06 H1050643X;
label value IPFVA06 H1050644X;
label value IPFWCP06 H1050645X;
label value IPNGTD06 H1050646X;
label value IPZERO06 H1050647X;
label value IRAIMP06 H1050648X;
label value IRASP06X H1050649X;
label value JNTPID06 H1050650X;
label value JOBORG31 H1050651X;
label value JOBORG42 H1050652X;
label value JOBORG53 H1050653X;
label value JOBRSN42 H1050654X;
label value JTINRU06 H1050655X;
label value JTPAIN53 H1050656X;
label value K6SUM42 H1050657X;
label value KEYNESS H1050658X;
label value KIDPRO42 H1050659X;
label value KNOWDR42 H1050660X;
label value LANGHM42 H1050661X;
label value LANGPR42 H1050662X;
label value LAPBLT42 H1050663X;
label value LFTDIF31 H1050664X;
label value LFTDIF53 H1050665X;
label value LKINFM42 H1050666X;
label value LKINFT42 H1050667X;
label value LOCATN42 H1050668X;
label value LSHLTH42 H1050669X;
label value LSTETH53 H1050670X;
label value MAMOGR53 H1050671X;
label value MARRY06X H1050672X;
label value MARRY31X H1050673X;
label value MARRY42X H1050674X;
label value MARRY53X H1050675X;
label value MCAID06 H1050676X;
label value MCAID06X H1050677X;
label value MCAID31 H1050678X;
label value MCAID31X H1050679X;
label value MCAID42 H1050680X;
label value MCAID42X H1050681X;
label value MCAID53 H1050682X;
label value MCAID53X H1050683X;
label value MCARE06 H1050684X;
label value MCARE06X H1050685X;
label value MCARE31 H1050686X;
label value MCARE31X H1050687X;
label value MCARE42 H1050688X;
label value MCARE42X H1050689X;
label value MCARE53 H1050690X;
label value MCARE53X H1050691X;
label value MCDAP06 H1050692X;
label value MCDAP06X H1050693X;
label value MCDAT06X H1050694X;
label value MCDAT31X H1050695X;
label value MCDAT42X H1050696X;
label value MCDAT53X H1050697X;
label value MCDAU06 H1050698X;
label value MCDAU06X H1050699X;
label value MCDDE06 H1050700X;
label value MCDDE06X H1050701X;
label value MCDEV06 H1050702X;
label value MCDFE06 H1050703X;
label value MCDFE06X H1050704X;
label value MCDHMO06 H1050705X;
label value MCDHMO31 H1050706X;
label value MCDHMO42 H1050707X;
label value MCDJA06 H1050708X;
label value MCDJA06X H1050709X;
label value MCDJL06 H1050710X;
label value MCDJL06X H1050711X;
label value MCDJU06 H1050712X;
label value MCDJU06X H1050713X;
label value MCDMA06 H1050714X;
label value MCDMA06X H1050715X;
label value MCDMC06 H1050716X;
label value MCDMC31 H1050717X;
label value MCDMC42 H1050718X;
label value MCDMY06 H1050719X;
label value MCDMY06X H1050720X;
label value MCDNO06 H1050721X;
label value MCDNO06X H1050722X;
label value MCDOC06 H1050723X;
label value MCDOC06X H1050724X;
label value MCDSE06 H1050725X;
label value MCDSE06X H1050726X;
label value MCRAP06 H1050727X;
label value MCRAP06X H1050728X;
label value MCRAU06 H1050729X;
label value MCRAU06X H1050730X;
label value MCRDE06 H1050731X;
label value MCRDE06X H1050732X;
label value MCREV06 H1050733X;
label value MCRFE06 H1050734X;
label value MCRFE06X H1050735X;
label value MCRJA06 H1050736X;
label value MCRJA06X H1050737X;
label value MCRJL06 H1050738X;
label value MCRJL06X H1050739X;
label value MCRJU06 H1050740X;
label value MCRJU06X H1050741X;
label value MCRMA06 H1050742X;
label value MCRMA06X H1050743X;
label value MCRMY06 H1050744X;
label value MCRMY06X H1050745X;
label value MCRNO06 H1050746X;
label value MCRNO06X H1050747X;
label value MCROC06 H1050748X;
label value MCROC06X H1050749X;
label value MCRPD06 H1050750X;
label value MCRPD06X H1050751X;
label value MCRPD31 H1050752X;
label value MCRPD31X H1050753X;
label value MCRPD42 H1050754X;
label value MCRPD42X H1050755X;
label value MCRPHO06 H1050756X;
label value MCRPHO31 H1050757X;
label value MCRPHO42 H1050758X;
label value MCRSE06 H1050759X;
label value MCRSE06X H1050760X;
label value MCS42 H1050761X;
label value MDDLAY42 H1050762X;
label value MDDLPR42 H1050763X;
label value MDDLRS42 H1050764X;
label value MDUNAB42 H1050765X;
label value MDUNPR42 H1050766X;
label value MDUNRS42 H1050767X;
label value MESBPR42 H1050768X;
label value MESHGT42 H1050769X;
label value MESVIS42 H1050770X;
label value MESWGT42 H1050771X;
label value MIDX53 H1050772X;
label value MILDIF31 H1050773X;
label value MILDIF53 H1050774X;
label value MINORP42 H1050775X;
label value MNHLTH31 H1050776X;
label value MNHLTH42 H1050777X;
label value MNHLTH53 H1050778X;
label value MOMPRO42 H1050779X;
label value MORE31 H1050780X;
label value MORE42 H1050781X;
label value MORE53 H1050782X;
label value MORECOVR H1050783X;
label value MORJOB31 H1050784X;
label value MORJOB42 H1050785X;
label value MORJOB53 H1050786X;
label value MSA06 H1050787X;
label value MSA31 H1050788X;
label value MSA42 H1050789X;
label value MSA53 H1050790X;
label value MYSELF42 H1050791X;
label value NATAMP42 H1050792X;
label value NERVAF42 H1050793X;
label value NEVILL42 H1050794X;
label value NEWARE42 H1050795X;
label value NEWDOC42 H1050796X;
label value NHRWG31 H1050797X;
label value NHRWG42 H1050798X;
label value NHRWG53 H1050799X;
label value NOASPR53 H1050800X;
label value NOFAT53 H1050801X;
label value NOGODR42 H1050802X;
label value NOINSBEF H1050803X;
label value NOINSTM H1050804X;
label value NOINUNIT H1050805X;
label value NOLIKE42 H1050806X;
label value NOREAS42 H1050807X;
label value NOSMOK42 H1050808X;
label value NUMEMP31 H1050809X;
label value NUMEMP42 H1050810X;
label value NUMEMP53 H1050811X;
label value NURSE53 H1050812X;
label value NWK31 H1050813X;
label value NWK42 H1050814X;
label value NWK53 H1050815X;
label value OBAEXP06 H1050816X;
label value OBAMCD06 H1050817X;
label value OBAMCR06 H1050818X;
label value OBAOFD06 H1050819X;
label value OBAOPR06 H1050820X;
label value OBAOPU06 H1050821X;
label value OBAOSR06 H1050822X;
label value OBAPRV06 H1050823X;
label value OBASLF06 H1050824X;
label value OBASST06 H1050825X;
label value OBASTL06 H1050826X;
label value OBATCH06 H1050827X;
label value OBATRI06 H1050828X;
label value OBAVA06 H1050829X;
label value OBAWCP06 H1050830X;
label value OBCEXP06 H1050831X;
label value OBCHIR06 H1050832X;
label value OBCMCD06 H1050833X;
label value OBCMCR06 H1050834X;
label value OBCOFD06 H1050835X;
label value OBCOPR06 H1050836X;
label value OBCOPU06 H1050837X;
label value OBCOSR06 H1050838X;
label value OBCPRV06 H1050839X;
label value OBCSLF06 H1050840X;
label value OBCSTL06 H1050841X;
label value OBCTCH06 H1050842X;
label value OBCTRI06 H1050843X;
label value OBCVA06 H1050844X;
label value OBCWCP06 H1050845X;
label value OBDEXP06 H1050846X;
label value OBDMCD06 H1050847X;
label value OBDMCR06 H1050848X;
label value OBDOFD06 H1050849X;
label value OBDOPR06 H1050850X;
label value OBDOPU06 H1050851X;
label value OBDOSR06 H1050852X;
label value OBDPRV06 H1050853X;
label value OBDRV06 H1050854X;
label value OBDSLF06 H1050855X;
label value OBDSTL06 H1050856X;
label value OBDTCH06 H1050857X;
label value OBDTRI06 H1050858X;
label value OBDVA06 H1050859X;
label value OBDWCP06 H1050860X;
label value OBEEXP06 H1050861X;
label value OBEMCD06 H1050862X;
label value OBEMCR06 H1050863X;
label value OBEOFD06 H1050864X;
label value OBEOPR06 H1050865X;
label value OBEOPU06 H1050866X;
label value OBEOSR06 H1050867X;
label value OBEPRV06 H1050868X;
label value OBESLF06 H1050869X;
label value OBESTL06 H1050870X;
label value OBETCH06 H1050871X;
label value OBETRI06 H1050872X;
label value OBEVA06 H1050873X;
label value OBEWCP06 H1050874X;
label value OBNEXP06 H1050875X;
label value OBNMCD06 H1050876X;
label value OBNMCR06 H1050877X;
label value OBNOFD06 H1050878X;
label value OBNOPR06 H1050879X;
label value OBNOPU06 H1050880X;
label value OBNOSR06 H1050881X;
label value OBNPRV06 H1050882X;
label value OBNSLF06 H1050883X;
label value OBNSTL06 H1050884X;
label value OBNTCH06 H1050885X;
label value OBNTRI06 H1050886X;
label value OBNURS06 H1050887X;
label value OBNVA06 H1050888X;
label value OBNWCP06 H1050889X;
label value OBOEXP06 H1050890X;
label value OBOMCD06 H1050891X;
label value OBOMCR06 H1050892X;
label value OBOOFD06 H1050893X;
label value OBOOPR06 H1050894X;
label value OBOOPU06 H1050895X;
label value OBOOSR06 H1050896X;
label value OBOPRV06 H1050897X;
label value OBOPTO06 H1050898X;
label value OBOSLF06 H1050899X;
label value OBOSTL06 H1050900X;
label value OBOTCH06 H1050901X;
label value OBOTHV06 H1050902X;
label value OBOTRI06 H1050903X;
label value OBOVA06 H1050904X;
label value OBOWCP06 H1050905X;
label value OBTEXP06 H1050906X;
label value OBTHER06 H1050907X;
label value OBTMCD06 H1050908X;
label value OBTMCR06 H1050909X;
label value OBTOFD06 H1050910X;
label value OBTOPR06 H1050911X;
label value OBTOPU06 H1050912X;
label value OBTOSR06 H1050913X;
label value OBTOTV06 H1050914X;
label value OBTPRV06 H1050915X;
label value OBTSLF06 H1050916X;
label value OBTSTL06 H1050917X;
label value OBTTCH06 H1050918X;
label value OBTTRI06 H1050919X;
label value OBTVA06 H1050920X;
label value OBTWCP06 H1050921X;
label value OBVEXP06 H1050922X;
label value OBVMCD06 H1050923X;
label value OBVMCR06 H1050924X;
label value OBVOFD06 H1050925X;
label value OBVOPR06 H1050926X;
label value OBVOPU06 H1050927X;
label value OBVOSR06 H1050928X;
label value OBVPRV06 H1050929X;
label value OBVSLF06 H1050930X;
label value OBVSTL06 H1050931X;
label value OBVTCH06 H1050932X;
label value OBVTRI06 H1050933X;
label value OBVVA06 H1050934X;
label value OBVWCP06 H1050935X;
label value OCCCAT31 H1050936X;
label value OCCCAT42 H1050937X;
label value OCCCAT53 H1050938X;
label value OFFER31X H1050939X;
label value OFFER42X H1050940X;
label value OFFER53X H1050941X;
label value OFFHOU42 H1050942X;
label value OFREMP31 H1050943X;
label value OFREMP42 H1050944X;
label value OFREMP53 H1050945X;
label value OHRTDX53 H1050946X;
label value ONGONG42 H1050947X;
label value ONJOB42 H1050948X;
label value OPAAP06 H1050949X;
label value OPAAU06 H1050950X;
label value OPADE06 H1050951X;
label value OPAEV06 H1050952X;
label value OPAFE06 H1050953X;
label value OPAJA06 H1050954X;
label value OPAJL06 H1050955X;
label value OPAJU06 H1050956X;
label value OPAMA06 H1050957X;
label value OPAMY06 H1050958X;
label value OPANO06 H1050959X;
label value OPAOC06 H1050960X;
label value OPASE06 H1050961X;
label value OPBAP06 H1050962X;
label value OPBAU06 H1050963X;
label value OPBDE06 H1050964X;
label value OPBEV06 H1050965X;
label value OPBFE06 H1050966X;
label value OPBJA06 H1050967X;
label value OPBJL06 H1050968X;
label value OPBJU06 H1050969X;
label value OPBMA06 H1050970X;
label value OPBMY06 H1050971X;
label value OPBNO06 H1050972X;
label value OPBOC06 H1050973X;
label value OPBSE06 H1050974X;
label value OPDEXP06 H1050975X;
label value OPDMCD06 H1050976X;
label value OPDMCR06 H1050977X;
label value OPDOFD06 H1050978X;
label value OPDOPR06 H1050979X;
label value OPDOPU06 H1050980X;
label value OPDOSR06 H1050981X;
label value OPDPRV06 H1050982X;
label value OPDRV06 H1050983X;
label value OPDSLF06 H1050984X;
label value OPDSTL06 H1050985X;
label value OPDTCH06 H1050986X;
label value OPDTRI06 H1050987X;
label value OPDVA06 H1050988X;
label value OPDWCP06 H1050989X;
label value OPFEXP06 H1050990X;
label value OPFMCD06 H1050991X;
label value OPFMCR06 H1050992X;
label value OPFOFD06 H1050993X;
label value OPFOPR06 H1050994X;
label value OPFOPU06 H1050995X;
label value OPFOSR06 H1050996X;
label value OPFPRV06 H1050997X;
label value OPFSLF06 H1050998X;
label value OPFSTL06 H1050999X;
label value OPFTCH06 H1051000X;
label value OPFTRI06 H1051001X;
label value OPFVA06 H1051002X;
label value OPFWCP06 H1051003X;
label value OPOEXP06 H1051004X;
label value OPOMCD06 H1051005X;
label value OPOMCR06 H1051006X;
label value OPOOFD06 H1051007X;
label value OPOOPR06 H1051008X;
label value OPOOPU06 H1051009X;
label value OPOOSR06 H1051010X;
label value OPOPRV06 H1051011X;
label value OPOSLF06 H1051012X;
label value OPOSTL06 H1051013X;
label value OPOTCH06 H1051014X;
label value OPOTHV06 H1051015X;
label value OPOTRI06 H1051016X;
label value OPOVA06 H1051017X;
label value OPOWCP06 H1051018X;
label value OPPEXP06 H1051019X;
label value OPPMCD06 H1051020X;
label value OPPMCR06 H1051021X;
label value OPPOFD06 H1051022X;
label value OPPOPR06 H1051023X;
label value OPPOPU06 H1051024X;
label value OPPOSR06 H1051025X;
label value OPPPRV06 H1051026X;
label value OPPSLF06 H1051027X;
label value OPPSTL06 H1051028X;
label value OPPTCH06 H1051029X;
label value OPPTRI06 H1051030X;
label value OPPVA06 H1051031X;
label value OPPWCP06 H1051032X;
label value OPSEXP06 H1051033X;
label value OPSMCD06 H1051034X;
label value OPSMCR06 H1051035X;
label value OPSOFD06 H1051036X;
label value OPSOPR06 H1051037X;
label value OPSOPU06 H1051038X;
label value OPSOSR06 H1051039X;
label value OPSPRV06 H1051040X;
label value OPSSLF06 H1051041X;
label value OPSSTL06 H1051042X;
label value OPSTCH06 H1051043X;
label value OPSTRI06 H1051044X;
label value OPSVA06 H1051045X;
label value OPSWCP06 H1051046X;
label value OPTOTV06 H1051047X;
label value OPVEXP06 H1051048X;
label value OPVMCD06 H1051049X;
label value OPVMCR06 H1051050X;
label value OPVOFD06 H1051051X;
label value OPVOPR06 H1051052X;
label value OPVOPU06 H1051053X;
label value OPVOSR06 H1051054X;
label value OPVPRV06 H1051055X;
label value OPVSLF06 H1051056X;
label value OPVSTL06 H1051057X;
label value OPVTCH06 H1051058X;
label value OPVTRI06 H1051059X;
label value OPVVA06 H1051060X;
label value OPVWCP06 H1051061X;
label value OTHDYS31 H1051062X;
label value OTHDYS42 H1051063X;
label value OTHDYS53 H1051064X;
label value OTHEXP06 H1051065X;
label value OTHIMP06 H1051066X;
label value OTHINS42 H1051067X;
label value OTHMCD06 H1051068X;
label value OTHMCR06 H1051069X;
label value OTHNDD31 H1051070X;
label value OTHNDD42 H1051071X;
label value OTHNDD53 H1051072X;
label value OTHOFD06 H1051073X;
label value OTHOPR06 H1051074X;
label value OTHOPU06 H1051075X;
label value OTHOSR06 H1051076X;
label value OTHPRV06 H1051077X;
label value OTHRCP42 H1051078X;
label value OTHREA42 H1051079X;
label value OTHRP06X H1051080X;
label value OTHSLF06 H1051081X;
label value OTHSTL06 H1051082X;
label value OTHTCH06 H1051083X;
label value OTHTRI06 H1051084X;
label value OTHVA06 H1051085X;
label value OTHWCP06 H1051086X;
label value OTPAAT06 H1051087X;
label value OTPAAT31 H1051088X;
label value OTPAAT42 H1051089X;
label value OTPAAT53 H1051090X;
label value OTPBAT06 H1051091X;
label value OTPBAT31 H1051092X;
label value OTPBAT42 H1051093X;
label value OTPBAT53 H1051094X;
label value OTPUBA06 H1051095X;
label value OTPUBA31 H1051096X;
label value OTPUBA42 H1051097X;
label value OTPUBA53 H1051098X;
label value OTPUBB06 H1051099X;
label value OTPUBB31 H1051100X;
label value OTPUBB42 H1051101X;
label value OTPUBB53 H1051102X;
label value PACISP42 H1051103X;
label value PANEL H1051104X;
label value PAPSMR53 H1051105X;
label value PAYDR31 H1051106X;
label value PAYDR42 H1051107X;
label value PAYDR53 H1051108X;
label value PAYVAC31 H1051109X;
label value PAYVAC42 H1051110X;
label value PAYVAC53 H1051111X;
label value PBINFM42 H1051112X;
label value PBINFT42 H1051113X;
label value PBPWKM42 H1051114X;
label value PBPWKT42 H1051115X;
label value PBSVCM42 H1051116X;
label value PBSVCT42 H1051117X;
label value PDKAP06 H1051118X;
label value PDKAU06 H1051119X;
label value PDKDE06 H1051120X;
label value PDKFE06 H1051121X;
label value PDKJA06 H1051122X;
label value PDKJL06 H1051123X;
label value PDKJU06 H1051124X;
label value PDKMA06 H1051125X;
label value PDKMY06 H1051126X;
label value PDKNO06 H1051127X;
label value PDKOC06 H1051128X;
label value PDKSE06 H1051129X;
label value PEGAP06 H1051130X;
label value PEGAU06 H1051131X;
label value PEGDE06 H1051132X;
label value PEGFE06 H1051133X;
label value PEGJA06 H1051134X;
label value PEGJL06 H1051135X;
label value PEGJU06 H1051136X;
label value PEGMA06 H1051137X;
label value PEGMY06 H1051138X;
label value PEGNO06 H1051139X;
label value PEGOC06 H1051140X;
label value PEGSE06 H1051141X;
label value PENIMP06 H1051142X;
label value PENSP06X H1051143X;
label value PERSLA42 H1051144X;
label value PERWT06F H1051145X;
label value PHMONP06 H1051146X;
label value PHMONP31 H1051147X;
label value PHMONP42 H1051148X;
label value PHNREG42 H1051149X;
label value PHONE53 H1051150X;
label value PHQ242 H1051151X;
label value PHYACT53 H1051152X;
label value PHYSCL42 H1051153X;
label value PLCTYP42 H1051154X;
label value PMDINS06 H1051155X;
label value PMDINS31 H1051156X;
label value PMDLAY42 H1051157X;
label value PMDLPR42 H1051158X;
label value PMDLRS42 H1051159X;
label value PMEDIN31 H1051160X;
label value PMEDIN42 H1051161X;
label value PMEDIN53 H1051162X;
label value PMEDOP31 H1051163X;
label value PMEDOP42 H1051164X;
label value PMEDOP53 H1051165X;
label value PMEDPY31 H1051166X;
label value PMEDPY42 H1051167X;
label value PMEDPY53 H1051168X;
label value PMEDUP31 H1051169X;
label value PMEDUP42 H1051170X;
label value PMEDUP53 H1051171X;
label value PMNCNP06 H1051172X;
label value PMNCNP31 H1051173X;
label value PMNCNP42 H1051174X;
label value PMUNAB42 H1051175X;
label value PMUNPR42 H1051176X;
label value PMUNRS42 H1051177X;
label value PNGAP06 H1051178X;
label value PNGAU06 H1051179X;
label value PNGDE06 H1051180X;
label value PNGFE06 H1051181X;
label value PNGJA06 H1051182X;
label value PNGJL06 H1051183X;
label value PNGJU06 H1051184X;
label value PNGMA06 H1051185X;
label value PNGMY06 H1051186X;
label value PNGNO06 H1051187X;
label value PNGOC06 H1051188X;
label value PNGSE06 H1051189X;
label value POGAP06 H1051190X;
label value POGAU06 H1051191X;
label value POGDE06 H1051192X;
label value POGFE06 H1051193X;
label value POGJA06 H1051194X;
label value POGJL06 H1051195X;
label value POGJU06 H1051196X;
label value POGMA06 H1051197X;
label value POGMY06 H1051198X;
label value POGNO06 H1051199X;
label value POGOC06 H1051200X;
label value POGSE06 H1051201X;
label value POUAP06 H1051202X;
label value POUAU06 H1051203X;
label value POUDE06 H1051204X;
label value POUFE06 H1051205X;
label value POUJA06 H1051206X;
label value POUJL06 H1051207X;
label value POUJU06 H1051208X;
label value POUMA06 H1051209X;
label value POUMY06 H1051210X;
label value POUNO06 H1051211X;
label value POUOC06 H1051212X;
label value POUSE06 H1051213X;
label value POVCAT06 H1051214X;
label value PPRWKM42 H1051215X;
label value PPRWKT42 H1051216X;
label value PRDRNP06 H1051217X;
label value PRDRNP31 H1051218X;
label value PRDRNP42 H1051219X;
label value PREVCOVR H1051220X;
label value PREVEN42 H1051221X;
label value PRIAP06 H1051222X;
label value PRIAU06 H1051223X;
label value PRIDE06 H1051224X;
label value PRIDK06 H1051225X;
label value PRIDK31 H1051226X;
label value PRIDK42 H1051227X;
label value PRIDK53 H1051228X;
label value PRIEU06 H1051229X;
label value PRIEU31 H1051230X;
label value PRIEU42 H1051231X;
label value PRIEU53 H1051232X;
label value PRIFE06 H1051233X;
label value PRIJA06 H1051234X;
label value PRIJL06 H1051235X;
label value PRIJU06 H1051236X;
label value PRIMA06 H1051237X;
label value PRIMY06 H1051238X;
label value PRING06 H1051239X;
label value PRING31 H1051240X;
label value PRING42 H1051241X;
label value PRING53 H1051242X;
label value PRINO06 H1051243X;
label value PRIOC06 H1051244X;
label value PRIOG06 H1051245X;
label value PRIOG31 H1051246X;
label value PRIOG42 H1051247X;
label value PRIOG53 H1051248X;
label value PRIS06 H1051249X;
label value PRIS31 H1051250X;
label value PRIS42 H1051251X;
label value PRIS53 H1051252X;
label value PRISE06 H1051253X;
label value PRIV06 H1051254X;
label value PRIV31 H1051255X;
label value PRIV42 H1051256X;
label value PRIV53 H1051257X;
label value PRIVAT06 H1051258X;
label value PRIVAT31 H1051259X;
label value PRIVAT42 H1051260X;
label value PRIVAT53 H1051261X;
label value PROUT06 H1051262X;
label value PROUT31 H1051263X;
label value PROUT42 H1051264X;
label value PROUT53 H1051265X;
label value PROVTY42 H1051266X;
label value PROXY06 H1051267X;
label value PROXY31 H1051268X;
label value PROXY42 H1051269X;
label value PROXY53 H1051270X;
label value PRSAP06 H1051271X;
label value PRSAU06 H1051272X;
label value PRSDE06 H1051273X;
label value PRSFE06 H1051274X;
label value PRSJA06 H1051275X;
label value PRSJL06 H1051276X;
label value PRSJU06 H1051277X;
label value PRSMA06 H1051278X;
label value PRSMY06 H1051279X;
label value PRSNO06 H1051280X;
label value PRSOC06 H1051281X;
label value PRSSE06 H1051282X;
label value PRVDRL06 H1051283X;
label value PRVDRL31 H1051284X;
label value PRVDRL42 H1051285X;
label value PRVEV06 H1051286X;
label value PRVHMO06 H1051287X;
label value PRVHMO31 H1051288X;
label value PRVHMO42 H1051289X;
label value PRVMNC06 H1051290X;
label value PRVMNC31 H1051291X;
label value PRVMNC42 H1051292X;
label value PSA53 H1051293X;
label value PSTATS31 H1051294X;
label value PSTATS42 H1051295X;
label value PSTATS53 H1051296X;
label value PUB06X H1051297X;
label value PUB31X H1051298X;
label value PUB42X H1051299X;
label value PUB53X H1051300X;
label value PUBAP06X H1051301X;
label value PUBAT06X H1051302X;
label value PUBAT31X H1051303X;
label value PUBAT42X H1051304X;
label value PUBAT53X H1051305X;
label value PUBAU06X H1051306X;
label value PUBDE06X H1051307X;
label value PUBFE06X H1051308X;
label value PUBIMP06 H1051309X;
label value PUBJA06X H1051310X;
label value PUBJL06X H1051311X;
label value PUBJU06X H1051312X;
label value PUBMA06X H1051313X;
label value PUBMY06X H1051314X;
label value PUBNO06X H1051315X;
label value PUBOC06X H1051316X;
label value PUBP06X H1051317X;
label value PUBSE06X H1051318X;
label value RACEAX H1051319X;
label value RACEBX H1051320X;
label value RACETHNX H1051321X;
label value RACEWX H1051322X;
label value RACEX H1051323X;
label value RCHDIF31 H1051324X;
label value RCHDIF53 H1051325X;
label value READNW42 H1051326X;
label value RECPEP42 H1051327X;
label value REFDP06X H1051328X;
label value REFER53 H1051329X;
label value REFFRL42 H1051330X;
label value REFIMP06 H1051331X;
label value REGION06 H1051332X;
label value REGION31 H1051333X;
label value REGION42 H1051334X;
label value REGION53 H1051335X;
label value RESP06 H1051336X;
label value RESP31 H1051337X;
label value RESP42 H1051338X;
label value RESP53 H1051339X;
label value RESPCT42 H1051340X;
label value RETPLN31 H1051341X;
label value RETPLN42 H1051342X;
label value RETPLN53 H1051343X;
label value RFREL06X H1051344X;
label value RFREL31X H1051345X;
label value RFREL42X H1051346X;
label value RFREL53X H1051347X;
label value RNDFLG31 H1051348X;
label value RTHLTH31 H1051349X;
label value RTHLTH42 H1051350X;
label value RTHLTH53 H1051351X;
label value RTPLNM42 H1051352X;
label value RTPLNT42 H1051353X;
label value RUCLAS06 H1051354X;
label value RUCLAS31 H1051355X;
label value RUCLAS42 H1051356X;
label value RUCLAS53 H1051357X;
label value RUSIZE06 H1051358X;
label value RUSIZE31 H1051359X;
label value RUSIZE42 H1051360X;
label value RUSIZE53 H1051361X;
label value RXEXP06 H1051362X;
label value RXMCD06 H1051363X;
label value RXMCR06 H1051364X;
label value RXOFD06 H1051365X;
label value RXOPR06 H1051366X;
label value RXOPU06 H1051367X;
label value RXOSR06 H1051368X;
label value RXPRV06 H1051369X;
label value RXSLF06 H1051370X;
label value RXSTL06 H1051371X;
label value RXTOT06 H1051372X;
label value RXTRI06 H1051373X;
label value RXVA06 H1051374X;
label value RXWCP06 H1051375X;
label value SAFEST42 H1051376X;
label value SALEP06X H1051377X;
label value SALIMP06 H1051378X;
label value SAQELIG H1051379X;
label value SAQWT06F H1051380X;
label value SCHLBH42 H1051381X;
label value SCHLIM31 H1051382X;
label value SCHLIM53 H1051383X;
label value SCHPRO42 H1051384X;
label value SCLNBD31 H1051385X;
label value SCLNBD42 H1051386X;
label value SCLNBD53 H1051387X;
label value SEATBE53 H1051388X;
label value SEEDIF42 H1051389X;
label value SELDSI42 H1051390X;
label value SELFCM31 H1051391X;
label value SELFCM42 H1051392X;
label value SELFCM53 H1051393X;
label value SEX H1051394X;
label value SFFLAG42 H1051395X;
label value SIBPRO42 H1051396X;
label value SICEAS42 H1051397X;
label value SICPAY31 H1051398X;
label value SICPAY42 H1051399X;
label value SICPAY53 H1051400X;
label value SOCLIM31 H1051401X;
label value SOCLIM53 H1051402X;
label value SPOUID06 H1051403X;
label value SPOUID31 H1051404X;
label value SPOUID42 H1051405X;
label value SPOUID53 H1051406X;
label value SPOUIN06 H1051407X;
label value SPOUIN31 H1051408X;
label value SPOUIN42 H1051409X;
label value SPOUIN53 H1051410X;
label value SPRPRO42 H1051411X;
label value SRTHRT53 H1051412X;
label value SSCIMP06 H1051413X;
label value SSECP06X H1051414X;
label value SSIDIS06 H1051415X;
label value SSIIMP06 H1051416X;
label value SSIP06X H1051417X;
label value SSNLJB31 H1051418X;
label value SSNLJB42 H1051419X;
label value SSNLJB53 H1051420X;
label value STAAP06 H1051421X;
label value STAAU06 H1051422X;
label value STADE06 H1051423X;
label value STAFE06 H1051424X;
label value STAJA06 H1051425X;
label value STAJL06 H1051426X;
label value STAJU06 H1051427X;
label value STAMA06 H1051428X;
label value STAMY06 H1051429X;
label value STANO06 H1051430X;
label value STAOC06 H1051431X;
label value STAPR06 H1051432X;
label value STAPR31 H1051433X;
label value STAPR42 H1051434X;
label value STAPR53 H1051435X;
label value STASE06 H1051436X;
label value STJBDD31 H1051437X;
label value STJBDD42 H1051438X;
label value STJBDD53 H1051439X;
label value STJBMM31 H1051440X;
label value STJBMM42 H1051441X;
label value STJBMM53 H1051442X;
label value STJBYY31 H1051443X;
label value STJBYY42 H1051444X;
label value STJBYY53 H1051445X;
label value STNDIF31 H1051446X;
label value STNDIF53 H1051447X;
label value STOMCH53 H1051448X;
label value STOOL53 H1051449X;
label value STPDIF31 H1051450X;
label value STPDIF53 H1051451X;
label value STPRAT06 H1051452X;
label value STPRAT31 H1051453X;
label value STPRAT42 H1051454X;
label value STPRAT53 H1051455X;
label value STRKDX53 H1051456X;
label value TAXFRM06 H1051457X;
label value TEMPJB31 H1051458X;
label value TEMPJB42 H1051459X;
label value TEMPJB53 H1051460X;
label value THANTB53 H1051461X;
label value THANTF53 H1051462X;
label value THSWAB53 H1051463X;
label value THSWBF53 H1051464X;
label value THSYMF53 H1051465X;
label value THSYMP53 H1051466X;
label value TIMALN42 H1051467X;
label value TMTKUS42 H1051468X;
label value TOTDED06 H1051469X;
label value TOTEXP06 H1051470X;
label value TOTMCD06 H1051471X;
label value TOTMCR06 H1051472X;
label value TOTOFD06 H1051473X;
label value TOTOPR06 H1051474X;
label value TOTOPU06 H1051475X;
label value TOTOSR06 H1051476X;
label value TOTPRV06 H1051477X;
label value TOTSLF06 H1051478X;
label value TOTSTL06 H1051479X;
label value TOTTCH06 H1051480X;
label value TOTTRI06 H1051481X;
label value TOTVA06 H1051482X;
label value TOTWCP06 H1051483X;
label value TRANS42 H1051484X;
label value TRBLE42 H1051485X;
label value TREATM42 H1051486X;
label value TRIAP06X H1051487X;
label value TRIAT06X H1051488X;
label value TRIAT31X H1051489X;
label value TRIAT42X H1051490X;
label value TRIAT53X H1051491X;
label value TRIAU06X H1051492X;
label value TRICH06X H1051493X;
label value TRICH31X H1051494X;
label value TRICH42X H1051495X;
label value TRICR06X H1051496X;
label value TRICR31X H1051497X;
label value TRICR42X H1051498X;
label value TRICR53X H1051499X;
label value TRIDE06X H1051500X;
label value TRIEV06 H1051501X;
label value TRIEX06X H1051502X;
label value TRIEX31X H1051503X;
label value TRIEX42X H1051504X;
label value TRIFE06X H1051505X;
label value TRIJA06X H1051506X;
label value TRIJL06X H1051507X;
label value TRIJU06X H1051508X;
label value TRILI06X H1051509X;
label value TRILI31X H1051510X;
label value TRILI42X H1051511X;
label value TRIMA06X H1051512X;
label value TRIMY06X H1051513X;
label value TRINO06X H1051514X;
label value TRIOC06X H1051515X;
label value TRIPR06X H1051516X;
label value TRIPR31X H1051517X;
label value TRIPR42X H1051518X;
label value TRISE06X H1051519X;
label value TRIST06X H1051520X;
label value TRIST31X H1051521X;
label value TRIST42X H1051522X;
label value TRTIMP06 H1051523X;
label value TTLP06X H1051524X;
label value TYPEPE42 H1051525X;
label value UNABLE31 H1051526X;
label value UNABLE53 H1051527X;
label value UNEIMP06 H1051528X;
label value UNEMP06X H1051529X;
label value UNHAP42 H1051530X;
label value UNINS06 H1051531X;
label value UNION31 H1051532X;
label value UNION42 H1051533X;
label value UNION53 H1051534X;
label value USCNOT42 H1051535X;
label value VETIMP06 H1051536X;
label value VETSP06X H1051537X;
label value VISEXP06 H1051538X;
label value VISION42 H1051539X;
label value VISIT53 H1051540X;
label value VISMCD06 H1051541X;
label value VISMCR06 H1051542X;
label value VISOFD06 H1051543X;
label value VISOPR06 H1051544X;
label value VISOPU06 H1051545X;
label value VISOSR06 H1051546X;
label value VISPRV06 H1051547X;
label value VISSLF06 H1051548X;
label value VISSTL06 H1051549X;
label value VISTCH06 H1051550X;
label value VISTRI06 H1051551X;
label value VISVA06 H1051552X;
label value VISWCP06 H1051553X;
label value WAGEP06X H1051554X;
label value WAGIMP06 H1051555X;
label value WASAFDC H1051556X;
label value WASCHAMP H1051557X;
label value WASESTB H1051558X;
label value WASMCAID H1051559X;
label value WASMCARE H1051560X;
label value WASOTGOV H1051561X;
label value WASOTHER H1051562X;
label value WASPRIV H1051563X;
label value WASSSI H1051564X;
label value WASSTAT1 H1051565X;
label value WASSTAT2 H1051566X;
label value WASSTAT3 H1051567X;
label value WASSTAT4 H1051568X;
label value WASVA H1051569X;
label value WCMPP06X H1051570X;
label value WCPIMP06 H1051571X;
label value WHENST53 H1051572X;
label value WHITPR42 H1051573X;
label value WHNBPR42 H1051574X;
label value WHNBST42 H1051575X;
label value WHNBWL53 H1051576X;
label value WHNDEN42 H1051577X;
label value WHNEAT42 H1051578X;
label value WHNHEL42 H1051579X;
label value WHNHGT42 H1051580X;
label value WHNLAP42 H1051581X;
label value WHNPHY42 H1051582X;
label value WHNSAF42 H1051583X;
label value WHNSMK42 H1051584X;
label value WHNWGT42 H1051585X;
label value WILFIL06 H1051586X;
label value WKINBD31 H1051587X;
label value WKINBD42 H1051588X;
label value WKINBD53 H1051589X;
label value WLK3MO31 H1051590X;
label value WLK3MO53 H1051591X;
label value WLKDIF31 H1051592X;
label value WLKDIF53 H1051593X;
label value WLKLIM31 H1051594X;
label value WLKLIM53 H1051595X;
label value WRGLAS42 H1051596X;
label value WRHLTH42 H1051597X;
label value WRKLIM31 H1051598X;
label value WRKLIM53 H1051599X;
label value YCHJ3142 H1051600X;
label value YCHJ4253 H1051601X;
label value YNOINS31 H1051602X;
label value YNOINS42 H1051603X;
label value YNOINS53 H1051604X;
label value YNOUSC42 H1051605X;
label value ZIDEXP06 H1051606X;
label value ZIDMCD06 H1051607X;
label value ZIDMCR06 H1051608X;
label value ZIDOFD06 H1051609X;
label value ZIDOPR06 H1051610X;
label value ZIDOPU06 H1051611X;
label value ZIDOSR06 H1051612X;
label value ZIDPRV06 H1051613X;
label value ZIDSLF06 H1051614X;
label value ZIDSTL06 H1051615X;
label value ZIDTCH06 H1051616X;
label value ZIDTRI06 H1051617X;
label value ZIDVA06 H1051618X;
label value ZIDWCP06 H1051619X;
label value ZIFEXP06 H1051620X;
label value ZIFMCD06 H1051621X;
label value ZIFMCR06 H1051622X;
label value ZIFOFD06 H1051623X;
label value ZIFOPR06 H1051624X;
label value ZIFOPU06 H1051625X;
label value ZIFOSR06 H1051626X;
label value ZIFPRV06 H1051627X;
label value ZIFSLF06 H1051628X;
label value ZIFSTL06 H1051629X;
label value ZIFTCH06 H1051630X;
label value ZIFTRI06 H1051631X;
label value ZIFVA06 H1051632X;
label value ZIFWCP06 H1051633X;

*DISPLAY A DESCRIPTION OF STATA FILE;
describe;

*LIST FIRST 20 OBSERVATIONS IN THE FILE;
list in 1/20;


#delimit cr


/************************************************************************************************
 NOTES:                                                                                          
                                                                                                 
 1. This program has been tested on Stata Version 10 (for Windows).                              
                                                                                                 
 2. This program will create a permanent Stata dataset.  All additional analyses                 
    can be run using this dataset.  In addition to the dataset, this program creates             
    a log file named H105.LOG and a data file named H105.DTA.  If these files (H105.DTA and H105.LOG)
    already exist in the working directory, they will be replaced when this program is executed. 
                                                                                                 
 3. If the program ends prematurely, the log file will remain open.  Before running this         
    program again, the user should enter the following Stata command: log close                  
                                                                                                 
 4. The cd command assigns C:\MEPS\DATA as the working directory and location of the input       
    ASCII and output .DTA and .LOG files and can be modified by the user as necessary.           
                                                                                                 
 5. Stata commands end with a carriage return by default. The command                            
    #delimit ;                                                                                   
    temporarily changes the command ending delimiter from a carriage return to a semicolon.      
                                                                                                 
 6. The infix command assumes that the input variables are numeric unless the variable name      
    is prefaced by str.  For example, DUPERSID is the a string (or character) variable.          
                                                                                                 
************************************************************************************************/

